/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items.metaitem;

import gregtech.api.items.metaitem.stats.IFoodBehavior;
import gregtech.api.util.GTUtility;
import gregtech.api.util.RandomPotionEffect;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;

public class FoodStats
implements IFoodBehavior {
    public final int foodLevel;
    public final float saturation;
    public final boolean isDrink;
    public final boolean alwaysEdible;
    public final RandomPotionEffect[] potionEffects;
    @Nullable
    public ItemStack containerItem;

    public FoodStats(int foodLevel, float saturation, boolean isDrink, boolean alwaysEdible, ItemStack containerItem, RandomPotionEffect ... potionEffects) {
        this.foodLevel = foodLevel;
        this.saturation = saturation;
        this.isDrink = isDrink;
        this.alwaysEdible = alwaysEdible;
        if (containerItem != null) {
            this.containerItem = containerItem.func_77946_l();
        }
        this.potionEffects = potionEffects;
    }

    public FoodStats(int foodLevel, float saturation, boolean isDrink) {
        this(foodLevel, saturation, isDrink, false, null, new RandomPotionEffect[0]);
    }

    public FoodStats(int foodLevel, float saturation) {
        this(foodLevel, saturation, false);
    }

    @Override
    public int getFoodLevel(ItemStack itemStack, EntityPlayer player) {
        return this.foodLevel;
    }

    @Override
    public float getSaturation(ItemStack itemStack, EntityPlayer player) {
        return this.saturation;
    }

    @Override
    public boolean alwaysEdible(ItemStack itemStack, EntityPlayer player) {
        return this.alwaysEdible;
    }

    @Override
    public EnumAction getFoodAction(ItemStack itemStack) {
        return this.isDrink ? EnumAction.DRINK : EnumAction.EAT;
    }

    @Override
    public void onEaten(ItemStack itemStack, EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            for (RandomPotionEffect potionEffect : this.potionEffects) {
                if (!(Math.random() * 100.0 > (double)potionEffect.chance)) continue;
                player.func_70690_d(GTUtility.copyPotionEffect(potionEffect.effect));
            }
        }
    }

    @Override
    public void addInformation(ItemStack itemStack, List<String> lines) {
        if (this.potionEffects.length > 0) {
            PotionEffect[] effects = new PotionEffect[this.potionEffects.length];
            for (int i = 0; i < this.potionEffects.length; ++i) {
                effects[i] = this.potionEffects[i].effect;
            }
        }
    }
}

