/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.resources;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TextureArea {
    public final ResourceLocation imageLocation;
    public final double offsetX;
    public final double offsetY;
    public final double imageWidth;
    public final double imageHeight;

    public TextureArea(ResourceLocation imageLocation, double offsetX, double offsetY, double width, double height) {
        this.imageLocation = imageLocation;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.imageWidth = width;
        this.imageHeight = height;
    }

    public static TextureArea fullImage(String imageLocation) {
        return new TextureArea(new ResourceLocation("gregtech", imageLocation), 0.0, 0.0, 1.0, 1.0);
    }

    public static TextureArea areaOfImage(String imageLocation, int imageSizeX, int imageSizeY, int u, int v, int width, int height) {
        return new TextureArea(new ResourceLocation(imageLocation), (double)u / ((double)imageSizeX * 1.0), (double)v / ((double)imageSizeY * 1.0), (double)(u + width) / ((double)imageSizeX * 1.0), (double)(v + height) / ((double)imageSizeY * 1.0));
    }

    public TextureArea getSubArea(double offsetX, double offsetY, double width, double height) {
        return new TextureArea(this.imageLocation, this.offsetX + this.imageWidth * offsetX, this.offsetY + this.imageHeight * offsetY, this.imageWidth * width, this.imageHeight * height);
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(int x, int y, int width, int height) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.imageLocation);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a(this.offsetX, this.offsetY + this.imageHeight).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a(this.offsetX + this.imageWidth, this.offsetY + this.imageHeight).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a(this.offsetX + this.imageWidth, this.offsetY).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_187315_a(this.offsetX, this.offsetY).func_181675_d();
        tessellator.func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void drawSubArea(int x, int y, int width, int height, double drawnU, double drawnV, double drawnWidth, double drawnHeight) {
        double imageU = this.offsetX + this.imageWidth * drawnU;
        double imageV = this.offsetY + this.imageHeight * drawnV;
        double imageWidth = this.imageWidth * drawnWidth;
        double imageHeight = this.imageHeight * drawnHeight;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.imageLocation);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a(imageU, imageV + imageHeight).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a(imageU + imageWidth, imageV + imageHeight).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a(imageU + imageWidth, imageV).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_187315_a(imageU, imageV).func_181675_d();
        tessellator.func_78381_a();
    }
}

