/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import gregtech.api.GTValues;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.damagesources.DamageSources;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.IFluidTank;

public class RecipeLogicSteam
extends AbstractRecipeLogic {
    private final IFluidTank steamFluidTank;
    private final boolean isHighPressure;
    private final double conversionRate;
    private boolean needsVenting;
    private boolean ventingStuck;
    private EnumFacing ventingSide;

    public RecipeLogicSteam(MetaTileEntity tileEntity, RecipeMap<?> recipeMap, boolean isHighPressure, IFluidTank steamFluidTank, double conversionRate) {
        super(tileEntity, recipeMap);
        this.steamFluidTank = steamFluidTank;
        this.conversionRate = conversionRate;
        this.isHighPressure = isHighPressure;
    }

    public boolean isVentingStuck() {
        return this.needsVenting && this.ventingStuck;
    }

    public boolean isNeedsVenting() {
        return this.needsVenting;
    }

    @Override
    public void onFrontFacingSet(EnumFacing newFrontFacing) {
        if (this.ventingSide == null) {
            this.setVentingSide(newFrontFacing.func_176734_d());
        }
    }

    public EnumFacing getVentingSide() {
        return this.ventingSide == null ? EnumFacing.SOUTH : this.ventingSide;
    }

    public void setVentingStuck(boolean ventingStuck) {
        this.ventingStuck = ventingStuck;
        if (!this.metaTileEntity.getWorld().field_72995_K) {
            this.metaTileEntity.markDirty();
            this.writeCustomData(4, buf -> buf.writeBoolean(ventingStuck));
        }
    }

    public void setNeedsVenting(boolean needsVenting) {
        this.needsVenting = needsVenting;
        if (!needsVenting && this.ventingStuck) {
            this.setVentingStuck(false);
        }
        if (!this.metaTileEntity.getWorld().field_72995_K) {
            this.metaTileEntity.markDirty();
            this.writeCustomData(2, buf -> buf.writeBoolean(needsVenting));
        }
    }

    public void setVentingSide(EnumFacing ventingSide) {
        this.ventingSide = ventingSide;
        if (!this.metaTileEntity.getWorld().field_72995_K) {
            this.metaTileEntity.markDirty();
            this.writeCustomData(3, buf -> buf.writeByte(ventingSide.func_176745_a()));
        }
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == 2) {
            this.needsVenting = buf.readBoolean();
        } else if (dataId == 3) {
            this.ventingSide = EnumFacing.field_82609_l[buf.readByte()];
            this.getMetaTileEntity().getHolder().scheduleChunkForRenderUpdate();
        } else if (dataId == 4) {
            this.ventingStuck = buf.readBoolean();
        }
    }

    @Override
    public void writeInitialData(PacketBuffer buf) {
        super.writeInitialData(buf);
        buf.writeByte(this.getVentingSide().func_176745_a());
        buf.writeBoolean(this.needsVenting);
        buf.writeBoolean(this.ventingStuck);
    }

    @Override
    public void receiveInitialData(PacketBuffer buf) {
        super.receiveInitialData(buf);
        this.ventingSide = EnumFacing.field_82609_l[buf.readByte()];
        this.needsVenting = buf.readBoolean();
        this.ventingStuck = buf.readBoolean();
    }

    protected void tryDoVenting() {
        BlockPos machinePos = this.metaTileEntity.getPos();
        EnumFacing ventingSide = this.getVentingSide();
        BlockPos ventingBlockPos = machinePos.func_177972_a(ventingSide);
        IBlockState blockOnPos = this.metaTileEntity.getWorld().func_180495_p(ventingBlockPos);
        if (blockOnPos.func_185890_d((IBlockAccess)this.metaTileEntity.getWorld(), ventingBlockPos) == Block.field_185506_k) {
            this.metaTileEntity.getWorld().func_175647_a(EntityLivingBase.class, new AxisAlignedBB(ventingBlockPos), EntitySelectors.field_188444_d).forEach(entity -> entity.func_70097_a(DamageSources.getHeatDamage(), 6.0f));
            WorldServer world = (WorldServer)this.metaTileEntity.getWorld();
            double posX = (double)machinePos.func_177958_n() + 0.5 + (double)ventingSide.func_82601_c() * 0.6;
            double posY = (double)machinePos.func_177956_o() + 0.5 + (double)ventingSide.func_96559_d() * 0.6;
            double posZ = (double)machinePos.func_177952_p() + 0.5 + (double)ventingSide.func_82599_e() * 0.6;
            world.func_175739_a(EnumParticleTypes.SMOKE_LARGE, posX, posY, posZ, 7 + world.field_73012_v.nextInt(3), (double)ventingSide.func_82601_c() / 2.0, (double)ventingSide.func_96559_d() / 2.0, (double)ventingSide.func_82599_e() / 2.0, 0.1, new int[0]);
            world.func_184148_a(null, posX, posY, posZ, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 1.0f, 1.0f);
            this.setNeedsVenting(false);
        } else if (!this.ventingStuck) {
            this.setVentingStuck(true);
        }
    }

    @Override
    public void update() {
        if (this.getMetaTileEntity().getWorld().field_72995_K) {
            return;
        }
        if (this.needsVenting && this.metaTileEntity.getTimer() % 10L == 0L) {
            this.tryDoVenting();
        }
        super.update();
    }

    @Override
    protected boolean setupAndConsumeRecipeInputs(Recipe recipe) {
        return !this.needsVenting && super.setupAndConsumeRecipeInputs(recipe);
    }

    @Override
    protected void completeRecipe() {
        super.completeRecipe();
        this.setNeedsVenting(true);
    }

    @Override
    protected int[] calculateOverclock(int EUt, long voltage, int duration) {
        if (!this.isHighPressure) {
            return new int[]{EUt, duration};
        }
        return super.calculateOverclock(EUt, voltage, duration);
    }

    @Override
    protected long getEnergyStored() {
        return (long)Math.ceil((double)this.steamFluidTank.getFluidAmount() * this.conversionRate);
    }

    @Override
    protected long getEnergyCapacity() {
        return (long)Math.floor((double)this.steamFluidTank.getCapacity() * this.conversionRate);
    }

    @Override
    protected boolean drawEnergy(int recipeEUt) {
        int resultDraw = (int)Math.ceil((double)recipeEUt / this.conversionRate);
        return resultDraw >= 0 && this.steamFluidTank.getFluidAmount() >= resultDraw && this.steamFluidTank.drain(resultDraw, true) != null;
    }

    @Override
    protected long getMaxVoltage() {
        return GTValues.V[1];
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = super.serializeNBT();
        compound.func_74768_a("VentingSide", this.getVentingSide().func_176745_a());
        compound.func_74757_a("NeedsVenting", this.needsVenting);
        compound.func_74757_a("VentingStuck", this.ventingStuck);
        return compound;
    }

    @Override
    public void deserializeNBT(NBTTagCompound compound) {
        super.deserializeNBT(compound);
        this.ventingSide = EnumFacing.field_82609_l[compound.func_74762_e("VentingSide")];
        this.needsVenting = compound.func_74767_n("NeedsVenting");
        this.ventingStuck = compound.func_74767_n("VentingStuck");
    }
}

