/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.world;

import com.google.common.base.MoreObjects;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.chunk.IChunkProvider;
import org.dave.compactmachines3.utility.ChunkUtils;

public class WorldCloneChunkProvider
implements IChunkProvider {
    World world;
    private final Chunk blankChunk;
    private final Long2ObjectMap<List<BlockPos>> toRender = new Long2ObjectOpenHashMap(8192);
    private final Long2ObjectMap<Chunk> loadedChunks = new Long2ObjectOpenHashMap<Chunk>(8192){

        protected void rehash(int p_rehash_1_) {
            if (p_rehash_1_ > this.key.length) {
                super.rehash(p_rehash_1_);
            }
        }
    };

    public WorldCloneChunkProvider(World worldIn) {
        this.blankChunk = new EmptyChunk(worldIn, 0, 0);
        this.world = worldIn;
    }

    public Chunk loadChunkFromNBT(NBTTagCompound tag) {
        Chunk chunk = ChunkUtils.readChunkFromNBT(this.world, tag);
        chunk.func_177417_c(true);
        this.loadedChunks.put(ChunkPos.func_77272_a((int)chunk.field_76635_g, (int)chunk.field_76647_h), (Object)chunk);
        ArrayList<BlockPos> toRender = new ArrayList<BlockPos>();
        for (int x = 15; x >= 0; --x) {
            for (int y = 15; y >= 0; --y) {
                for (int z = 15; z >= 0; --z) {
                    BlockPos pos = new BlockPos(chunk.field_76635_g * 16 + x, y + 40, z);
                    IBlockState state = chunk.func_177435_g(pos);
                    if (state.func_177230_c() == Blocks.field_150350_a || state.func_177230_c() == Blocks.field_180401_cv) continue;
                    toRender.add(pos);
                }
            }
        }
        this.toRender.put(ChunkPos.func_77272_a((int)chunk.field_76635_g, (int)chunk.field_76647_h), toRender);
        return chunk;
    }

    @Nullable
    public Chunk func_186026_b(int x, int z) {
        return (Chunk)this.loadedChunks.get(ChunkPos.func_77272_a((int)x, (int)z));
    }

    public Chunk func_186025_d(int x, int z) {
        return (Chunk)MoreObjects.firstNonNull((Object)this.func_186026_b(x, z), (Object)this.blankChunk);
    }

    public List<BlockPos> getRenderListForChunk(int x, int z) {
        return (List)this.toRender.get(ChunkPos.func_77272_a((int)x, (int)z));
    }

    public boolean func_73156_b() {
        return false;
    }

    public String func_73148_d() {
        return String.format("WorldCloneChunkCache: %d", this.loadedChunks.size());
    }

    public boolean func_191062_e(int x, int z) {
        return this.loadedChunks.containsKey(ChunkPos.func_77272_a((int)x, (int)z));
    }
}

