/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.skyworld;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import org.dave.compactmachines3.block.BlockMachine;
import org.dave.compactmachines3.init.Blockss;
import org.dave.compactmachines3.reference.EnumMachineSize;
import org.dave.compactmachines3.skyworld.SkyChunkGenerator;
import org.dave.compactmachines3.tile.TileEntityMachine;
import org.dave.compactmachines3.world.tools.StructureTools;

public class SkyTerrainGenerator {
    private final World world;
    private final SkyChunkGenerator chunkGenerator;
    public static final int ROOM_DIMENSION = 9;
    public static final int ROOM_PADDING = 7;
    public static final int ROOM_FLOOR_HEIGHT = 50;
    public static final IBlockState WALL_BLOCK = Blockss.wallBreakable.func_176223_P();

    public SkyTerrainGenerator(World world, SkyChunkGenerator skyChunkGenerator) {
        this.world = world;
        this.chunkGenerator = skyChunkGenerator;
    }

    public void generate(int chunkX, int chunkZ, ChunkPrimer cp) {
        if (this.isOutside(chunkX, chunkZ)) {
            return;
        }
        this.generateEmptyCube(chunkX, chunkZ, cp);
        this.generateCeilingWindows(chunkX, chunkZ, cp);
        this.generateConnections(chunkX, chunkZ, cp);
        this.generateLighting(chunkX, chunkZ, cp);
        this.generateMachine(chunkX, chunkZ, cp);
    }

    public void populate(int chunkX, int chunkZ) {
        if (this.isOutside(chunkX, chunkZ)) {
            return;
        }
        int center = (int)Math.floor(4.5);
        BlockPos machinePos = new BlockPos(15 - center, 43, 15 - center);
        TileEntity te = this.world.func_175625_s(machinePos = machinePos.func_177982_a(chunkX << 4, 0, chunkZ << 4));
        if (!(te instanceof TileEntityMachine)) {
            return;
        }
        TileEntityMachine machine = (TileEntityMachine)te;
        machine.setSchema(this.chunkGenerator.config.schema.getName());
        machine.setLocked(this.chunkGenerator.config.startLocked);
        machine.func_70296_d();
    }

    private void generateMachine(int chunkX, int chunkZ, ChunkPrimer cp) {
        int center = (int)Math.floor(4.5);
        BlockPos machinePos = new BlockPos(15 - center, 43, 15 - center);
        EnumMachineSize startSize = this.chunkGenerator.config.schema.getSize();
        cp.func_177855_a(machinePos.func_177958_n(), machinePos.func_177956_o(), machinePos.func_177952_p(), Blockss.machine.func_176223_P().func_177226_a(BlockMachine.SIZE, (Comparable)((Object)startSize)));
    }

    private void generateLighting(int chunkX, int chunkZ, ChunkPrimer cp) {
        IBlockState carpetCrossState;
        IBlockState carpetCornerState;
        switch (this.chunkGenerator.config.size) {
            default: {
                carpetCrossState = carpetCornerState = Blocks.field_150404_cg.func_176203_a(chunkZ * 4 + chunkX);
                break;
            }
            case MEDIUM: {
                carpetCornerState = Blocks.field_150404_cg.func_176203_a(chunkX);
                carpetCrossState = Blocks.field_150404_cg.func_176203_a(chunkZ + 8);
                break;
            }
            case LARGE: {
                carpetCornerState = Blocks.field_150404_cg.func_176203_a(chunkX);
                carpetCrossState = Blocks.field_150404_cg.func_176203_a(chunkZ);
            }
        }
        int center = (int)Math.floor(4.5);
        BlockPos floorCenter = new BlockPos(15 - center, 42, 15 - center);
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (x == 0 && z == 0) continue;
                BlockPos thisPos = floorCenter.func_177982_a(x, 0, z);
                IBlockState carpetStateToUse = x == 0 || z == 0 ? carpetCrossState : carpetCornerState;
                cp.func_177855_a(thisPos.func_177958_n(), thisPos.func_177956_o(), thisPos.func_177952_p(), Blocks.field_150426_aN.func_176223_P());
                cp.func_177855_a(thisPos.func_177958_n(), thisPos.func_177956_o() + 1, thisPos.func_177952_p(), carpetStateToUse);
            }
        }
    }

    private void generateCeilingWindows(int chunkX, int chunkZ, ChunkPrimer cp) {
        int meta = chunkZ * 4 + chunkX;
        int center = (int)Math.floor(4.5);
        BlockPos ceilingCenter = new BlockPos(15 - center, 50, 15 - center);
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                if (x == 0 || z == 0) continue;
                BlockPos thisPos = ceilingCenter.func_177982_a(x, 0, z);
                IBlockState glassState = Blocks.field_150399_cn.func_176203_a(meta);
                cp.func_177855_a(thisPos.func_177958_n(), thisPos.func_177956_o(), thisPos.func_177952_p(), glassState);
            }
        }
    }

    private void generateEmptyCube(int chunkX, int chunkZ, ChunkPrimer cp) {
        List<BlockPos> cubePositions = StructureTools.getCubePositions(new BlockPos(15, 50, 15), 9, 9, 9, true);
        for (BlockPos pos : cubePositions) {
            cp.func_177855_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), WALL_BLOCK);
        }
    }

    private void generateConnections(int chunkX, int chunkZ, ChunkPrimer cp) {
        int x;
        int yOffset;
        int offset;
        BlockPos thisPos;
        int y;
        int z;
        BlockPos lowerCenter;
        int center = (int)Math.floor(4.5);
        int lowest = 43;
        if (this.hasLeftNeighbor(chunkX)) {
            lowerCenter = new BlockPos(7, lowest, 15 - center);
            for (z = -1; z < 2; ++z) {
                for (y = 0; y < 3; ++y) {
                    thisPos = lowerCenter.func_177982_a(0, y, z);
                    cp.func_177855_a(thisPos.func_177958_n(), thisPos.func_177956_o(), thisPos.func_177952_p(), Blocks.field_150350_a.func_176223_P());
                }
            }
            lowerCenter = lowerCenter.func_177977_b();
            for (offset = 1; offset < 8; ++offset) {
                for (int z2 = -1; z2 < 2; ++z2) {
                    thisPos = lowerCenter.func_177982_a(-offset, 0, z2);
                    cp.func_177855_a(thisPos.func_177958_n(), thisPos.func_177956_o(), thisPos.func_177952_p(), WALL_BLOCK);
                    cp.func_177855_a(thisPos.func_177958_n(), thisPos.func_177956_o() + 4, thisPos.func_177952_p(), WALL_BLOCK);
                }
                for (yOffset = 0; yOffset < 3; ++yOffset) {
                    thisPos = lowerCenter.func_177982_a(-offset, yOffset + 1, 0);
                    cp.func_177855_a(thisPos.func_177958_n(), thisPos.func_177956_o(), thisPos.func_177952_p() + 2, WALL_BLOCK);
                    cp.func_177855_a(thisPos.func_177958_n(), thisPos.func_177956_o(), thisPos.func_177952_p() - 2, WALL_BLOCK);
                }
            }
        }
        if (this.hasRightNeighbor(chunkX)) {
            lowerCenter = new BlockPos(15, lowest, 15 - center);
            for (z = -1; z < 2; ++z) {
                for (y = 0; y < 3; ++y) {
                    thisPos = lowerCenter.func_177982_a(0, y, z);
                    cp.func_177855_a(thisPos.func_177958_n(), thisPos.func_177956_o(), thisPos.func_177952_p(), Blocks.field_150350_a.func_176223_P());
                }
            }
        }
        if (this.hasTopNeighbor(chunkZ)) {
            lowerCenter = new BlockPos(15 - center, lowest, 7);
            for (x = -1; x < 2; ++x) {
                for (y = 0; y < 3; ++y) {
                    thisPos = lowerCenter.func_177982_a(x, y, 0);
                    cp.func_177855_a(thisPos.func_177958_n(), thisPos.func_177956_o(), thisPos.func_177952_p(), Blocks.field_150350_a.func_176223_P());
                }
            }
            lowerCenter = lowerCenter.func_177977_b();
            for (offset = 1; offset < 8; ++offset) {
                for (int x2 = -1; x2 < 2; ++x2) {
                    thisPos = lowerCenter.func_177982_a(x2, 0, -offset);
                    cp.func_177855_a(thisPos.func_177958_n(), thisPos.func_177956_o(), thisPos.func_177952_p(), WALL_BLOCK);
                    cp.func_177855_a(thisPos.func_177958_n(), thisPos.func_177956_o() + 4, thisPos.func_177952_p(), WALL_BLOCK);
                }
                for (yOffset = 0; yOffset < 3; ++yOffset) {
                    thisPos = lowerCenter.func_177982_a(0, yOffset + 1, -offset);
                    cp.func_177855_a(thisPos.func_177958_n() + 2, thisPos.func_177956_o(), thisPos.func_177952_p(), WALL_BLOCK);
                    cp.func_177855_a(thisPos.func_177958_n() - 2, thisPos.func_177956_o(), thisPos.func_177952_p(), WALL_BLOCK);
                }
            }
        }
        if (this.hasBottomNeighbor(chunkZ)) {
            lowerCenter = new BlockPos(15 - center, lowest, 15);
            for (x = -1; x < 2; ++x) {
                for (y = 0; y < 3; ++y) {
                    thisPos = lowerCenter.func_177982_a(x, y, 0);
                    cp.func_177855_a(thisPos.func_177958_n(), thisPos.func_177956_o(), thisPos.func_177952_p(), Blocks.field_150350_a.func_176223_P());
                }
            }
        }
    }

    private boolean isOutside(int offsetChunkX, int offsetChunkZ) {
        if (offsetChunkX < 0 || offsetChunkX >= this.chunkGenerator.config.size.cols) {
            return true;
        }
        return offsetChunkZ < 0 || offsetChunkZ >= this.chunkGenerator.config.size.rows;
    }

    private boolean hasLeftNeighbor(int offsetChunkX) {
        return offsetChunkX > 0;
    }

    private boolean hasRightNeighbor(int offsetChunkX) {
        return offsetChunkX < this.chunkGenerator.config.size.cols - 1;
    }

    private boolean hasTopNeighbor(int offsetChunkZ) {
        return offsetChunkZ > 0;
    }

    private boolean hasBottomNeighbor(int offsetChunkZ) {
        return offsetChunkZ < this.chunkGenerator.config.size.rows - 1;
    }
}

