/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.network;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.management.PlayerList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.items.ItemHandlerHelper;
import org.dave.compactmachines3.init.Blockss;
import org.dave.compactmachines3.network.MessageMachineChunk;
import org.dave.compactmachines3.network.MessageMachineContent;
import org.dave.compactmachines3.network.MessageRequestMachineAction;
import org.dave.compactmachines3.network.PackageHandler;
import org.dave.compactmachines3.reference.EnumMachineSize;
import org.dave.compactmachines3.tile.TileEntityMachine;
import org.dave.compactmachines3.utility.DimensionBlockPos;
import org.dave.compactmachines3.world.TeleporterMachines;
import org.dave.compactmachines3.world.WorldSavedDataMachines;
import org.dave.compactmachines3.world.tools.DimensionTools;
import org.dave.compactmachines3.world.tools.TeleportationTools;

public class MessageRequestMachineActionHandler
implements IMessageHandler<MessageRequestMachineAction, MessageMachineContent> {
    public MessageMachineContent onMessage(MessageRequestMachineAction message, MessageContext ctx) {
        int coords = message.coords;
        if (message.action == MessageRequestMachineAction.Action.REFRESH) {
            if (message.coords < 0) {
                coords = WorldSavedDataMachines.INSTANCE.nextCoord - 1;
            }
            if (message.coords >= WorldSavedDataMachines.INSTANCE.nextCoord) {
                coords = 0;
            }
        }
        boolean[] updateMachineContent = new boolean[]{true};
        int finalCoords = coords;
        EntityPlayerMP serverPlayer = ctx.getServerHandler().field_147369_b;
        if (message.action == MessageRequestMachineAction.Action.GIVE_ITEM) {
            EnumMachineSize size = WorldSavedDataMachines.INSTANCE.machineSizes.get(coords);
            serverPlayer.func_71121_q().func_152344_a(() -> {
                ItemStack stack = new ItemStack((Block)Blockss.machine, 1, size.getMeta());
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74768_a("coords", finalCoords);
                stack.func_77982_d(compound);
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)serverPlayer, (ItemStack)stack);
                WorldSavedDataMachines.INSTANCE.removeMachinePosition(finalCoords);
            });
        }
        if (message.action == MessageRequestMachineAction.Action.TELEPORT_INSIDE) {
            TeleportationTools.teleportPlayerToMachine(serverPlayer, coords, false);
        }
        if (message.action == MessageRequestMachineAction.Action.TELEPORT_OUTSIDE) {
            DimensionBlockPos pos = WorldSavedDataMachines.INSTANCE.machinePositions.get(coords);
            WorldServer world = DimensionTools.getWorldServerForDimension(pos.getDimension());
            BlockPos spawnPos = TeleportationTools.getValidSpawnLocation(world, pos.getBlockPos());
            PlayerList playerList = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al();
            playerList.transferPlayerToDimension(serverPlayer, pos.getDimension(), (Teleporter)new TeleporterMachines(world));
            serverPlayer.func_70634_a((double)((float)spawnPos.func_177958_n() + 0.5f), (double)((float)spawnPos.func_177956_o() + 0.5f), (double)((float)spawnPos.func_177952_p() + 0.5f));
        }
        if (message.action == MessageRequestMachineAction.Action.TOGGLE_LOCKED) {
            serverPlayer.func_71121_q().func_152344_a(() -> {
                DimensionBlockPos pos = WorldSavedDataMachines.INSTANCE.machinePositions.get(finalCoords);
                TileEntity te = DimensionTools.getWorldServerForDimension(pos.getDimension()).func_175625_s(pos.getBlockPos());
                if (te != null && te instanceof TileEntityMachine) {
                    TileEntityMachine machine = (TileEntityMachine)te;
                    machine.toggleLocked();
                    machine.func_70296_d();
                }
            });
        }
        if (message.action == MessageRequestMachineAction.Action.TRY_TO_ENTER) {
            serverPlayer.func_71121_q().func_152344_a(() -> {
                DimensionBlockPos pos = WorldSavedDataMachines.INSTANCE.machinePositions.get(finalCoords);
                TileEntity te = DimensionTools.getWorldServerForDimension(pos.getDimension()).func_175625_s(pos.getBlockPos());
                if (te != null && te instanceof TileEntityMachine) {
                    TileEntityMachine machine = (TileEntityMachine)te;
                    TeleportationTools.tryToEnterMachine((EntityPlayer)serverPlayer, machine);
                    updateMachineContent[0] = false;
                }
            });
        }
        if (updateMachineContent[0]) {
            serverPlayer.func_71121_q().func_152344_a(() -> {
                PackageHandler.instance.sendTo((IMessage)new MessageMachineChunk(finalCoords), serverPlayer);
                PackageHandler.instance.sendTo((IMessage)new MessageMachineContent(finalCoords), serverPlayer);
            });
        }
        return null;
    }
}

