/*
 * Decompiled with CFR 0.152.
 */
package knightminer.tcomplement.steelworks.tileentity;

import java.util.List;
import javax.annotation.Nonnull;
import knightminer.tcomplement.library.TCompRegistry;
import knightminer.tcomplement.library.steelworks.HighOvenFuel;
import knightminer.tcomplement.library.steelworks.IHeatRecipe;
import knightminer.tcomplement.library.steelworks.IMixRecipe;
import knightminer.tcomplement.library.steelworks.MixAdditive;
import knightminer.tcomplement.steelworks.client.GuiHighOven;
import knightminer.tcomplement.steelworks.inventory.ContainerHighOven;
import knightminer.tcomplement.steelworks.inventory.InventoryHighOven;
import knightminer.tcomplement.steelworks.multiblock.MultiblockHighOven;
import knightminer.tcomplement.steelworks.tank.HighOvenTank;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import slimeknights.mantle.common.IInventoryGui;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.smeltery.ISmelteryTankHandler;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;
import slimeknights.tconstruct.library.smeltery.SmelteryTank;
import slimeknights.tconstruct.library.utils.FluidUtil;
import slimeknights.tconstruct.smeltery.block.BlockSearedFurnaceController;
import slimeknights.tconstruct.smeltery.multiblock.MultiblockDetection;
import slimeknights.tconstruct.smeltery.network.SmelteryFluidUpdatePacket;
import slimeknights.tconstruct.smeltery.tileentity.TileHeatingStructure;

public class TileHighOven
extends TileHeatingStructure<MultiblockHighOven>
implements ITickable,
IInventoryGui,
ISmelteryTankHandler {
    private static final int ROOM_TEMPERATURE = 20;
    private static final int COOLDOWN_RATE = 10;
    private static final int DEGREES_PER_LAYER = 500;
    private static final int BASE_TEMPERATURE_CAP = 1500;
    private static final int MAX_TEMPERATURE_CAP = 9500;
    private static final int MAX_SLOTS = 7;
    private static final int CAPACITY_PER_LAYER = 1728;
    protected HighOvenTank liquids;
    protected InventoryHighOven additives;
    protected int tick;
    protected int maxTemperature = 0;
    protected int fuelRate;
    public int fuelQuality;
    protected IItemHandlerModifiable combinedItemHandler;
    protected IHeatRecipe heatRecipeCache;
    protected IMixRecipe mixRecipeCache;
    private static final String TAG_MAX_TEMPERATURE = "maxTemperature";
    private static final String TAG_FUEL_QUALITY = "fuelQuality";
    private static final String TAG_FUEL_RATE = "fuelRate";
    private static final String TAG_ADDITIVES = "additives";

    public TileHighOven() {
        super("gui.tcomplement.high_oven.name", 0, 1);
        this.setMultiblock((MultiblockDetection)new MultiblockHighOven(this));
        this.liquids = new HighOvenTank(this);
        this.additives = new InventoryHighOven(this);
        this.combinedItemHandler = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.additives, this.getItemHandler()});
    }

    public void func_73660_a() {
        if (this.isClientWorld()) {
            return;
        }
        if (!this.isActive()) {
            if (this.tick == 0) {
                this.checkMultiblockStructure();
                if (!this.active) {
                    this.temperature = Math.max(this.temperature / 2 - 10, 20);
                }
            }
        } else {
            if (this.tick % 4 == 0) {
                int fuel = this.fuel;
                this.heatItems();
                this.fuel = fuel;
            }
            if (this.tick % 5 == 0) {
                this.heatFluid();
            }
            if (this.tick == 0) {
                this.interactWithEntitiesInside();
                this.updateTemperature();
            }
        }
        this.tick = (this.tick + 1) % 20;
    }

    public boolean hasFuel() {
        return this.temperature > 20;
    }

    protected void updateHeatRequired(int index) {
        MeltingRecipe melting;
        ItemStack stack = this.func_70301_a(index);
        if (!stack.func_190926_b() && (melting = TCompRegistry.getOvenMelting(stack)) != null) {
            this.setHeatRequiredForSlot(index, Math.max(5, melting.getUsableTemperature()));
            return;
        }
        this.setHeatRequiredForSlot(index, 0);
    }

    protected boolean onItemFinishedHeating(ItemStack stack, int slot) {
        int filled;
        MeltingRecipe recipe = TCompRegistry.getOvenMelting(stack);
        if (recipe == null) {
            return false;
        }
        FluidStack meltingOutput = FluidUtil.getValidFluidStackOrNull((FluidStack)recipe.output.copy());
        HighOvenTank.FilterMatchType type = this.liquids.matchesFilter(meltingOutput, true);
        if (type == HighOvenTank.FilterMatchType.NONE) {
            this.itemTemperatures[slot] = this.itemTempRequired[slot] * 3 + 1;
            return false;
        }
        if (type == HighOvenTank.FilterMatchType.INPUT) {
            IMixRecipe mixRecipe;
            ItemStack oxidizer = this.additives.getAdditive(MixAdditive.OXIDIZER);
            ItemStack reducer = this.additives.getAdditive(MixAdditive.REDUCER);
            ItemStack purifier = this.additives.getAdditive(MixAdditive.PURIFIER);
            if (this.mixRecipeCache != null && this.mixRecipeCache.matches(meltingOutput, oxidizer, reducer, purifier)) {
                mixRecipe = this.mixRecipeCache;
            } else {
                mixRecipe = TCompRegistry.getMixRecipe(meltingOutput, oxidizer, reducer, purifier);
                if (mixRecipe != null) {
                    this.mixRecipeCache = mixRecipe;
                }
            }
            if (mixRecipe != null) {
                FluidStack mixOutput = mixRecipe.getOutput(meltingOutput, this.temperature);
                int filled2 = this.liquids.fillInternal(mixOutput, false);
                if (filled2 == mixOutput.amount) {
                    this.liquids.fillInternal(mixOutput, true);
                    this.func_70299_a(slot, ItemStack.field_190927_a);
                    mixRecipe.updateAdditives(meltingOutput, oxidizer, reducer, purifier, this.temperature);
                    return true;
                }
                this.itemTemperatures[slot] = this.itemTempRequired[slot] * 2 + 1;
                return false;
            }
        }
        if ((filled = this.liquids.fillInternal(meltingOutput, false)) == meltingOutput.amount) {
            this.liquids.fillInternal(meltingOutput, true);
            this.func_70299_a(slot, ItemStack.field_190927_a);
            return true;
        }
        this.itemTemperatures[slot] = this.itemTempRequired[slot] * 2 + 1;
        return false;
    }

    protected void consumeFuel() {
        ItemStack fuelStack = this.additives.getFuel();
        if (fuelStack.func_190926_b()) {
            return;
        }
        HighOvenFuel fuel = TCompRegistry.getHighOvenFuel(fuelStack);
        if (fuel != null) {
            fuelStack.func_190918_g(1);
            this.fuel += fuel.getTime();
            this.fuelQuality = fuel.getTime();
            this.fuelRate = fuel.getRate();
            this.needsFuel = false;
        }
    }

    protected void heatFluid() {
        FluidStack current = this.liquids.getFilterFluid();
        if (current != null) {
            int available;
            IHeatRecipe recipe = this.heatRecipeCache;
            if (recipe == null || !recipe.matches(current)) {
                recipe = TCompRegistry.getHeatRecipe(current);
            }
            if (recipe == null) {
                return;
            }
            this.heatRecipeCache = recipe;
            int matches = recipe.timesMatched(current, this.temperature);
            if (matches <= 0) {
                return;
            }
            FluidStack input = recipe.getInput();
            FluidStack output = recipe.getOutput();
            if (output.amount > input.amount && (matches = Math.min(matches, (available = this.liquids.getCapacity() - this.liquids.getFluidAmount()) / (output.amount - input.amount))) == 0) {
                return;
            }
            this.liquids.drainInternal(new FluidStack(input, input.amount * matches), true);
            this.liquids.fillInternal(new FluidStack(output, output.amount * matches), true);
            this.liquids.moveFluidToBottom(output);
        }
    }

    protected void updateTemperature() {
        if (this.fuel <= 0) {
            this.consumeFuel();
        }
        if (this.fuel > 0) {
            this.temperature = Math.min(this.temperature + this.fuelRate, this.maxTemperature);
            --this.fuel;
        } else if (this.temperature != 20) {
            this.temperature = Math.max(this.temperature - 10, 20);
        }
    }

    protected void updateStructureInfo(MultiblockDetection.MultiblockStructure structure) {
        int inventorySize = Math.min(structure.yd, 7);
        if (this.func_70302_i_() > inventorySize) {
            for (int i = inventorySize; i < this.func_70302_i_(); ++i) {
                if (this.func_70301_a(i).func_190926_b()) continue;
                this.dropItem(this.func_70301_a(i));
            }
        }
        this.resize(inventorySize);
        this.liquids.setCapacity(structure.yd * 1728);
        this.maxTemperature = Math.min(1500 + structure.yd * 500, 9500);
    }

    protected void dropItem(ItemStack stack) {
        EnumFacing direction = (EnumFacing)this.func_145831_w().func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockSearedFurnaceController.FACING);
        BlockPos pos = this.func_174877_v().func_177972_a(direction);
        EntityItem entityitem = new EntityItem(this.func_145831_w(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
        this.func_145831_w().func_72838_d((Entity)entityitem);
    }

    protected void interactWithEntitiesInside() {
        AxisAlignedBB bb = this.info.getBoundingBox().func_191195_a(1.0, 1.0, 1.0).func_72317_d(0.0, 0.5, 0.0).func_72321_a(0.0, 0.5, 0.0);
        List entities = this.func_145831_w().func_72872_a(EntityLivingBase.class, bb);
        for (EntityLivingBase entity : entities) {
            if (!(entity instanceof EntityMob) || !entity.func_70089_S()) continue;
            entity.func_70106_y();
        }
    }

    public IItemHandlerModifiable getAdditives() {
        return this.additives;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? facing == null : super.hasCapability(capability, facing);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)(facing == null ? CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.combinedItemHandler) : null);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        ItemStack current = this.func_70301_a(slot);
        super.func_70299_a(slot, stack);
        if (!ItemStack.func_77989_b((ItemStack)current, (ItemStack)stack)) {
            this.markDirtyFast();
        }
    }

    public SmelteryTank getTank() {
        return this.liquids;
    }

    public Container createContainer(InventoryPlayer inventoryplayer, World world, BlockPos pos) {
        return new ContainerHighOven(inventoryplayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer createGui(InventoryPlayer inventoryplayer, World world, BlockPos pos) {
        return new GuiHighOven((ContainerHighOven)this.createContainer(inventoryplayer, world, pos), this);
    }

    public float getHeatingProgress(int index) {
        if (index < 0 || index >= this.func_70302_i_()) {
            return -1.0f;
        }
        if (!this.canHeat(index)) {
            return -1.0f;
        }
        return this.getProgress(index);
    }

    public void markDirtyFast() {
        if (this.field_145850_b != null) {
            this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
        }
    }

    public void onTankChanged(List<FluidStack> fluids, FluidStack changed) {
        if (this.isServerWorld()) {
            TinkerNetwork.sendToAll((AbstractPacket)new SmelteryFluidUpdatePacket(this.field_174879_c, fluids));
        }
        this.markDirtyFast();
    }

    @SideOnly(value=Side.CLIENT)
    public void updateFromPacket(int index, int value) {
        if (index == 0) {
            this.fuel = value;
        } else if (index == 1) {
            this.fuelQuality = value;
        } else if (index == 2) {
            this.temperature = value;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getFuelPercentage() {
        return (float)this.fuel / (float)this.fuelQuality;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateFluidsFromPacket(List<FluidStack> fluids) {
        this.liquids.setFluids(fluids);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        this.liquids.writeToNBT(compound);
        compound.func_74768_a(TAG_MAX_TEMPERATURE, this.maxTemperature);
        compound.func_74768_a(TAG_FUEL_QUALITY, this.fuelQuality);
        compound.func_74768_a(TAG_FUEL_RATE, this.fuelRate);
        compound.func_74782_a(TAG_ADDITIVES, (NBTBase)this.additives.serializeNBT());
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.liquids.readFromNBT(compound);
        this.maxTemperature = compound.func_74762_e(TAG_MAX_TEMPERATURE);
        this.fuelQuality = compound.func_74762_e(TAG_FUEL_QUALITY);
        this.fuelRate = compound.func_74762_e(TAG_FUEL_RATE);
        this.additives.deserializeNBT(compound.func_74775_l(TAG_ADDITIVES));
    }
}

