/*
 * Decompiled with CFR 0.152.
 */
package knightminer.tcomplement.steelworks;

import com.google.common.collect.ImmutableSet;
import com.google.common.eventbus.Subscribe;
import knightminer.tcomplement.common.CommonProxy;
import knightminer.tcomplement.common.Config;
import knightminer.tcomplement.common.PulseBase;
import knightminer.tcomplement.library.TCompRegistry;
import knightminer.tcomplement.library.Util;
import knightminer.tcomplement.library.steelworks.IMixRecipe;
import knightminer.tcomplement.shared.CommonsModule;
import knightminer.tcomplement.steelworks.blocks.BlockHighOvenController;
import knightminer.tcomplement.steelworks.blocks.BlockHighOvenIO;
import knightminer.tcomplement.steelworks.blocks.BlockScorchedSlab;
import knightminer.tcomplement.steelworks.blocks.BlockScorchedSlab2;
import knightminer.tcomplement.steelworks.blocks.BlockStorage;
import knightminer.tcomplement.steelworks.items.ItemBlockStorage;
import knightminer.tcomplement.steelworks.tileentity.TileHighOven;
import knightminer.tcomplement.steelworks.tileentity.TileHighOvenItemProxy;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.mantle.item.ItemBlockMeta;
import slimeknights.mantle.pulsar.pulse.Pulse;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.MaterialIntegration;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;
import slimeknights.tconstruct.library.smeltery.ICastingRecipe;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;
import slimeknights.tconstruct.shared.TinkerFluids;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.BlockCasting;
import slimeknights.tconstruct.smeltery.block.BlockChannel;
import slimeknights.tconstruct.smeltery.block.BlockFaucet;
import slimeknights.tconstruct.smeltery.block.BlockSeared;
import slimeknights.tconstruct.smeltery.block.BlockSearedSlab;
import slimeknights.tconstruct.smeltery.block.BlockSearedSlab2;
import slimeknights.tconstruct.smeltery.item.ItemChannel;

@Pulse(id="ModuleSteelworks", description="Adds the high oven: a new multiblock for making steel", pulsesRequired="tconstruct:TinkerSmeltery")
public class SteelworksModule
extends PulseBase {
    public static final String pulseID = "ModuleSteelworks";
    @SidedProxy(clientSide="knightminer.tcomplement.steelworks.SteelworksClientProxy", serverSide="knightminer.tcomplement.common.CommonProxy")
    public static CommonProxy proxy;
    public static Block storage;
    public static BlockHighOvenController highOvenController;
    public static BlockFaucet scorchedFaucet;
    public static BlockChannel scorchedChannel;
    public static BlockCasting scorchedCasting;
    public static BlockHighOvenIO highOvenIO;
    public static BlockSeared scorchedBlock;
    public static BlockScorchedSlab scorchedSlab;
    public static BlockScorchedSlab2 scorchedSlab2;
    public static Block scorchedStairsStone;
    public static Block scorchedStairsCobble;
    public static Block scorchedStairsPaver;
    public static Block scorchedStairsBrick;
    public static Block scorchedStairsBrickCracked;
    public static Block scorchedStairsBrickFancy;
    public static Block scorchedStairsBrickSquare;
    public static Block scorchedStairsBrickTriangle;
    public static Block scorchedStairsBrickSmall;
    public static Block scorchedStairsRoad;
    public static Block scorchedStairsTile;
    public static Block scorchedStairsCreeper;
    public static Fluid steam;
    public static ItemStack charcoalBlock;
    public static ItemStack steelBlock;

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit();
        if (Config.highOven.steamFuel || Config.highOven.steamRate > 1) {
            steam = SteelworksModule.registerFluid(new Fluid("steam", Util.getResource("blocks/fluids/steam"), Util.getResource("blocks/fluids/steam_flow")).setDensity(-1000).setViscosity(200).setTemperature(750).setGaseous(true));
        }
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry r = event.getRegistry();
        storage = SteelworksModule.registerBlock((IForgeRegistry<Block>)r, new BlockStorage(), "storage");
        highOvenController = SteelworksModule.registerBlock((IForgeRegistry<Block>)r, new BlockHighOvenController(), "high_oven_controller");
        scorchedFaucet = SteelworksModule.registerBlock((IForgeRegistry<Block>)r, new BlockFaucet(), "scorched_faucet");
        scorchedChannel = SteelworksModule.registerBlock((IForgeRegistry<Block>)r, new BlockChannel(), "scorched_channel");
        scorchedCasting = SteelworksModule.registerBlock((IForgeRegistry<Block>)r, new BlockCasting(), "scorched_casting");
        highOvenIO = SteelworksModule.registerBlock((IForgeRegistry<Block>)r, new BlockHighOvenIO(), "high_oven_io");
        scorchedFaucet.func_149647_a((CreativeTabs)TCompRegistry.tabGeneral);
        scorchedChannel.func_149647_a((CreativeTabs)TCompRegistry.tabGeneral);
        scorchedCasting.func_149647_a((CreativeTabs)TCompRegistry.tabGeneral);
        highOvenIO.func_149647_a((CreativeTabs)TCompRegistry.tabGeneral);
        SteelworksModule.registerTE(TileHighOven.class, "high_oven");
        SteelworksModule.registerTE(TileHighOvenItemProxy.TileChute.class, "chute");
        SteelworksModule.registerTE(TileHighOvenItemProxy.TileDuct.class, "duct");
        scorchedBlock = SteelworksModule.registerBlock((IForgeRegistry<Block>)r, new BlockSeared(), "scorched_block");
        scorchedSlab = SteelworksModule.registerBlock((IForgeRegistry<Block>)r, new BlockScorchedSlab(), "scorched_slab");
        scorchedSlab2 = SteelworksModule.registerBlock((IForgeRegistry<Block>)r, new BlockScorchedSlab2(), "scorched_slab2");
        scorchedBlock.func_149647_a((CreativeTabs)TCompRegistry.tabGeneral);
        scorchedStairsStone = SteelworksModule.registerBlockStairsFrom((IForgeRegistry<Block>)r, scorchedBlock, BlockSeared.SearedType.STONE, "scorched_stairs_stone");
        scorchedStairsCobble = SteelworksModule.registerBlockStairsFrom((IForgeRegistry<Block>)r, scorchedBlock, BlockSeared.SearedType.COBBLE, "scorched_stairs_cobble");
        scorchedStairsPaver = SteelworksModule.registerBlockStairsFrom((IForgeRegistry<Block>)r, scorchedBlock, BlockSeared.SearedType.PAVER, "scorched_stairs_paver");
        scorchedStairsBrick = SteelworksModule.registerBlockStairsFrom((IForgeRegistry<Block>)r, scorchedBlock, BlockSeared.SearedType.BRICK, "scorched_stairs_brick");
        scorchedStairsBrickCracked = SteelworksModule.registerBlockStairsFrom((IForgeRegistry<Block>)r, scorchedBlock, BlockSeared.SearedType.BRICK_CRACKED, "scorched_stairs_brick_cracked");
        scorchedStairsBrickFancy = SteelworksModule.registerBlockStairsFrom((IForgeRegistry<Block>)r, scorchedBlock, BlockSeared.SearedType.BRICK_FANCY, "scorched_stairs_brick_fancy");
        scorchedStairsBrickSquare = SteelworksModule.registerBlockStairsFrom((IForgeRegistry<Block>)r, scorchedBlock, BlockSeared.SearedType.BRICK_SQUARE, "scorched_stairs_brick_square");
        scorchedStairsBrickTriangle = SteelworksModule.registerBlockStairsFrom((IForgeRegistry<Block>)r, scorchedBlock, BlockSeared.SearedType.BRICK_TRIANGLE, "scorched_stairs_brick_triangle");
        scorchedStairsBrickSmall = SteelworksModule.registerBlockStairsFrom((IForgeRegistry<Block>)r, scorchedBlock, BlockSeared.SearedType.BRICK_SMALL, "scorched_stairs_brick_small");
        scorchedStairsRoad = SteelworksModule.registerBlockStairsFrom((IForgeRegistry<Block>)r, scorchedBlock, BlockSeared.SearedType.ROAD, "scorched_stairs_road");
        scorchedStairsTile = SteelworksModule.registerBlockStairsFrom((IForgeRegistry<Block>)r, scorchedBlock, BlockSeared.SearedType.TILE, "scorched_stairs_tile");
        scorchedStairsCreeper = SteelworksModule.registerBlockStairsFrom((IForgeRegistry<Block>)r, scorchedBlock, BlockSeared.SearedType.CREEPER, "scorched_stairs_creeper");
        if (steam != null) {
            SteelworksModule.registerFluidBlock((IForgeRegistry<Block>)r, steam);
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry r = event.getRegistry();
        SteelworksModule.registerItemBlock((IForgeRegistry<Item>)r, new ItemBlockStorage(storage), BlockStorage.TYPE);
        charcoalBlock = new ItemStack(storage, 1, BlockStorage.StorageType.CHARCOAL.getMeta());
        steelBlock = new ItemStack(storage, 1, BlockStorage.StorageType.STEEL.getMeta());
        SteelworksModule.registerItemBlock((IForgeRegistry<Item>)r, highOvenController);
        SteelworksModule.registerItemBlock((IForgeRegistry<Item>)r, scorchedFaucet);
        SteelworksModule.registerItemBlock((IForgeRegistry<Item>)r, (ItemBlock)new ItemChannel((Block)scorchedChannel));
        SteelworksModule.registerItemBlock((IForgeRegistry<Item>)r, new ItemBlockMeta((Block)scorchedCasting), BlockCasting.TYPE);
        SteelworksModule.registerEnumItemBlock((IForgeRegistry<Item>)r, highOvenIO);
        if (!SteelworksModule.isMelterLoaded()) {
            TCompRegistry.tabGeneral.setDisplayIcon(new ItemStack((Block)highOvenController));
        }
        SteelworksModule.registerEnumItemBlock((IForgeRegistry<Item>)r, scorchedBlock);
        SteelworksModule.registerEnumItemBlockSlab((IForgeRegistry<Item>)r, scorchedSlab);
        SteelworksModule.registerEnumItemBlockSlab((IForgeRegistry<Item>)r, scorchedSlab2);
        SteelworksModule.registerItemBlock((IForgeRegistry<Item>)r, scorchedStairsStone);
        SteelworksModule.registerItemBlock((IForgeRegistry<Item>)r, scorchedStairsCobble);
        SteelworksModule.registerItemBlock((IForgeRegistry<Item>)r, scorchedStairsPaver);
        SteelworksModule.registerItemBlock((IForgeRegistry<Item>)r, scorchedStairsBrick);
        SteelworksModule.registerItemBlock((IForgeRegistry<Item>)r, scorchedStairsBrickCracked);
        SteelworksModule.registerItemBlock((IForgeRegistry<Item>)r, scorchedStairsBrickFancy);
        SteelworksModule.registerItemBlock((IForgeRegistry<Item>)r, scorchedStairsBrickSquare);
        SteelworksModule.registerItemBlock((IForgeRegistry<Item>)r, scorchedStairsBrickTriangle);
        SteelworksModule.registerItemBlock((IForgeRegistry<Item>)r, scorchedStairsBrickSmall);
        SteelworksModule.registerItemBlock((IForgeRegistry<Item>)r, scorchedStairsRoad);
        SteelworksModule.registerItemBlock((IForgeRegistry<Item>)r, scorchedStairsTile);
        SteelworksModule.registerItemBlock((IForgeRegistry<Item>)r, scorchedStairsCreeper);
        if (steam != null) {
            FluidRegistry.addBucketForFluid((Fluid)steam);
        }
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        this.registerFurnaceRecipes();
        proxy.init();
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        this.registerMeltingCasting();
        this.registerMixes();
        this.registerFuels();
        proxy.postInit();
    }

    private void registerFurnaceRecipes() {
        GameRegistry.addSmelting((ItemStack)new ItemStack((Block)scorchedBlock, 1, BlockSeared.SearedType.BRICK.getMeta()), (ItemStack)new ItemStack((Block)scorchedBlock, 1, BlockSeared.SearedType.BRICK_CRACKED.getMeta()), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack((Block)scorchedSlab, 1, BlockSearedSlab.SearedType.BRICK.getMeta()), (ItemStack)new ItemStack((Block)scorchedSlab, 1, BlockSearedSlab.SearedType.BRICK_CRACKED.getMeta()), (float)0.1f);
        GameRegistry.addSmelting((Block)scorchedStairsBrick, (ItemStack)new ItemStack(scorchedStairsBrickCracked), (float)0.1f);
    }

    private void registerMixes() {
        if (Config.highOven.steamRate > 1) {
            TCompRegistry.registerHeatRecipe(new FluidStack(FluidRegistry.WATER, Config.highOven.steamRate), new FluidStack(steam, Config.highOven.steamRate), 1300);
        }
        IMixRecipe mix = TCompRegistry.registerMix(new FluidStack((Fluid)TinkerFluids.iron, (int)(144.0 * Config.highOven.oreToIngotRatio)), new FluidStack((Fluid)TinkerFluids.steel, (int)(144.0 * Config.highOven.oreToIngotRatio))).addOxidizer("gunpowder", 33).addOxidizer("dustSulfur", 29).addOxidizer("dustSulphur", 29).addOxidizer("dustSaltpeter", 30).addReducer("dustRedstone", 65).addReducer("dustManganese", 47).addReducer("dustAluminum", 60).addReducer("dustAluminium", 60).addPurifier("sand", 100);
        mix = TCompRegistry.registerMix(new FluidStack((Fluid)TinkerFluids.iron, 144), new FluidStack((Fluid)TinkerFluids.pigIron, 144)).addOxidizer(new ItemStack(Items.field_151102_aT), 60).addReducer(new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.WHITE.func_176767_b()), 20).addPurifier(new ItemStack(Items.field_151147_al), 80);
        ItemStack bacon = GameRegistry.makeItemStack((String)"tconstruct:edible", (int)0, (int)1, null);
        if (!bacon.func_190926_b()) {
            mix.addPurifier(bacon, 70);
        }
        mix = TCompRegistry.registerMix(new FluidStack((Fluid)TinkerFluids.iron, 72), new FluidStack((Fluid)TinkerFluids.knightslime, 72)).addReducer("slimeballPurple", 75).addPurifier("gravel", 80);
    }

    private void registerFuels() {
        if (Config.highOven.steamFuel) {
            TinkerRegistry.registerSmelteryFuel((FluidStack)new FluidStack(steam, 50), (int)50);
        }
        TCompRegistry.registerFuel(new ItemStack(Items.field_151044_h, 1, 1), 140, 4);
        TCompRegistry.registerFuel("blockCharcoal", 1400, 7);
        TCompRegistry.registerFuel("fuelCoke", 280, 10);
        TCompRegistry.registerFuel("blockFuelCoke", 2800, 15);
    }

    private void registerMeltingCasting() {
        TinkerRegistry.registerTableCasting((ICastingRecipe)new CastingRecipe(CommonsModule.scorchedBrick.func_77946_l(), RecipeMatch.of((Item)Items.field_151118_aC), new FluidStack((Fluid)TinkerFluids.searedStone, 18), 40, true, false));
        TinkerRegistry.registerBasinCasting((ICastingRecipe)new CastingRecipe(new ItemStack((Block)scorchedBlock, 1, BlockSeared.SearedType.COBBLE.getMeta()), RecipeMatch.of((Block)Blocks.field_150435_aG), new FluidStack((Fluid)TinkerFluids.searedStone, 72), 80, true, false));
        TinkerRegistry.registerBasinCasting((ICastingRecipe)new CastingRecipe(new ItemStack((Block)scorchedBlock, 1, BlockSeared.SearedType.STONE.getMeta()), RecipeMatch.of((Block)Blocks.field_150405_ch), new FluidStack((Fluid)TinkerFluids.searedStone, 72), 100, true, false));
        TinkerRegistry.registerBasinCasting((ICastingRecipe)new CastingRecipe(new ItemStack((Block)scorchedBlock, 1, BlockSeared.SearedType.STONE.getMeta()), RecipeMatch.of((ItemStack)new ItemStack(Blocks.field_150406_ce, 1, Short.MAX_VALUE)), new FluidStack((Fluid)TinkerFluids.searedStone, 72), 100, true, false));
        TinkerRegistry.registerBasinCasting((ICastingRecipe)new CastingRecipe(new ItemStack((Block)scorchedBlock, 1, BlockSeared.SearedType.BRICK_SMALL.getMeta()), RecipeMatch.of((Block)Blocks.field_150336_V), new FluidStack((Fluid)TinkerFluids.searedStone, 72), 100, true, false));
        TinkerRegistry.registerBasinCasting((ICastingRecipe)new CastingRecipe(new ItemStack((Block)scorchedSlab2, 1, BlockSearedSlab2.SearedType.BRICK_SMALL.getMeta()), RecipeMatch.of((ItemStack)new ItemStack((Block)Blocks.field_150333_U, 1, BlockStoneSlab.EnumType.BRICK.func_176624_a())), new FluidStack((Fluid)TinkerFluids.searedStone, 36), 60, true, false));
        GameRegistry.addSmelting((ItemStack)new ItemStack((Block)scorchedBlock, 1, BlockSeared.SearedType.COBBLE.getMeta()), (ItemStack)new ItemStack((Block)scorchedBlock, 1, BlockSeared.SearedType.STONE.getMeta()), (float)0.5f);
        for (FluidStack fluid : TinkerSmeltery.castCreationFluids) {
            TinkerRegistry.registerTableCasting((ICastingRecipe)new CastingRecipe(TinkerSmeltery.castIngot.func_77946_l(), RecipeMatch.of((ItemStack)CommonsModule.scorchedBrick), fluid, true, false));
        }
        for (MaterialIntegration integration : TinkerRegistry.getMaterialIntegrations()) {
            if (integration.fluid == null) continue;
            SteelworksModule.registerOredictMeltingCasting(integration.fluid, integration.oreSuffix);
        }
    }

    private static void registerOredictMeltingCasting(Fluid fluid, String ore) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)Pair.of((Object)("ore" + ore), (Object)((int)(144.0 * Config.highOven.oreToIngotRatio))));
        builder.add((Object)Pair.of((Object)("oreNether" + ore), (Object)((int)(288.0 * Config.highOven.oreToIngotRatio))));
        builder.add((Object)Pair.of((Object)("denseore" + ore), (Object)((int)(432.0 * Config.highOven.oreToIngotRatio))));
        builder.add((Object)Pair.of((Object)("orePoor" + ore), (Object)((int)(48.0 * Config.highOven.oreToIngotRatio))));
        builder.add((Object)Pair.of((Object)("oreNugget" + ore), (Object)((int)(16.0 * Config.highOven.oreToIngotRatio))));
        ImmutableSet knownOres = builder.build();
        for (Pair pair : knownOres) {
            TCompRegistry.registerHighOvenOverride(new MeltingRecipe(RecipeMatch.of((String)((String)pair.getLeft()), (int)((Integer)pair.getRight())), fluid));
        }
    }
}

