/*
 * Decompiled with CFR 0.152.
 */
package knightminer.tcomplement.melter;

import com.google.common.collect.ImmutableSet;
import com.google.common.eventbus.Subscribe;
import knightminer.tcomplement.common.CommonProxy;
import knightminer.tcomplement.common.Config;
import knightminer.tcomplement.common.PulseBase;
import knightminer.tcomplement.library.TCompRegistry;
import knightminer.tcomplement.melter.PartMaterialBlacklist;
import knightminer.tcomplement.melter.blocks.BlockAlloyTank;
import knightminer.tcomplement.melter.blocks.BlockMelter;
import knightminer.tcomplement.melter.tileentity.TileAlloyTank;
import knightminer.tcomplement.melter.tileentity.TileHeater;
import knightminer.tcomplement.melter.tileentity.TileMelter;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.mantle.pulsar.pulse.Pulse;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.MaterialIntegration;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.BlockTank;
import slimeknights.tconstruct.smeltery.item.ItemTank;
import slimeknights.tconstruct.tools.TinkerMaterials;

@Pulse(id="ModuleMelter", description="Adds the melter and alloyer: smaller components of the smeltery", pulsesRequired="tconstruct:TinkerSmeltery")
public class MelterModule
extends PulseBase {
    public static final String pulseID = "ModuleMelter";
    @SidedProxy(clientSide="knightminer.tcomplement.melter.MelterClientProxy", serverSide="knightminer.tcomplement.common.CommonProxy")
    public static CommonProxy proxy;
    public static BlockMelter melter;
    public static Block alloyTank;
    public static BlockMelter porcelainMelter;
    public static Block porcelainAlloyTank;
    public static BlockTank porcelainTank;

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit();
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry r = event.getRegistry();
        if (MelterModule.isSmelteryLoaded()) {
            melter = MelterModule.registerBlock((IForgeRegistry<Block>)r, new BlockMelter(TinkerSmeltery.searedTank), "melter");
            alloyTank = MelterModule.registerBlock((IForgeRegistry<Block>)r, new BlockAlloyTank(melter, (Block)TinkerSmeltery.searedTank), "alloy_tank");
            MelterModule.registerTE(TileMelter.class, "melter");
            MelterModule.registerTE(TileHeater.class, "heater");
            MelterModule.registerTE(TileAlloyTank.class, "alloy_tank");
            if (MelterModule.isCeramicsPluginLoaded()) {
                porcelainTank = MelterModule.registerBlock((IForgeRegistry<Block>)r, new BlockTank(), "porcelain_tank");
                porcelainTank.func_149647_a((CreativeTabs)TCompRegistry.tabGeneral);
                porcelainMelter = MelterModule.registerBlock((IForgeRegistry<Block>)r, new BlockMelter(porcelainTank), "porcelain_melter");
                porcelainAlloyTank = MelterModule.registerBlock((IForgeRegistry<Block>)r, new BlockAlloyTank(porcelainMelter, (Block)porcelainTank), "porcelain_alloy_tank");
            }
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry r = event.getRegistry();
        if (MelterModule.isSmelteryLoaded()) {
            MelterModule.registerItemBlock((IForgeRegistry<Item>)r, (Block)melter, BlockMelter.TYPE);
            MelterModule.registerItemBlock((IForgeRegistry<Item>)r, (ItemBlock)new ItemTank(alloyTank));
            TCompRegistry.tabGeneral.setDisplayIcon(new ItemStack((Block)melter));
            if (MelterModule.isCeramicsPluginLoaded()) {
                MelterModule.registerItemBlock((IForgeRegistry<Item>)r, new ItemTank((Block)porcelainTank), BlockTank.TYPE);
                MelterModule.registerItemBlock((IForgeRegistry<Item>)r, (Block)porcelainMelter, BlockMelter.TYPE);
                MelterModule.registerItemBlock((IForgeRegistry<Item>)r, (ItemBlock)new ItemTank(porcelainAlloyTank));
            }
        }
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        proxy.init();
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        this.registerMeltingCasting();
        proxy.postInit();
    }

    private void registerMeltingCasting() {
        for (MaterialIntegration integration : TinkerRegistry.getMaterialIntegrations()) {
            if (integration.fluid == null) continue;
            MelterModule.registerOredictMeltingCasting(integration.fluid, integration.oreSuffix);
        }
        if (Config.melter.blacklistStone) {
            TCompRegistry.registerMelterBlacklist(RecipeMatch.of((String)"cobblestone"));
            TCompRegistry.registerMelterBlacklist(RecipeMatch.of((String)"stone"));
            TCompRegistry.registerMelterBlacklist(new PartMaterialBlacklist(TinkerMaterials.stone));
        }
    }

    private static void registerOredictMeltingCasting(Fluid fluid, String ore) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)Pair.of((Object)("ore" + ore), (Object)((int)(144.0 * Config.melter.oreToIngotRatio))));
        builder.add((Object)Pair.of((Object)("oreNether" + ore), (Object)((int)(288.0 * Config.melter.oreToIngotRatio))));
        builder.add((Object)Pair.of((Object)("denseore" + ore), (Object)((int)(432.0 * Config.melter.oreToIngotRatio))));
        builder.add((Object)Pair.of((Object)("orePoor" + ore), (Object)((int)(48.0 * Config.melter.oreToIngotRatio))));
        builder.add((Object)Pair.of((Object)("oreNugget" + ore), (Object)((int)(16.0 * Config.melter.oreToIngotRatio))));
        ImmutableSet knownOres = builder.build();
        for (Pair pair : knownOres) {
            TCompRegistry.registerMelterOverride(new MeltingRecipe(RecipeMatch.of((String)((String)pair.getLeft()), (int)((Integer)pair.getRight())), fluid));
        }
    }
}

