/*
 * Decompiled with CFR 0.152.
 */
package knightminer.tcomplement.library.steelworks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import knightminer.tcomplement.library.TCompRegistry;
import knightminer.tcomplement.library.events.TCompRegisterEvent;
import knightminer.tcomplement.library.steelworks.HighOvenFilter;
import knightminer.tcomplement.library.steelworks.IMixRecipe;
import knightminer.tcomplement.library.steelworks.MixAdditive;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.mantle.util.RecipeMatchRegistry;

public class MixRecipe
extends HighOvenFilter
implements IMixRecipe {
    private Map<MixAdditive, MixAdditiveList> additives;
    private static final Random RANDOM = new Random();
    private int minTemp;

    public MixRecipe(@Nonnull FluidStack input, @Nonnull FluidStack output, int temp) {
        super(input, output);
        this.minTemp = temp - 300;
    }

    public MixRecipe(@Nonnull FluidStack input, @Nonnull FluidStack output) {
        this(input, output, output.getFluid().getTemperature(output));
    }

    private boolean ingredientMatches(MixAdditive type, ItemStack input) {
        return !this.additives.containsKey((Object)type) || this.additives.get((Object)type).matches(new ItemStack[]{input}).isPresent();
    }

    @Override
    public boolean matches(FluidStack fluid, ItemStack oxidizer, ItemStack reducer, ItemStack purifier) {
        return this.getInput().isFluidEqual(fluid) && this.additives == null || this.ingredientMatches(MixAdditive.OXIDIZER, oxidizer) && this.ingredientMatches(MixAdditive.REDUCER, reducer) && this.ingredientMatches(MixAdditive.PURIFIER, purifier);
    }

    private void removeMatches(MixAdditive type, ItemStack input, int matched) {
        if (this.additives == null || !this.additives.containsKey((Object)type)) {
            return;
        }
        int chance = this.additives.get((Object)type).matches(new ItemStack[]{input}).map(m -> m.amount).orElse(100);
        if (chance >= 100) {
            input.func_190918_g(matched);
        } else {
            int shrink = 0;
            for (int i = 0; i < matched; ++i) {
                if (RANDOM.nextInt(100) >= chance) continue;
                ++shrink;
            }
            input.func_190918_g(shrink);
        }
    }

    @Override
    public FluidStack getOutput(FluidStack fluid, int temp) {
        if (temp < this.minTemp) {
            return fluid;
        }
        FluidStack output = this.getOutput();
        return new FluidStack(output, fluid.amount * output.amount / this.getInput().amount);
    }

    @Override
    public void updateAdditives(FluidStack fluid, ItemStack oxidizer, ItemStack reducer, ItemStack purifier, int temp) {
        if (temp < this.minTemp) {
            return;
        }
        int matches = fluid.amount / this.getInput().amount;
        if (fluid.amount % this.getInput().amount > 0) {
            ++matches;
        }
        if (matches > 0) {
            this.removeMatches(MixAdditive.OXIDIZER, oxidizer, matches);
            this.removeMatches(MixAdditive.REDUCER, reducer, matches);
            this.removeMatches(MixAdditive.PURIFIER, purifier, matches);
        }
    }

    private void addAdditive(RecipeMatch additive, MixAdditive type) {
        if (additive != null) {
            if (new TCompRegisterEvent.HighOvenMixAdditiveEvent(this, additive, type).fire()) {
                if (this.additives == null) {
                    this.additives = new EnumMap<MixAdditive, MixAdditiveList>(MixAdditive.class);
                }
                this.additives.computeIfAbsent(type, t -> new MixAdditiveList()).addRecipeMatch(additive);
                TCompRegistry.registerMixAdditive(additive, type);
            } else {
                try {
                    String input = additive.getInputs().stream().findFirst().map(ItemStack::func_77977_a).orElse("?");
                    TCompRegistry.log.debug("Addition of {} {} to recipe {} has been cancelled by event", (Object)type.getName(), (Object)input, (Object)this.getOutput().getUnlocalizedName());
                }
                catch (Exception e) {
                    TCompRegistry.log.error("Error when logging HighOvenMixAdditiveEvent", (Throwable)e);
                }
            }
        }
    }

    @Override
    public MixRecipe addOxidizer(RecipeMatch oxidizer) {
        this.addAdditive(oxidizer, MixAdditive.OXIDIZER);
        return this;
    }

    @Override
    public MixRecipe addReducer(RecipeMatch reducer) {
        this.addAdditive(reducer, MixAdditive.REDUCER);
        return this;
    }

    @Override
    public MixRecipe addPurifier(RecipeMatch purifier) {
        this.addAdditive(purifier, MixAdditive.PURIFIER);
        return this;
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        if (this.additives != null) {
            for (MixAdditive type : MixAdditive.values()) {
                if (!this.additives.containsKey((Object)type) || !this.additives.get((Object)type).getInputs().isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    public int getTemperature() {
        return this.minTemp;
    }

    public List<ItemStack> getAdditives(MixAdditive type) {
        if (this.additives == null || !this.additives.containsKey((Object)type)) {
            return Collections.emptyList();
        }
        return this.additives.get((Object)type).getInputs();
    }

    public Integer getAdditiveConsumeChance(MixAdditive type, ItemStack input) {
        if (this.additives == null || !this.additives.containsKey((Object)type)) {
            return null;
        }
        return this.additives.get((Object)type).matches(new ItemStack[]{input}).map(m -> m.amount).orElse(null);
    }

    private static class MixAdditiveList
    extends RecipeMatchRegistry {
        private List<ItemStack> displayItems;

        private MixAdditiveList() {
        }

        public List<ItemStack> getInputs() {
            if (this.displayItems != null) {
                return this.displayItems;
            }
            this.displayItems = this.items.stream().map(RecipeMatch::getInputs).reduce(new ArrayList(), (list, items) -> {
                list.addAll(items);
                return list;
            });
            return this.displayItems;
        }
    }
}

