/*
 * Decompiled with CFR 0.152.
 */
package knightminer.tcomplement.library;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import knightminer.tcomplement.library.IBlacklist;
import knightminer.tcomplement.library.RecipeMatchBlacklist;
import knightminer.tcomplement.library.Util;
import knightminer.tcomplement.library.events.TCompRegisterEvent;
import knightminer.tcomplement.library.steelworks.EmptyMixRecipe;
import knightminer.tcomplement.library.steelworks.HeatRecipe;
import knightminer.tcomplement.library.steelworks.HighOvenFuel;
import knightminer.tcomplement.library.steelworks.IHeatRecipe;
import knightminer.tcomplement.library.steelworks.IHighOvenFilter;
import knightminer.tcomplement.library.steelworks.IMixRecipe;
import knightminer.tcomplement.library.steelworks.MixAdditive;
import knightminer.tcomplement.library.steelworks.MixRecipe;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.client.CreativeTab;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.mantle.util.RecipeMatchRegistry;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;

public class TCompRegistry {
    public static final Logger log = Util.getLogger("API");
    public static CreativeTab tabGeneral = new CreativeTab("TCompGeneral", new ItemStack(Blocks.field_150336_V));
    public static CreativeTab tabTools = new CreativeTab("TCompTools", new ItemStack(Items.field_151035_b));
    private static List<MeltingRecipe> meltingOverrides = Lists.newLinkedList();
    private static List<IBlacklist> meltingBlacklist = Lists.newLinkedList();
    private static List<IMixRecipe> mixRegistry = Lists.newLinkedList();
    private static Map<MixAdditive, RecipeMatchRegistry> mixAdditives = new EnumMap<MixAdditive, RecipeMatchRegistry>(MixAdditive.class);
    private static List<IHeatRecipe> heatRegistry;
    private static List<HighOvenFuel> highOvenFuels;
    private static List<MeltingRecipe> highOvenOverrides;

    public static void registerMelterOverride(MeltingRecipe recipe) {
        if (new TCompRegisterEvent.MelterOverrideRegisterEvent(recipe).fire()) {
            meltingOverrides.add(recipe);
        } else {
            try {
                String input = recipe.input.getInputs().stream().findFirst().map(ItemStack::func_77977_a).orElse("?");
                log.debug("Registration of melting recipe for " + recipe.getResult().getUnlocalizedName() + " from " + input + " has been cancelled by event");
            }
            catch (Exception e) {
                log.error("Error when logging melting event", (Throwable)e);
            }
        }
    }

    public static List<MeltingRecipe> getAllMeltingOverrides() {
        return ImmutableList.copyOf(meltingOverrides);
    }

    public static void registerMelterBlacklist(IBlacklist blacklist) {
        if (new TCompRegisterEvent.MelterBlackListRegisterEvent(blacklist).fire()) {
            meltingBlacklist.add(blacklist);
        } else {
            try {
                log.debug("Registration of melter blacklist recipe has been cancelled by event");
            }
            catch (Exception e) {
                log.error("Error when logging melting event", (Throwable)e);
            }
        }
    }

    public static void registerMelterBlacklist(RecipeMatch blacklist) {
        TCompRegistry.registerMelterBlacklist(new RecipeMatchBlacklist(blacklist));
    }

    public static boolean isSmeltingHidden(MeltingRecipe recipe) {
        List inputs = recipe.input.getInputs();
        for (IBlacklist blacklist : meltingBlacklist) {
            if (!inputs.stream().anyMatch(blacklist::matches)) continue;
            return true;
        }
        for (MeltingRecipe override : meltingOverrides) {
            if (!inputs.stream().anyMatch(arg_0 -> ((MeltingRecipe)override).matches(arg_0))) continue;
            return true;
        }
        return false;
    }

    public static MeltingRecipe getMelting(ItemStack stack) {
        for (MeltingRecipe recipe : meltingOverrides) {
            if (!recipe.matches(stack)) continue;
            return recipe;
        }
        for (IBlacklist blacklist : meltingBlacklist) {
            if (!blacklist.matches(stack)) continue;
            return null;
        }
        return TinkerRegistry.getMelting((ItemStack)stack);
    }

    @Nonnull
    public static IMixRecipe registerMix(IMixRecipe recipe) {
        if (new TCompRegisterEvent.HighOvenMixRegisterEvent(recipe).fire()) {
            mixRegistry.add(recipe);
            return recipe;
        }
        try {
            FluidStack output = recipe.getOutput();
            if (output != null) {
                log.debug("Registration of mix recipe for " + output.getUnlocalizedName() + " has been cancelled by event");
            }
        }
        catch (Exception e) {
            log.error("Error when logging mix event", (Throwable)e);
        }
        return EmptyMixRecipe.INSTANCE;
    }

    @Nonnull
    public static IMixRecipe registerMix(FluidStack input, FluidStack output) {
        return TCompRegistry.registerMix(new MixRecipe(input, output));
    }

    public static IMixRecipe getMixRecipe(FluidStack fluid, ItemStack oxidizer, ItemStack reducer, ItemStack purifier) {
        for (IMixRecipe recipe : mixRegistry) {
            if (!recipe.matches(fluid, oxidizer, reducer, purifier)) continue;
            return recipe;
        }
        return null;
    }

    public static IHighOvenFilter getFilter(FluidStack input, FluidStack output) {
        for (IHeatRecipe iHeatRecipe : heatRegistry) {
            if (!iHeatRecipe.matches(input, output)) continue;
            return iHeatRecipe;
        }
        for (IMixRecipe iMixRecipe : mixRegistry) {
            if (!iMixRecipe.matches(input, output)) continue;
            return iMixRecipe;
        }
        return null;
    }

    public static void registerMixAdditive(@Nonnull RecipeMatch additive, @Nonnull MixAdditive type) {
        mixAdditives.get((Object)type).addRecipeMatch(additive);
    }

    public static boolean isValidMixAdditive(@Nonnull ItemStack stack, @Nonnull MixAdditive type) {
        return mixAdditives.get((Object)type).matches(new ItemStack[]{stack}).isPresent();
    }

    public static List<IMixRecipe> getAllMixRecipes() {
        return ImmutableList.copyOf(mixRegistry);
    }

    public static void registerHeatRecipe(IHeatRecipe recipe) {
        if (new TCompRegisterEvent.HighOvenHeatRegisterEvent(recipe).fire()) {
            heatRegistry.add(recipe);
        } else {
            try {
                FluidStack output = recipe.getOutput();
                if (output != null) {
                    log.debug("Registration of heat recipe for " + output.getUnlocalizedName() + " has been cancelled by event");
                }
            }
            catch (Exception e) {
                log.error("Error when logging mix event", (Throwable)e);
            }
        }
    }

    public static void registerHeatRecipe(@Nonnull FluidStack input, @Nonnull FluidStack output, int temp) {
        TCompRegistry.registerHeatRecipe(new HeatRecipe(input, output, temp));
    }

    public static IHeatRecipe getHeatRecipe(FluidStack input) {
        for (IHeatRecipe recipe : heatRegistry) {
            if (!recipe.matches(input)) continue;
            return recipe;
        }
        return null;
    }

    public static List<IHeatRecipe> getAllHeatRecipes() {
        return ImmutableList.copyOf(heatRegistry);
    }

    private static void registerFuel(HighOvenFuel fuel) {
        if (new TCompRegisterEvent.HighOvenFuelRegisterEvent(fuel).fire()) {
            highOvenFuels.add(fuel);
        } else {
            try {
                String input = fuel.getFuels().stream().findFirst().map(ItemStack::func_77977_a).orElse("?");
                log.debug("Registration of high oven fuel for " + input + " has been cancelled by event");
            }
            catch (Exception e) {
                log.error("Error when logging high oven fuel event", (Throwable)e);
            }
        }
    }

    public static void registerFuel(RecipeMatch fuel, int time, int rate) {
        TCompRegistry.registerFuel(new HighOvenFuel(fuel, time, rate));
    }

    public static void registerFuel(ItemStack fuel, int time, int rate) {
        TCompRegistry.registerFuel(RecipeMatch.of((ItemStack)fuel), time, rate);
    }

    public static void registerFuel(String fuel, int time, int rate) {
        TCompRegistry.registerFuel(RecipeMatch.of((String)fuel), time, rate);
    }

    public static HighOvenFuel getHighOvenFuel(ItemStack input) {
        for (HighOvenFuel fuel : highOvenFuels) {
            if (!fuel.matches(input)) continue;
            return fuel;
        }
        return null;
    }

    public static boolean isHighOvenFuel(ItemStack input) {
        return TCompRegistry.getHighOvenFuel(input) != null;
    }

    public static List<HighOvenFuel> getAllHighOvenFuels() {
        return ImmutableList.copyOf(highOvenFuels);
    }

    public static void registerHighOvenOverride(MeltingRecipe recipe) {
        if (new TCompRegisterEvent.HighOvenOverrideRegisterEvent(recipe).fire()) {
            highOvenOverrides.add(recipe);
        } else {
            try {
                String input = recipe.input.getInputs().stream().findFirst().map(ItemStack::func_77977_a).orElse("?");
                log.debug("Registration of melting recipe for " + recipe.getResult().getUnlocalizedName() + " from " + input + " has been cancelled by event");
            }
            catch (Exception e) {
                log.error("Error when logging melting event", (Throwable)e);
            }
        }
    }

    public static List<MeltingRecipe> getAllHighOvenOverrides() {
        return ImmutableList.copyOf(highOvenOverrides);
    }

    public static boolean isOvenHidden(MeltingRecipe recipe) {
        List inputs = recipe.input.getInputs();
        for (MeltingRecipe override : highOvenOverrides) {
            if (!inputs.stream().anyMatch(arg_0 -> ((MeltingRecipe)override).matches(arg_0))) continue;
            return true;
        }
        return false;
    }

    public static MeltingRecipe getOvenMelting(ItemStack stack) {
        for (MeltingRecipe recipe : highOvenOverrides) {
            if (!recipe.matches(stack)) continue;
            return recipe;
        }
        return TinkerRegistry.getMelting((ItemStack)stack);
    }

    static {
        for (MixAdditive type : MixAdditive.values()) {
            mixAdditives.put(type, new RecipeMatchRegistry());
        }
        heatRegistry = Lists.newLinkedList();
        highOvenFuels = Lists.newLinkedList();
        highOvenOverrides = Lists.newLinkedList();
    }
}

