/*
 * Decompiled with CFR 0.152.
 */
package lcrdrfs.entities;

import javax.annotation.Nullable;
import lcrdrfs.ModItems;
import lcrdrfs.ModSounds;
import lcrdrfs.confighandler.ConfigHandler;
import lcrdrfs.entities.EntityLaserCreeper;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityRoboDino
extends EntityTameable
implements IMob {
    private static final DataParameter<Byte> COLOUR = EntityDataManager.func_187226_a(EntityRoboDino.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> SIZE = EntityDataManager.func_187226_a(EntityRoboDino.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> STATE = EntityDataManager.func_187226_a(EntityRoboDino.class, (DataSerializer)DataSerializers.field_187191_a);
    private EntityAINearestAttackableTarget aiNearestAttackableTarget;
    private int shutUpFFSTime;
    private boolean trackerThing = false;

    public EntityRoboDino(World world) {
        super(world);
        this.func_70105_a(2.5f, 2.0f);
        this.setNewSize(2.5f, 2.0f);
        this.field_70178_ae = true;
        this.field_70138_W = 2.0f;
    }

    protected void func_184651_r() {
        this.aiNearestAttackableTarget = new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.7, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAITempt((EntityCreature)this, 0.5, Item.func_150898_a((Block)Blocks.field_150451_bX), false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.5, 10));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)this.aiNearestAttackableTarget);
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.5f));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLOUR, (Object)0);
        this.field_70180_af.func_187214_a(SIZE, (Object)64);
        this.field_70180_af.func_187214_a(STATE, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.7);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(80.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.75);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEFINED;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187689_f;
    }

    protected SoundEvent func_184639_G() {
        int soundindex = this.func_130014_f_().field_73012_v.nextInt(4);
        switch (soundindex) {
            case 0: {
                return ModSounds.DINO_IDLE1;
            }
            case 1: {
                return ModSounds.DINO_IDLE2;
            }
            case 2: {
                return ModSounds.DINO_IDLE3;
            }
            case 3: {
                return ModSounds.DINO_IDLE4;
            }
        }
        return ModSounds.DINO_IDLE1;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.DINO_DEATH;
    }

    protected float func_70647_i() {
        if (this.getTameState() == 0) {
            return 1.0f;
        }
        return 2.0f - (float)this.getDinoSize() * 0.015625f;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187605_cG, 1.0f, 1.0f);
    }

    public boolean func_70617_f_() {
        return this.func_184179_bs() != null && this.field_70123_F;
    }

    public boolean func_70601_bi() {
        long worldTime = this.func_130014_f_().func_82737_E();
        long spawnDelay = ConfigHandler.TR3X_SPAWN_SPAWN_DELAY * 24000;
        if (this.func_130014_f_().func_175659_aa() != EnumDifficulty.PEACEFUL && this.getTameState() == 0) {
            float light;
            if (worldTime > spawnDelay && (light = this.func_70013_c()) <= 8.0f) {
                return this.func_130014_f_().func_72855_b(this.func_174813_aQ()) && this.func_130014_f_().func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.func_130014_f_().func_72953_d(this.func_174813_aQ());
            }
        } else if (this.getTameState() != 0) {
            return super.func_70601_bi();
        }
        return false;
    }

    public int func_70641_bl() {
        return 1;
    }

    protected boolean func_70692_ba() {
        return this.getTameState() == 0;
    }

    public boolean func_184652_a(EntityPlayer player) {
        return !this.func_70692_ba();
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        this.func_130014_f_().func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSounds.DINO_DEATH, SoundCategory.HOSTILE, 0.1f, this.func_70647_i());
        if (this.getTameState() == 0 || this.getTameState() == 2 || this.getTameState() == 3) {
            this.func_70099_a(new ItemStack(ModItems.ROBO_DINO_PART), 0.0f);
        }
        if (this.getTameState() == 1) {
            this.func_70099_a(new ItemStack(Items.field_151137_ax), 0.0f);
        }
        if (this.getTameState() == 3) {
            this.func_70099_a(new ItemStack(ModItems.ROBO_DINO_CONTROL_MODULE, 1), 0.0f);
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack is = player.field_71071_by.func_70448_g();
        float healingBuff = 0.0f;
        if (!this.func_130014_f_().field_72995_K && !is.func_190926_b() && is.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150451_bX)) {
            if (this.getTameState() == 2 || this.getTameState() == 3) {
                healingBuff = 5.0f;
                if (this.func_110143_aJ() < this.func_110138_aP()) {
                    this.func_70691_i(healingBuff);
                    this.func_70908_e(true);
                    this.func_130014_f_().func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSounds.DINO_EAT, SoundCategory.HOSTILE, 1.0f, this.func_70647_i() * 0.7f);
                    is.func_190918_g(1);
                }
                if (this.func_110143_aJ() >= this.func_110138_aP() && this.shutUpFFSTime == 0) {
                    this.func_130014_f_().func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSounds.DINO_MAX_POWER, SoundCategory.HOSTILE, 0.5f, 1.0f);
                    this.shutUpFFSTime = 60;
                }
            }
            if (this.getTameState() == 1) {
                this.field_70714_bg.func_85156_a((EntityAIBase)this.aiNearestAttackableTarget);
                this.func_70624_b(null);
                this.setDinoSize(this.getDinoSize() + 1);
                if (this.getDinoSize() % 8 == 0) {
                    this.func_130014_f_().func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSounds.DINO_EAT, SoundCategory.HOSTILE, 1.0f, this.func_70647_i() * 0.7f);
                }
                this.func_70606_j(this.func_110143_aJ() + 1.0f);
                is.func_190918_g(1);
                if (this.getDinoSize() >= 64) {
                    this.setDinoSize(64);
                    this.setTameState((byte)2);
                    this.func_130014_f_().func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSounds.DINO_UPGRADE, SoundCategory.HOSTILE, 0.5f, 1.0f);
                    this.shutUpFFSTime = 60;
                }
            }
            return true;
        }
        if (!this.func_130014_f_().field_72995_K && is.func_190926_b() && this.getTameState() == 3) {
            player.func_184220_m((Entity)this);
            return true;
        }
        if (!this.func_130014_f_().field_72995_K && !is.func_190926_b() && is.func_77973_b() == ModItems.ROBO_DINO_CONTROL_MODULE && this.getTameState() == 2) {
            this.setTameState((byte)3);
            this.func_130014_f_().func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSounds.DINO_SADDLED, SoundCategory.HOSTILE, 1.0f, 1.0f);
            is.func_190918_g(1);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public void func_70624_b(EntityLivingBase entity) {
        if (this.getTameState() != 0) {
            if (entity instanceof EntityPlayer) {
                super.func_70624_b(null);
            }
        } else {
            super.func_70624_b(entity);
            if (this.shutUpFFSTime == 0) {
                this.func_130014_f_().func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSounds.DINO_ATTACK, SoundCategory.HOSTILE, 1.0f, 1.0f);
                this.shutUpFFSTime = 60;
            }
        }
    }

    public boolean func_70652_k(Entity entity) {
        if (entity != null && this.func_70032_d(entity) <= 3.0f && entity.func_174813_aQ().field_72337_e > this.func_174813_aQ().field_72338_b && entity.func_174813_aQ().field_72338_b < this.func_174813_aQ().field_72337_e) {
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
            if (((EntityLivingBase)entity).func_110143_aJ() <= 0.0f && this.shutUpFFSTime <= 40) {
                this.func_130014_f_().func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSounds.DINO_TERMINATED, SoundCategory.HOSTILE, 1.0f, 1.0f);
                this.shutUpFFSTime = 60;
            }
        }
        return super.func_70652_k(entity);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source instanceof EntityDamageSourceIndirect) {
            this.func_130014_f_().func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187689_f, SoundCategory.BLOCKS, 0.5f, 3.0f);
            return false;
        }
        return super.func_70097_a(source, damage);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (SIZE.equals(key)) {
            int size = this.getDinoSize();
            this.setNewSize(0.5f + (float)size * 0.03125f, 0.4f + (float)size * 0.025f);
        }
        super.func_184206_a(key);
    }

    protected void setNewSize(float width, float height) {
        if (this.field_70130_N != width || this.field_70131_O != height) {
            float f = width;
            this.field_70130_N = width;
            this.field_70131_O = height;
            AxisAlignedBB axisalignedbb = this.func_174813_aQ();
            this.func_174826_a(new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72340_a + (double)width, axisalignedbb.field_72338_b + (double)height, axisalignedbb.field_72339_c + (double)width));
            if (width > f && !this.field_70148_d && !this.func_130014_f_().field_72995_K) {
                this.func_70091_d(MoverType.SELF, f - width, 0.0, f - width);
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!(this.func_130014_f_().field_72995_K || this.getTameState() != 0 || this.func_130014_f_().func_72820_D() >= (long)(ConfigHandler.TR3X_SPAWN_SPAWN_DELAY * 24000) && this.func_130014_f_().func_175659_aa() != EnumDifficulty.PEACEFUL)) {
            this.func_70106_y();
        }
        if (this.shutUpFFSTime > 0) {
            --this.shutUpFFSTime;
            this.field_70757_a = -this.func_70627_aG();
        }
        if (this.func_70638_az() != null) {
            this.func_70671_ap().func_75650_a(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u + (double)this.func_70638_az().func_70047_e(), this.func_70638_az().field_70161_v, 10.0f, (float)this.func_70646_bf());
        }
    }

    public void func_191986_a(float strafe, float up, float forward) {
        if (this.func_184207_aI() && this.func_82171_bF()) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
            this.field_70126_B = this.field_70177_z = entitylivingbase.field_70177_z;
            this.field_70125_A = entitylivingbase.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = entitylivingbase.field_70702_br * 0.5f;
            forward = entitylivingbase.field_191988_bg * 0.75f;
            if (forward <= 0.0f) {
                forward *= 0.25f;
            }
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            if (this.func_184186_bw()) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_191986_a(strafe, up, forward);
            } else if (entitylivingbase instanceof EntityPlayer) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f2 > 0.5f) {
                f2 = 0.5f;
            }
            this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            this.field_70747_aH = 0.02f;
            super.func_191986_a(strafe, up, forward);
        }
    }

    public boolean func_82171_bF() {
        Entity entity = this.func_184179_bs();
        return entity instanceof EntityLivingBase;
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public void func_184232_k(Entity entity) {
        super.func_184232_k(entity);
        if (entity instanceof EntityLivingBase) {
            double a = Math.toRadians(this.field_70761_aq);
            double offSetX = -Math.sin(a) * 0.35;
            double offSetZ = Math.cos(a) * 0.35;
            if (entity instanceof EntityLaserCreeper) {
                entity.func_70107_b(this.field_70165_t - offSetX, this.field_70163_u + 1.875 + entity.func_70033_W(), this.field_70161_v - offSetZ);
            } else {
                entity.func_70107_b(this.field_70165_t - offSetX, this.field_70163_u + 1.8 + entity.func_70033_W(), this.field_70161_v - offSetZ);
            }
        }
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        EntityLaserCreeper laserCreeper = new EntityLaserCreeper(this.func_130014_f_());
        laserCreeper.func_70012_b(this.field_70165_t, this.field_70163_u + 1.9, this.field_70161_v, this.field_70177_z, 0.0f);
        laserCreeper.func_180482_a(difficulty, null);
        this.func_130014_f_().func_72838_d((Entity)laserCreeper);
        laserCreeper.func_184205_a((Entity)this, true);
        return livingdata;
    }

    public EntityAgeable func_90011_a(EntityAgeable entityageable) {
        return null;
    }

    public void setTameState(byte tameState) {
        this.field_70180_af.func_187227_b(STATE, (Object)tameState);
    }

    public byte getTameState() {
        return (Byte)this.field_70180_af.func_187225_a(STATE);
    }

    public void setDinoSize(int size) {
        this.field_70180_af.func_187227_b(SIZE, (Object)size);
        this.setNewSize(0.5f + (float)size * 0.03125f, 0.4f + (float)size * 0.025f);
    }

    public int getDinoSize() {
        return (Integer)this.field_70180_af.func_187225_a(SIZE);
    }

    public void setPaintColour(int colour) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(COLOUR);
        this.field_70180_af.func_187227_b(COLOUR, (Object)((byte)(b0 & 0xF0 | colour & 0xF)));
    }

    public int getPaintColour() {
        return (Byte)this.field_70180_af.func_187225_a(COLOUR) & 0xF;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("size", this.getDinoSize());
        nbt.func_74774_a("tameState", this.getTameState());
        nbt.func_74774_a("color", (byte)this.getPaintColour());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setDinoSize(nbt.func_74762_e("size"));
        this.setTameState(nbt.func_74771_c("tameState"));
        this.setPaintColour(nbt.func_74771_c("color"));
    }
}

