/*
 * Decompiled with CFR 0.152.
 */
package lcrdrfs.confighandler;

import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigHandler {
    public static final ConfigHandler INSTANCE = new ConfigHandler();
    public Configuration config;
    public static int LASER_CREEPER_MIN_SPAWN_SIZE;
    public static int LASER_CREEPER_MAX_SPAWN_SIZE;
    public static int LASER_CREEPER_SPAWN_PROBABILITY;
    public static int TR3X_MIN_SPAWN_SIZE;
    public static int TR3X_MAX_SPAWN_SIZE;
    public static int TR3X_SPAWN_PROBABILITY;
    public static int JET_PACK_SPIDER_MIN_SPAWN_SIZE;
    public static int JET_PACK_SPIDER_MAX_SPAWN_SIZE;
    public static int JET_PACK_SPIDER_SPAWN_PROBABILITY;
    public static float CREEPER_LASER_DAMAGE;
    public static boolean CREEPER_LASER_FIRE_DAMAGE;
    public static int CREEPER_LASER_BURN_TIME;
    public static float PLAYER_LASER_DAMAGE;
    public static boolean PLAYER_LASER_FIRE_DAMAGE;
    public static int PLAYER_LASER_BURN_TIME;
    public static float CREEPSSILE_DAMAGE;
    public static boolean CREEPSSILE_EXPLOSION;
    public static float PLAYER_CREEPSSILE_DAMAGE;
    public static boolean PLAYER_CREEPSSILE_EXPLOSION;
    public static int JET_PACK_SPIDER_SPAWN_DELAY;
    public static int LASER_CREEPER_SPAWN_DELAY;
    public static int TR3X_SPAWN_SPAWN_DELAY;
    public final String[] usedCategories = new String[]{"Laser Creeper Settings", "T-R3X 1000 Settings", "Jet Pack Spider Settings", "Laser Blaster Settings", "Bazookoid Settings", "Invasion Spawn Settings"};

    public void loadConfig(FMLPreInitializationEvent event) {
        this.config = new Configuration(event.getSuggestedConfigurationFile());
        this.config.load();
        this.syncConfigs();
    }

    private void syncConfigs() {
        LASER_CREEPER_MIN_SPAWN_SIZE = this.config.get("Laser Creeper Settings", "Spawn Group Minimum Size", 1).getInt(1);
        LASER_CREEPER_MAX_SPAWN_SIZE = this.config.get("Laser Creeper Settings", "Spawn Group Maximum Size", 3).getInt(3);
        LASER_CREEPER_SPAWN_PROBABILITY = this.config.get("Laser Creeper Settings", "Spawn Chance Probability", 10).getInt(10);
        TR3X_MIN_SPAWN_SIZE = this.config.get("T-R3X 1000 Settings", "Spawn Group Minimum Size", 1).getInt(1);
        TR3X_MAX_SPAWN_SIZE = this.config.get("T-R3X 1000 Settings", "Spawn Group Maximum Size", 3).getInt(3);
        TR3X_SPAWN_PROBABILITY = this.config.get("T-R3X 1000 Settings", "Spawn Chance Probability", 10).getInt(10);
        JET_PACK_SPIDER_MIN_SPAWN_SIZE = this.config.get("Jet Pack Spider Settings", "Spawn Group Minimum Size", 1).getInt(1);
        JET_PACK_SPIDER_MAX_SPAWN_SIZE = this.config.get("Jet Pack Spider Settings", "Spawn Group Maximum Size", 3).getInt(3);
        JET_PACK_SPIDER_SPAWN_PROBABILITY = this.config.get("Jet Pack Spider Settings", "Spawn Chance Probability", 5).getInt(5);
        CREEPSSILE_EXPLOSION = this.config.get("Jet Pack Spider Settings", "Enable Creepssile Explosions", true).getBoolean(true);
        CREEPSSILE_DAMAGE = this.config.get("Jet Pack Spider Settings", "Non-Explosion Damage caused by Creepssile", 6).getInt(6);
        PLAYER_CREEPSSILE_EXPLOSION = this.config.get("Bazookoid Settings", "Enable Creepssile Explosions", true).getBoolean(true);
        PLAYER_CREEPSSILE_DAMAGE = this.config.get("Bazookoid Settings", "Non-Explosion Damage caused by Creepssile", 10).getInt(10);
        CREEPER_LASER_DAMAGE = this.config.get("Laser Creeper Settings", "Damage caused by Creeper Laser Blaster", 4).getInt(4);
        CREEPER_LASER_FIRE_DAMAGE = this.config.get("Laser Creeper Settings", "Enable Creeper Laser Fire Damage", true).getBoolean(true);
        CREEPER_LASER_BURN_TIME = this.config.get("Laser Creeper Settings", "Creeper Laser Fire Burn Time in Seconds", 10).getInt(10);
        PLAYER_LASER_DAMAGE = this.config.get("Laser Blaster Settings", "Damage caused by Laser Blaster", 10).getInt(10);
        PLAYER_LASER_FIRE_DAMAGE = this.config.get("Laser Blaster Settings", "Enable Laser Fire Damage", true).getBoolean(true);
        PLAYER_LASER_BURN_TIME = this.config.get("Laser Blaster Settings", "Laser Fire Burn Time in Seconds", 10).getInt(10);
        JET_PACK_SPIDER_SPAWN_DELAY = this.config.get("Invasion Spawn Settings", "Delay Time in Days Before Jet Pack Spiders Spawn", 1).getInt(1);
        LASER_CREEPER_SPAWN_DELAY = this.config.get("Invasion Spawn Settings", "Delay Time in Days Before Laser Creepers Spawn", 1).getInt(1);
        TR3X_SPAWN_SPAWN_DELAY = this.config.get("Invasion Spawn Settings", "Delay Time in Days Before T-R3X Riders Spawn", 1).getInt(1);
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("lcrdrfs")) {
            this.syncConfigs();
        }
    }
}

