/*
 * Decompiled with CFR 0.152.
 */
package lcrdrfs;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModSounds {
    public static final List<SoundEvent> SOUNDS = new ArrayList<SoundEvent>();
    public static final SoundEvent LASERBEAM = ModSounds.registerSoundResource("laserbeam");
    public static final SoundEvent LASER_RICOCHET = ModSounds.registerSoundResource("laser_ricochet");
    public static final SoundEvent DINO_IDLE1 = ModSounds.registerSoundResource("dino_idle1");
    public static final SoundEvent DINO_IDLE2 = ModSounds.registerSoundResource("dino_idle2");
    public static final SoundEvent DINO_IDLE3 = ModSounds.registerSoundResource("dino_idle3");
    public static final SoundEvent DINO_IDLE4 = ModSounds.registerSoundResource("dino_idle4");
    public static final SoundEvent DINO_EAT = ModSounds.registerSoundResource("dino_eat");
    public static final SoundEvent DINO_DEATH = ModSounds.registerSoundResource("dino_death");
    public static final SoundEvent DINO_ATTACK = ModSounds.registerSoundResource("dino_attack");
    public static final SoundEvent DINO_TERMINATED = ModSounds.registerSoundResource("dino_terminated");
    public static final SoundEvent DINO_SADDLED = ModSounds.registerSoundResource("dino_saddled");
    public static final SoundEvent DINO_PARENT_ID = ModSounds.registerSoundResource("dino_parent_id");
    public static final SoundEvent DINO_UPGRADE = ModSounds.registerSoundResource("dino_upgrade");
    public static final SoundEvent DINO_MAX_POWER = ModSounds.registerSoundResource("dino_max_power");
    public static final SoundEvent CREEPSSILE_LAUNCH = ModSounds.registerSoundResource("creepssile_launch");
    public static final SoundEvent DINO_SPRAY = ModSounds.registerSoundResource("dino_spray");
    public static final SoundEvent JETPACK_SPIDER_IDLE1 = ModSounds.registerSoundResource("jetpack_spider_idle1");
    public static final SoundEvent JETPACK_SPIDER_IDLE2 = ModSounds.registerSoundResource("jetpack_spider_idle2");
    public static final SoundEvent JETPACK_SPIDER_IDLE3 = ModSounds.registerSoundResource("jetpack_spider_idle3");
    public static final SoundEvent JETPACK_SPIDER_CONVERSION = ModSounds.registerSoundResource("jetpack_spider_conversion");
    public static final SoundEvent JETPACK_SPIDER_DEATH = ModSounds.registerSoundResource("jetpack_spider_death");
    public static final SoundEvent JETPACK_SPIDER_HURT = ModSounds.registerSoundResource("jetpack_spider_hurt");
    public static final SoundEvent JETPACK_SPIDER_TARGET = ModSounds.registerSoundResource("jetpack_spider_target");
    public static final SoundEvent RELOAD = ModSounds.registerSoundResource("reload");
    public static final SoundEvent DAMAGE_REPAIRED = ModSounds.registerSoundResource("damage_repaired");

    public static SoundEvent registerSoundResource(String name) {
        return new SoundEvent(new ResourceLocation("lcrdrfs", name));
    }

    public static void init() {
        try {
            for (Field field : ModSounds.class.getDeclaredFields()) {
                Object obj = field.get(null);
                if (!(obj instanceof SoundEvent)) continue;
                SoundEvent sound = (SoundEvent)obj;
                String name = field.getName().toLowerCase(Locale.ENGLISH);
                ModSounds.registerSoundName(name, sound);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void registerSoundName(String name, SoundEvent sound) {
        SOUNDS.add(sound);
        sound.setRegistryName("lcrdrfs", name);
    }

    @Mod.EventBusSubscriber(modid="lcrdrfs")
    public static class RegistrationHandlerSounds {
        @SubscribeEvent
        public static void registerSoundEvents(RegistryEvent.Register<SoundEvent> event) {
            ModSounds.init();
            IForgeRegistry registry = event.getRegistry();
            for (SoundEvent sounds : SOUNDS) {
                registry.register((IForgeRegistryEntry)sounds);
            }
        }
    }
}

