/*
 * Decompiled with CFR 0.152.
 */
package lcrdrfs;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import lcrdrfs.blocks.BlockCreeperChiliCrystal;
import lcrdrfs.blocks.BlockRoboDinoEgg;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModBlocks {
    private static final List<Block> BLOCKS = new LinkedList<Block>();
    public static final List<ItemBlock> ITEM_BLOCKS = new ArrayList<ItemBlock>();
    public static final Block ROBO_DINO_EGG = new BlockRoboDinoEgg();
    public static final ItemBlock ROBO_DINO_EGG_ITEM = new ItemBlock(ROBO_DINO_EGG);
    public static final Block CROP_CREEPER_CHILLI = new BlockCreeperChiliCrystal();
    public static final ItemBlock CROP_CREEPER_CHILLI_ITEM = new ItemBlock(CROP_CREEPER_CHILLI);

    public static void init() {
        try {
            for (Field field : ModBlocks.class.getDeclaredFields()) {
                String name;
                Object obj = field.get(null);
                if (obj instanceof Block) {
                    Block block = (Block)obj;
                    name = field.getName().toLowerCase(Locale.ENGLISH);
                    ModBlocks.registerBlock(name, block);
                }
                if (!(obj instanceof ItemBlock)) continue;
                ItemBlock blockItem = (ItemBlock)obj;
                name = field.getName().toLowerCase(Locale.ENGLISH);
                ModBlocks.registerItemBlock(name, blockItem);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void registerBlock(String name, Block block) {
        BLOCKS.add(block);
        ((Block)block.setRegistryName("lcrdrfs", name)).func_149663_c("lcrdrfs." + name);
    }

    public static void registerItemBlock(String name, ItemBlock item) {
        ITEM_BLOCKS.add(item);
        ((Item)item.setRegistryName("lcrdrfs", name)).func_77655_b("lcrdrfs." + name);
    }

    @Mod.EventBusSubscriber(modid="lcrdrfs")
    public static class RegistrationHandlerBlocks {
        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            ModBlocks.init();
            IForgeRegistry registry = event.getRegistry();
            for (Block block : BLOCKS) {
                registry.register((IForgeRegistryEntry)block);
            }
        }

        @SubscribeEvent
        public static void registerItemBlocks(RegistryEvent.Register<Item> event) {
            IForgeRegistry registry = event.getRegistry();
            for (ItemBlock item : ITEM_BLOCKS) {
                registry.register((IForgeRegistryEntry)item);
            }
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public static void registerModels(ModelRegistryEvent event) {
            for (ItemBlock item : ITEM_BLOCKS) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName().toString(), "inventory"));
            }
        }
    }
}

