/*
 * Decompiled with CFR 0.152.
 */
package com.camellias.resizer.handlers;

import com.camellias.resizer.Main;
import com.camellias.resizer.handlers.ClimbingHandler;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class PotionHandler {
    @SubscribeEvent
    public static void isPotionApplicable(PotionEvent.PotionApplicableEvent event) {
        PotionHandler.setPotionApplicability(event, Main.SHRINKING);
        PotionHandler.setPotionApplicability(event, Main.GROWTH);
    }

    private static void setPotionApplicability(PotionEvent.PotionApplicableEvent event, Potion potionTarget) {
        if (event.getPotionEffect().func_188419_a() == potionTarget) {
            Potion potionOld = potionTarget == Main.GROWTH ? Main.SHRINKING : Main.GROWTH;
            event.setResult(event.getEntityLiving().func_70644_a(potionOld) ? Event.Result.DENY : Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void onPlayerUpdate(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        PotionEffect growth = player.func_70660_b(Main.GROWTH);
        PotionEffect shrinking = player.func_70660_b(Main.SHRINKING);
        if (shrinking != null || growth != null) {
            player.field_70138_W = player.field_70131_O / 3.0f;
            if (growth == null) {
                player.field_70747_aH *= 1.75f;
                player.field_70143_R = 0.0f;
                if (shrinking.func_76458_c() >= 1 && ClimbingHandler.canClimb(player, player.func_174811_aO()) && player.field_70123_F) {
                    if (!player.func_70093_af()) {
                        player.field_70181_x = 0.1f;
                    }
                    if (player.func_70093_af()) {
                        player.field_70181_x = 0.0;
                    }
                }
            }
        }
        if (growth == null && shrinking == null) {
            player.field_70138_W = 0.6f;
        }
    }

    @SubscribeEvent
    public static void onLivingump(LivingEvent.LivingJumpEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        PotionEffect shrinking = entity.func_70660_b(Main.SHRINKING);
        PotionEffect growth = entity.func_70660_b(Main.GROWTH);
        if (shrinking != null) {
            entity.field_70181_x = shrinking.func_76458_c() == 0 ? (entity.field_70181_x += (double)shrinking.func_76458_c() + 0.25) : (entity.field_70181_x += (double)shrinking.func_76458_c() / 2.0);
        }
        if (growth != null) {
            entity.field_70181_x += (double)(growth.func_76458_c() + 1) * 0.2;
        }
    }
}

