/*
 * Decompiled with CFR 0.152.
 */
package com.minerarcana.floralchemy;

import com.google.common.collect.Maps;
import com.minerarcana.floralchemy.api.FloralchemyAPI;
import com.teamacronymcoders.base.util.files.BaseFileUtils;
import java.io.File;
import java.util.Map;
import net.minecraft.util.Tuple;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class Config {
    private static final Map<String, Tuple<Integer, Integer>> FUEL_DEFAULTS = Maps.newHashMap();

    public static void initConfig(File configFile) {
        BaseFileUtils.createFile((File)configFile.getParentFile());
        Configuration configuration = new Configuration(configFile);
        Property generateDefaults = configuration.get("general", "generateDefaults", true, "Regenerate Default Fuel Values");
        if (generateDefaults.getBoolean()) {
            for (Map.Entry<String, Tuple<Integer, Integer>> entry : FUEL_DEFAULTS.entrySet()) {
                String category = "fuelValues." + entry.getKey();
                configuration.getInt("burnTime", category, ((Integer)entry.getValue().func_76341_a()).intValue(), 1, 10000, "Amount of Ticks this Fluid will burn");
                configuration.getInt("powerPreTick", category, ((Integer)entry.getValue().func_76340_b()).intValue(), 1, 10000, "Amount of Mana produced each Tick");
            }
            generateDefaults.set(false);
        }
        ConfigCategory fuelValues = configuration.getCategory("fuelValues");
        for (ConfigCategory fuelEntry : fuelValues.getChildren()) {
            String fluidName = fuelEntry.getName();
            int burnTime = fuelEntry.get("burnTime").getInt(1);
            int powerPreTick = fuelEntry.get("powerPreTick").getInt(1);
            FloralchemyAPI.getFluidFuelRegistry().putFuel(fluidName, burnTime, powerPreTick);
        }
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    static {
        FUEL_DEFAULTS.put("oil", (Tuple<Integer, Integer>)new Tuple((Object)100, (Object)50));
        FUEL_DEFAULTS.put("fuel", (Tuple<Integer, Integer>)new Tuple((Object)750, (Object)50));
        FUEL_DEFAULTS.put("diesel", (Tuple<Integer, Integer>)new Tuple((Object)350, (Object)50));
        FUEL_DEFAULTS.put("biodiesel", (Tuple<Integer, Integer>)new Tuple((Object)250, (Object)50));
    }
}

