/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.commands;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.mc1120.commands.CraftTweakerCommand;
import crafttweaker.mc1120.commands.SpecialMessagesChat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import mekanism.common.integration.crafttweaker.helpers.RecipeInfoHelper;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.AdvancedMachineInput;
import mekanism.common.recipe.inputs.ChemicalPairInput;
import mekanism.common.recipe.inputs.DoubleMachineInput;
import mekanism.common.recipe.inputs.FluidInput;
import mekanism.common.recipe.inputs.GasInput;
import mekanism.common.recipe.inputs.InfusionInput;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.recipe.inputs.PressurizedInput;
import mekanism.common.recipe.machines.ChemicalInfuserRecipe;
import mekanism.common.recipe.machines.CombinerRecipe;
import mekanism.common.recipe.machines.CrusherRecipe;
import mekanism.common.recipe.machines.CrystallizerRecipe;
import mekanism.common.recipe.machines.DissolutionRecipe;
import mekanism.common.recipe.machines.EnrichmentRecipe;
import mekanism.common.recipe.machines.InjectionRecipe;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.machines.MetallurgicInfuserRecipe;
import mekanism.common.recipe.machines.OsmiumCompressorRecipe;
import mekanism.common.recipe.machines.OxidationRecipe;
import mekanism.common.recipe.machines.PressurizedRecipe;
import mekanism.common.recipe.machines.PurificationRecipe;
import mekanism.common.recipe.machines.SawmillRecipe;
import mekanism.common.recipe.machines.SeparatorRecipe;
import mekanism.common.recipe.machines.SmeltingRecipe;
import mekanism.common.recipe.machines.SolarNeutronRecipe;
import mekanism.common.recipe.machines.ThermalEvaporationRecipe;
import mekanism.common.recipe.machines.WasherRecipe;
import mekanism.common.recipe.outputs.ChanceOutput;
import mekanism.common.recipe.outputs.ChemicalPairOutput;
import mekanism.common.recipe.outputs.FluidOutput;
import mekanism.common.recipe.outputs.GasOutput;
import mekanism.common.recipe.outputs.ItemStackOutput;
import mekanism.common.recipe.outputs.MachineOutput;
import mekanism.common.recipe.outputs.PressurizedOutput;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class MekRecipesCommand
extends CraftTweakerCommand {
    private final List<String> subCommands = Stream.of("crystallizer", "dissolution", "chemicalInfuser", "injection", "oxidizer", "washer", "combiner", "crusher", "separator", "smelter", "enrichment", "metallurgicInfuser", "compressor", "sawmill", "prc", "purification", "solarneutronactivator", "thermalevaporation").collect(Collectors.toList());

    public MekRecipesCommand() {
        super("mekrecipes");
    }

    protected void init() {
        this.setDescription(new ITextComponent[]{SpecialMessagesChat.getClickableCommandText((String)(TextFormatting.DARK_GREEN + "/ct " + this.subCommandName + "<type>"), (String)("/ct " + this.subCommandName), (boolean)true), SpecialMessagesChat.getNormalMessage((String)(TextFormatting.DARK_AQUA + "Outputs a list of all registered Mekanism Machine recipes to the crafttweaker.log for the given machine type."))});
    }

    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
        RecipeHandler.Recipe<MachineInput, MachineOutput, MachineRecipe> type;
        if (args.length == 0 || !this.subCommands.contains(args[0])) {
            sender.func_145747_a(SpecialMessagesChat.getNormalMessage((String)("Recipe Type required, pick one of the following: " + Arrays.toString(this.subCommands.toArray()))));
            return;
        }
        String subCommand = args[0];
        CraftTweakerAPI.logCommand((String)(subCommand + ":"));
        switch (subCommand) {
            case "crystallizer": {
                type = RecipeHandler.Recipe.CHEMICAL_CRYSTALLIZER;
                for (CrystallizerRecipe recipe : RecipeHandler.Recipe.CHEMICAL_CRYSTALLIZER.get().values()) {
                    CraftTweakerAPI.logCommand((String)String.format("mods.mekanism.chemical.crystallizer.addRecipe(%s, %s)", RecipeInfoHelper.getGasName(((GasInput)recipe.getInput()).ingredient), RecipeInfoHelper.getItemName(((ItemStackOutput)recipe.getOutput()).output)));
                }
                break;
            }
            case "dissolution": {
                type = RecipeHandler.Recipe.CHEMICAL_DISSOLUTION_CHAMBER;
                for (DissolutionRecipe recipe : RecipeHandler.Recipe.CHEMICAL_DISSOLUTION_CHAMBER.get().values()) {
                    CraftTweakerAPI.logCommand((String)String.format("mods.mekanism.chemical.dissolution.addRecipe(%s, %s)", RecipeInfoHelper.getItemName(((ItemStackInput)recipe.getInput()).ingredient), RecipeInfoHelper.getGasName(((GasOutput)recipe.getOutput()).output)));
                }
                break;
            }
            case "chemicalInfuser": {
                type = RecipeHandler.Recipe.CHEMICAL_INFUSER;
                for (ChemicalInfuserRecipe recipe : RecipeHandler.Recipe.CHEMICAL_INFUSER.get().values()) {
                    CraftTweakerAPI.logCommand((String)String.format("mods.mekanism.chemical.infuser.addRecipe(%s, %s, %s)", RecipeInfoHelper.getGasName(((ChemicalPairInput)recipe.getInput()).leftGas), RecipeInfoHelper.getGasName(((ChemicalPairInput)recipe.getInput()).rightGas), RecipeInfoHelper.getGasName(((GasOutput)recipe.getOutput()).output)));
                }
                break;
            }
            case "injection": {
                type = RecipeHandler.Recipe.CHEMICAL_INJECTION_CHAMBER;
                for (InjectionRecipe recipe : RecipeHandler.Recipe.CHEMICAL_INJECTION_CHAMBER.get().values()) {
                    CraftTweakerAPI.logCommand((String)String.format("mods.mekanism.chemical.injection.addRecipe(%s, %s, %s)", RecipeInfoHelper.getItemName(((AdvancedMachineInput)recipe.getInput()).itemStack), RecipeInfoHelper.getGasName(((AdvancedMachineInput)recipe.getInput()).gasType), RecipeInfoHelper.getItemName(((ItemStackOutput)recipe.getOutput()).output)));
                }
                break;
            }
            case "oxidizer": {
                type = RecipeHandler.Recipe.CHEMICAL_OXIDIZER;
                for (OxidationRecipe recipe : RecipeHandler.Recipe.CHEMICAL_OXIDIZER.get().values()) {
                    CraftTweakerAPI.logCommand((String)String.format("mods.mekanism.chemical.oxidizer.addRecipe(%s, %s)", RecipeInfoHelper.getItemName(((ItemStackInput)recipe.getInput()).ingredient), RecipeInfoHelper.getGasName(((GasOutput)recipe.getOutput()).output)));
                }
                break;
            }
            case "washer": {
                type = RecipeHandler.Recipe.CHEMICAL_WASHER;
                for (WasherRecipe recipe : RecipeHandler.Recipe.CHEMICAL_WASHER.get().values()) {
                    CraftTweakerAPI.logCommand((String)String.format("mods.mekanism.chemical.washer.addRecipe(%s, %s)", RecipeInfoHelper.getGasName(((GasInput)recipe.getInput()).ingredient), RecipeInfoHelper.getGasName(((GasOutput)recipe.getOutput()).output)));
                }
                break;
            }
            case "combiner": {
                type = RecipeHandler.Recipe.COMBINER;
                for (CombinerRecipe recipe : RecipeHandler.Recipe.COMBINER.get().values()) {
                    CraftTweakerAPI.logCommand((String)String.format("mods.mekanism.combiner.addRecipe(%s, %s, %s)", RecipeInfoHelper.getItemName(((DoubleMachineInput)recipe.getInput()).itemStack), RecipeInfoHelper.getItemName(((DoubleMachineInput)recipe.getInput()).extraStack), RecipeInfoHelper.getItemName(((ItemStackOutput)recipe.getOutput()).output)));
                }
                break;
            }
            case "crusher": {
                type = RecipeHandler.Recipe.CRUSHER;
                for (CrusherRecipe recipe : RecipeHandler.Recipe.CRUSHER.get().values()) {
                    CraftTweakerAPI.logCommand((String)String.format("mods.mekanism.crusher.addRecipe(%s, %s)", RecipeInfoHelper.getItemName(((ItemStackInput)recipe.getInput()).ingredient), RecipeInfoHelper.getItemName(((ItemStackOutput)recipe.getOutput()).output)));
                }
                break;
            }
            case "separator": {
                type = RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR;
                for (SeparatorRecipe recipe : RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR.get().values()) {
                    CraftTweakerAPI.logCommand((String)String.format("mods.mekanism.separator.addRecipe(%s, %s, %s, %s)", RecipeInfoHelper.getFluidName(((FluidInput)recipe.getInput()).ingredient), recipe.energyUsage, RecipeInfoHelper.getGasName(((ChemicalPairOutput)recipe.getOutput()).leftGas), RecipeInfoHelper.getGasName(((ChemicalPairOutput)recipe.getOutput()).rightGas)));
                }
                break;
            }
            case "smelter": {
                type = RecipeHandler.Recipe.ENERGIZED_SMELTER;
                for (SmeltingRecipe recipe : RecipeHandler.Recipe.ENERGIZED_SMELTER.get().values()) {
                    CraftTweakerAPI.logCommand((String)String.format("mods.mekanism.smelter.addRecipe(%s, %s)", RecipeInfoHelper.getItemName(((ItemStackInput)recipe.getInput()).ingredient), RecipeInfoHelper.getItemName(((ItemStackOutput)recipe.getOutput()).output)));
                }
                break;
            }
            case "enrichment": {
                type = RecipeHandler.Recipe.ENRICHMENT_CHAMBER;
                for (EnrichmentRecipe recipe : RecipeHandler.Recipe.ENRICHMENT_CHAMBER.get().values()) {
                    CraftTweakerAPI.logCommand((String)String.format("mods.mekanism.enrichment.addRecipe(%s, %s)", RecipeInfoHelper.getItemName(((ItemStackInput)recipe.getInput()).ingredient), RecipeInfoHelper.getItemName(((ItemStackOutput)recipe.getOutput()).output)));
                }
                break;
            }
            case "metallurgicInfuser": {
                type = RecipeHandler.Recipe.METALLURGIC_INFUSER;
                for (MetallurgicInfuserRecipe recipe : RecipeHandler.Recipe.METALLURGIC_INFUSER.get().values()) {
                    CraftTweakerAPI.logCommand((String)String.format("mods.mekanism.infuser.addRecipe(%s, %s, %s, %s)", ((InfusionInput)recipe.getInput()).infuse.getType(), ((InfusionInput)recipe.getInput()).infuse.getAmount(), RecipeInfoHelper.getItemName(((InfusionInput)recipe.getInput()).inputStack), RecipeInfoHelper.getItemName(((ItemStackOutput)recipe.getOutput()).output)));
                }
                break;
            }
            case "compressor": {
                type = RecipeHandler.Recipe.OSMIUM_COMPRESSOR;
                for (OsmiumCompressorRecipe recipe : RecipeHandler.Recipe.OSMIUM_COMPRESSOR.get().values()) {
                    CraftTweakerAPI.logCommand((String)String.format("mods.mekanism.compressor.addRecipe(%s, %s, %s)", RecipeInfoHelper.getItemName(((AdvancedMachineInput)recipe.getInput()).itemStack), RecipeInfoHelper.getGasName(((AdvancedMachineInput)recipe.getInput()).gasType), RecipeInfoHelper.getItemName(((ItemStackOutput)recipe.getOutput()).output)));
                }
                break;
            }
            case "sawmill": {
                type = RecipeHandler.Recipe.PRECISION_SAWMILL;
                for (SawmillRecipe recipe : RecipeHandler.Recipe.PRECISION_SAWMILL.get().values()) {
                    CraftTweakerAPI.logCommand((String)String.format("mods.mekanism.sawmill.addRecipe(%s, %s, %s, %s)", RecipeInfoHelper.getItemName(((ItemStackInput)recipe.getInput()).ingredient), RecipeInfoHelper.getItemName(((ChanceOutput)recipe.getOutput()).primaryOutput), RecipeInfoHelper.getItemName(((ChanceOutput)recipe.getOutput()).secondaryOutput), ((ChanceOutput)recipe.getOutput()).secondaryChance));
                }
                break;
            }
            case "prc": {
                type = RecipeHandler.Recipe.PRESSURIZED_REACTION_CHAMBER;
                for (PressurizedRecipe recipe : RecipeHandler.Recipe.PRESSURIZED_REACTION_CHAMBER.get().values()) {
                    CraftTweakerAPI.logCommand((String)String.format("mods.mekanism.reaction.addRecipe(%s, %s, %s, %s, %s, %s, %s)", RecipeInfoHelper.getItemName(((PressurizedInput)recipe.getInput()).getSolid()), RecipeInfoHelper.getFluidName(((PressurizedInput)recipe.getInput()).getFluid()), RecipeInfoHelper.getGasName(((PressurizedInput)recipe.getInput()).getGas()), RecipeInfoHelper.getItemName(((PressurizedOutput)recipe.getOutput()).getItemOutput()), RecipeInfoHelper.getGasName(((PressurizedOutput)recipe.getOutput()).getGasOutput()), recipe.extraEnergy, recipe.ticks));
                }
                break;
            }
            case "purification": {
                type = RecipeHandler.Recipe.PURIFICATION_CHAMBER;
                for (PurificationRecipe recipe : RecipeHandler.Recipe.PURIFICATION_CHAMBER.get().values()) {
                    CraftTweakerAPI.logCommand((String)String.format("mods.mekanism.purification.addRecipe(%s, %s, %s)", RecipeInfoHelper.getItemName(((AdvancedMachineInput)recipe.getInput()).itemStack), RecipeInfoHelper.getGasName(((AdvancedMachineInput)recipe.getInput()).gasType), RecipeInfoHelper.getItemName(((ItemStackOutput)recipe.getOutput()).output)));
                }
                break;
            }
            case "solarneutronactivator": {
                type = RecipeHandler.Recipe.SOLAR_NEUTRON_ACTIVATOR;
                for (SolarNeutronRecipe recipe : RecipeHandler.Recipe.SOLAR_NEUTRON_ACTIVATOR.get().values()) {
                    CraftTweakerAPI.logCommand((String)String.format("mods.mekanism.solarneutronactivator.addRecipe(%s, %s)", RecipeInfoHelper.getGasName(((GasInput)recipe.getInput()).ingredient), RecipeInfoHelper.getGasName(((GasOutput)recipe.getOutput()).output)));
                }
                break;
            }
            case "thermalevaporation": {
                type = RecipeHandler.Recipe.THERMAL_EVAPORATION_PLANT;
                for (ThermalEvaporationRecipe recipe : RecipeHandler.Recipe.THERMAL_EVAPORATION_PLANT.get().values()) {
                    CraftTweakerAPI.logCommand((String)String.format("mods.mekanism.thermalevaporation.addRecipe(%s, %s)", RecipeInfoHelper.getFluidName(((FluidInput)recipe.getInput()).ingredient), RecipeInfoHelper.getFluidName(((FluidOutput)recipe.getOutput()).output)));
                }
                break;
            }
            default: {
                sender.func_145747_a(SpecialMessagesChat.getNormalMessage((String)("Recipe Type required, pick one of the following: " + Arrays.toString(this.subCommands.toArray()))));
                return;
            }
        }
        sender.func_145747_a(SpecialMessagesChat.getLinkToCraftTweakerLog((String)("List of " + type.get().size() + " " + subCommand + " recipes generated;"), (ICommandSender)sender));
    }

    public List<String> getSubSubCommand(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length > 1) {
            return Collections.emptyList();
        }
        String start = args[0].toLowerCase();
        return this.subCommands.stream().filter(command -> command.toLowerCase().startsWith(start)).collect(Collectors.toList());
    }
}

