/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration;

import appeng.api.AEApi;
import appeng.api.definitions.IBlocks;
import appeng.api.definitions.IItems;
import appeng.api.definitions.IMaterials;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.MachineRecipe;
import ic2.api.recipe.Recipes;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import li.cil.oc.api.Driver;
import li.cil.oc.api.driver.DriverBlock;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Mekanism;
import mekanism.common.MekanismBlocks;
import mekanism.common.MekanismItems;
import mekanism.common.OreDictCache;
import mekanism.common.Resource;
import mekanism.common.block.states.BlockStateTransmitter;
import mekanism.common.integration.OreDictManager;
import mekanism.common.integration.computer.CCPeripheral;
import mekanism.common.integration.computer.OCDriver;
import mekanism.common.integration.crafttweaker.CrafttweakerIntegration;
import mekanism.common.integration.wrenches.Wrenches;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.util.StackUtils;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public final class MekanismHooks {
    public static final String COFH_API_MOD_ID = "cofhapi";
    public static final String IC2_MOD_ID = "ic2";
    public static final String COMPUTERCRAFT_MOD_ID = "computercraft";
    public static final String APPLIED_ENERGISTICS_2_MOD_ID = "appliedenergistics2";
    public static final String TESLA_MOD_ID = "tesla";
    public static final String MCMULTIPART_MOD_ID = "mcmultipart";
    public static final String REDSTONEFLUX_MOD_ID = "redstoneflux";
    public static final String METALLURGY_MOD_ID = "metallurgy";
    public static final String OPENCOMPUTERS_MOD_ID = "opencomputers";
    public static final String GALACTICRAFT_MOD_ID = "Galacticraft API";
    public static final String WAILA_MOD_ID = "Waila";
    public static final String TOP_MOD_ID = "theoneprobe";
    public static final String BUILDCRAFT_MOD_ID = "BuildCraft";
    public static final String CYCLIC_MOD_ID = "cyclicmagic";
    public static final String MYSTICALAGRICULTURE_MOD_ID = "mysticalagriculture";
    public static final String CRAFTTWEAKER_MOD_ID = "crafttweaker";
    public boolean IC2Loaded = false;
    public boolean CCLoaded = false;
    public boolean AE2Loaded = false;
    public boolean TeslaLoaded = false;
    public boolean MCMPLoaded = false;
    public boolean RFLoaded = false;
    public boolean MetallurgyLoaded = false;
    public boolean CyclicLoaded = false;
    public boolean OCLoaded = false;
    public boolean MALoaded = false;
    public boolean CraftTweakerLoaded = false;

    public void hookPreInit() {
        if (Loader.isModLoaded((String)IC2_MOD_ID)) {
            this.IC2Loaded = true;
        }
        if (Loader.isModLoaded((String)COMPUTERCRAFT_MOD_ID)) {
            this.CCLoaded = true;
        }
        if (Loader.isModLoaded((String)APPLIED_ENERGISTICS_2_MOD_ID)) {
            this.AE2Loaded = true;
        }
        if (Loader.isModLoaded((String)OPENCOMPUTERS_MOD_ID)) {
            this.OCLoaded = true;
        }
        if (Loader.isModLoaded((String)TESLA_MOD_ID)) {
            this.TeslaLoaded = true;
        }
        if (Loader.isModLoaded((String)MCMULTIPART_MOD_ID)) {
            this.MCMPLoaded = true;
        }
        if (Loader.isModLoaded((String)REDSTONEFLUX_MOD_ID)) {
            this.RFLoaded = true;
        }
        if (Loader.isModLoaded((String)CYCLIC_MOD_ID)) {
            this.CyclicLoaded = true;
        }
        if (Loader.isModLoaded((String)METALLURGY_MOD_ID)) {
            this.MetallurgyLoaded = true;
        }
        if (Loader.isModLoaded((String)MYSTICALAGRICULTURE_MOD_ID)) {
            this.MALoaded = true;
        }
        if (Loader.isModLoaded((String)CRAFTTWEAKER_MOD_ID)) {
            this.CraftTweakerLoaded = true;
        }
    }

    public void hookInit() {
        FMLInterModComms.sendMessage((String)WAILA_MOD_ID, (String)"register", (String)"mekanism.common.integration.WailaDataProvider.register");
        FMLInterModComms.sendFunctionMessage((String)TOP_MOD_ID, (String)"getTheOneProbe", (String)"mekanism.common.integration.TOPProvider");
        if (this.OCLoaded) {
            this.loadOCDrivers();
        }
        if (this.AE2Loaded) {
            this.registerAE2P2P();
        }
    }

    public void hookPostInit() {
        if (this.IC2Loaded) {
            this.hookIC2Recipes();
            Mekanism.logger.info("Hooked into IC2 successfully.");
        }
        if (this.AE2Loaded) {
            this.registerAE2Recipes();
            Mekanism.logger.info("Hooked into AE2 successfully.");
        }
        if (this.CCLoaded) {
            this.loadCCPeripheralProviders();
            Mekanism.logger.info("Hooked into Computer Craft successfully.");
        }
        if (this.CyclicLoaded) {
            this.registerCyclicRecipes();
            Mekanism.logger.info("Hooked into Cyclic successfully.");
        }
        if (this.MetallurgyLoaded) {
            this.addMetallurgy();
            Mekanism.logger.info("Hooked into Metallurgy successfully.");
        }
        if (this.MALoaded) {
            this.registerMysticalAgricultureRecipes();
        }
        if (this.CraftTweakerLoaded) {
            CrafttweakerIntegration.registerCommands();
            CrafttweakerIntegration.applyRecipeChanges();
        }
        Wrenches.initialise();
    }

    @Optional.Method(modid="ic2")
    private void hookIC2Recipes() {
        block6: for (MachineRecipe entry : Recipes.macerator.getRecipes()) {
            if (((IRecipeInput)entry.getInput()).getInputs().isEmpty() || RecipeHandler.Recipe.CRUSHER.containsRecipe((ItemStack)((IRecipeInput)entry.getInput()).getInputs().get(0))) continue;
            List<String> names = OreDictCache.getOreDictName((ItemStack)((IRecipeInput)entry.getInput()).getInputs().get(0));
            for (String name : names) {
                if (!name.startsWith("ingot") && !name.startsWith("crystal")) continue;
                RecipeHandler.addCrusherRecipe((ItemStack)((IRecipeInput)entry.getInput()).getInputs().get(0), (ItemStack)((Collection)entry.getOutput()).iterator().next());
                continue block6;
            }
        }
        try {
            Recipes.macerator.addRecipe(Recipes.inputFactory.forOreDict("oreOsmium"), null, false, new ItemStack[]{new ItemStack(MekanismItems.Dust, 2, Resource.OSMIUM.ordinal())});
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Recipes.macerator.addRecipe(Recipes.inputFactory.forOreDict("ingotOsmium"), null, false, new ItemStack[]{new ItemStack(MekanismItems.Dust, 1, Resource.OSMIUM.ordinal())});
            Recipes.macerator.addRecipe(Recipes.inputFactory.forOreDict("ingotRefinedObsidian"), null, false, new ItemStack[]{new ItemStack(MekanismItems.OtherDust, 1, 5)});
            Recipes.macerator.addRecipe(Recipes.inputFactory.forOreDict("ingotRefinedGlowstone"), null, false, new ItemStack[]{new ItemStack(Items.field_151114_aO)});
            Recipes.macerator.addRecipe(Recipes.inputFactory.forOreDict("ingotSteel"), null, false, new ItemStack[]{new ItemStack(MekanismItems.OtherDust, 1, 1)});
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            for (Resource resource : Resource.values()) {
                Recipes.macerator.addRecipe(Recipes.inputFactory.forOreDict("clump" + resource.getName()), null, false, new ItemStack[]{new ItemStack(MekanismItems.DirtyDust, 1, resource.ordinal())});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Optional.Method(modid="computercraft")
    private void loadCCPeripheralProviders() {
        try {
            ComputerCraftAPI.registerPeripheralProvider((IPeripheralProvider)new CCPeripheral.CCPeripheralProvider());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Optional.Method(modid="opencomputers")
    private void loadOCDrivers() {
        try {
            Driver.add((DriverBlock)new OCDriver());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void registerCyclicCombinerOreRecipe(String ore, int quantity, ItemStack extra, String outputName) {
        Item outputItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(CYCLIC_MOD_ID, outputName));
        if (outputItem != null) {
            for (ItemStack stack : OreDictionary.getOres((String)ore)) {
                RecipeHandler.addCombinerRecipe(StackUtils.size(stack, quantity), extra, new ItemStack(outputItem));
            }
        }
    }

    private void registerCyclicCombinerRecipe(ItemStack input, ItemStack extra, String outputName) {
        Item outputItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(CYCLIC_MOD_ID, outputName));
        if (outputItem != null) {
            RecipeHandler.addCombinerRecipe(input, extra, new ItemStack(outputItem));
        }
    }

    private void registerCyclicRecipes() {
        ItemStack netherrack = new ItemStack(Item.func_150898_a((Block)Blocks.field_150424_aL));
        this.registerCyclicCombinerRecipe(new ItemStack(Items.field_151137_ax, 3), netherrack, "nether_redstone_ore");
        this.registerCyclicCombinerOreRecipe("dustIron", 8, netherrack, "nether_iron_ore");
        this.registerCyclicCombinerOreRecipe("dustGold", 8, netherrack, "nether_gold_ore");
        this.registerCyclicCombinerRecipe(new ItemStack(Items.field_151044_h, 3), netherrack, "nether_coal_ore");
        this.registerCyclicCombinerRecipe(new ItemStack(Items.field_151100_aR, 5, 4), netherrack, "nether_lapis_ore");
        this.registerCyclicCombinerRecipe(new ItemStack(Items.field_151166_bC, 3), netherrack, "nether_emerald_ore");
        this.registerCyclicCombinerOreRecipe("dustDiamond", 3, netherrack, "nether_diamond_ore");
        ItemStack end_stone = new ItemStack(Item.func_150898_a((Block)Blocks.field_150377_bs));
        this.registerCyclicCombinerRecipe(new ItemStack(Items.field_151137_ax, 3), end_stone, "end_redstone_ore");
        this.registerCyclicCombinerRecipe(new ItemStack(Items.field_151044_h, 3), end_stone, "end_coal_ore");
        this.registerCyclicCombinerRecipe(new ItemStack(Items.field_151100_aR, 5, 4), end_stone, "end_lapis_ore");
        this.registerCyclicCombinerRecipe(new ItemStack(Items.field_151166_bC, 3), end_stone, "end_emerald_ore");
        this.registerCyclicCombinerOreRecipe("dustDiamond", 3, end_stone, "end_diamond_ore");
        this.registerCyclicCombinerOreRecipe("dustGold", 8, end_stone, "end_gold_ore");
        this.registerCyclicCombinerOreRecipe("dustIron", 8, end_stone, "end_iron_ore");
    }

    private void registerAE2P2P() {
        for (BlockStateTransmitter.TransmitterType type : BlockStateTransmitter.TransmitterType.values()) {
            if (type.getTransmission().equals((Object)TransmissionType.ITEM)) {
                FMLInterModComms.sendMessage((String)APPLIED_ENERGISTICS_2_MOD_ID, (String)"add-p2p-attunement-item", (ItemStack)new ItemStack(MekanismBlocks.Transmitter, 1, type.ordinal()));
                continue;
            }
            if (type.getTransmission().equals((Object)TransmissionType.FLUID)) {
                FMLInterModComms.sendMessage((String)APPLIED_ENERGISTICS_2_MOD_ID, (String)"add-p2p-attunement-fluid", (ItemStack)new ItemStack(MekanismBlocks.Transmitter, 1, type.ordinal()));
                continue;
            }
            if (!type.getTransmission().equals((Object)TransmissionType.ENERGY)) continue;
            FMLInterModComms.sendMessage((String)APPLIED_ENERGISTICS_2_MOD_ID, (String)"add-p2p-attunement-fe-power", (ItemStack)new ItemStack(MekanismBlocks.Transmitter, 1, type.ordinal()));
        }
    }

    private void registerAE2Recipes() {
        try {
            ItemStack crystalOut;
            IItems itemApi = AEApi.instance().definitions().items();
            IMaterials materialsApi = AEApi.instance().definitions().materials();
            IBlocks blocksApi = AEApi.instance().definitions().blocks();
            Optional certusCrystal = materialsApi.certusQuartzCrystal().maybeStack(1);
            Optional certusDust = materialsApi.certusQuartzDust().maybeStack(1);
            Optional pureCertus = materialsApi.purifiedCertusQuartzCrystal().maybeStack(1);
            Optional chargedCrystal = materialsApi.certusQuartzCrystalCharged().maybeStack(1);
            Optional fluixCrystal = materialsApi.fluixCrystal().maybeStack(1);
            Optional pureFluix = materialsApi.purifiedFluixCrystal().maybeStack(1);
            Optional fluixDust = materialsApi.fluixDust().maybeStack(1);
            Optional certusOre = blocksApi.quartzOre().maybeStack(1);
            Optional chargedOre = blocksApi.quartzOreCharged().maybeStack(1);
            Optional crystalSeed = itemApi.crystalSeed().maybeItem();
            Optional pureNether = materialsApi.purifiedNetherQuartzCrystal().maybeStack(1);
            if (certusCrystal.isPresent() && certusDust.isPresent()) {
                RecipeHandler.addCrusherRecipe(((ItemStack)certusCrystal.get()).func_77946_l(), ((ItemStack)certusDust.get()).func_77946_l());
            }
            if (chargedCrystal.isPresent() && certusDust.isPresent()) {
                RecipeHandler.addCrusherRecipe(((ItemStack)chargedCrystal.get()).func_77946_l(), ((ItemStack)certusDust.get()).func_77946_l());
            }
            if (fluixCrystal.isPresent() && fluixDust.isPresent()) {
                RecipeHandler.addCrusherRecipe(((ItemStack)fluixCrystal.get()).func_77946_l(), ((ItemStack)fluixDust.get()).func_77946_l());
            }
            if (certusOre.isPresent() && certusCrystal.isPresent()) {
                crystalOut = ((ItemStack)certusCrystal.get()).func_77946_l();
                crystalOut.func_190920_e(4);
                RecipeHandler.addEnrichmentChamberRecipe(((ItemStack)certusOre.get()).func_77946_l(), crystalOut);
            }
            if (chargedOre.isPresent() && chargedCrystal.isPresent()) {
                crystalOut = ((ItemStack)chargedCrystal.get()).func_77946_l();
                crystalOut.func_190920_e(4);
                RecipeHandler.addEnrichmentChamberRecipe(((ItemStack)chargedOre.get()).func_77946_l(), crystalOut);
            }
            if (certusDust.isPresent() && pureCertus.isPresent()) {
                crystalOut = ((ItemStack)pureCertus.get()).func_77946_l();
                RecipeHandler.addEnrichmentChamberRecipe(((ItemStack)certusDust.get()).func_77946_l(), crystalOut);
            }
            if (fluixDust.isPresent() && pureFluix.isPresent()) {
                crystalOut = ((ItemStack)pureFluix.get()).func_77946_l();
                RecipeHandler.addEnrichmentChamberRecipe(((ItemStack)fluixDust.get()).func_77946_l(), crystalOut);
            }
            if (fluixCrystal.isPresent() && pureFluix.isPresent()) {
                RecipeHandler.addEnrichmentChamberRecipe(((ItemStack)fluixCrystal.get()).func_77946_l(), ((ItemStack)pureFluix.get()).func_77946_l());
            }
            if (certusCrystal.isPresent() && pureCertus.isPresent()) {
                RecipeHandler.addEnrichmentChamberRecipe(((ItemStack)certusCrystal.get()).func_77946_l(), ((ItemStack)pureCertus.get()).func_77946_l());
            }
            if (crystalSeed.isPresent()) {
                NonNullList seeds = NonNullList.func_191196_a();
                ((Item)crystalSeed.get()).func_150895_a(CreativeTabs.field_78027_g, seeds);
                MachineInput.addCustomItemMatcher(((Item)crystalSeed.get()).getClass(), (def, test) -> def.func_77973_b() == test.func_77973_b() && def.func_77960_j() == test.func_77960_j());
                for (ItemStack stack : seeds) {
                    String unloc = ((Item)crystalSeed.get()).func_77667_c(stack);
                    if (unloc.endsWith("certus") && pureCertus.isPresent()) {
                        RecipeHandler.addEnrichmentChamberRecipe(stack, ((ItemStack)pureCertus.get()).func_77946_l());
                        continue;
                    }
                    if (unloc.endsWith("nether") && pureNether.isPresent()) {
                        RecipeHandler.addEnrichmentChamberRecipe(stack, ((ItemStack)pureNether.get()).func_77946_l());
                        continue;
                    }
                    if (!unloc.endsWith("fluix") || !pureFluix.isPresent()) continue;
                    RecipeHandler.addEnrichmentChamberRecipe(stack, ((ItemStack)pureFluix.get()).func_77946_l());
                }
            }
        }
        catch (Exception e) {
            Mekanism.logger.error("Something went wrong with ae2 integration", (Throwable)e);
        }
        catch (IncompatibleClassChangeError e) {
            Mekanism.logger.error("AE2 api has changed unexpectedly", (Throwable)e);
        }
    }

    private void addMetallurgy() {
        OreDictManager.addStandardOredictMetal("Adamantine");
        OreDictManager.addStandardOredictMetal("Alduorite");
        OreDictManager.addStandardOredictMetal("Angmallen");
        OreDictManager.addStandardOredictMetal("AstralSilver");
        OreDictManager.addStandardOredictMetal("Atlarus");
        OreDictManager.addStandardOredictMetal("Amordrine");
        OreDictManager.addStandardOredictMetal("BlackSteel");
        OreDictManager.addStandardOredictMetal("Brass");
        OreDictManager.addStandardOredictMetal("Bronze");
        OreDictManager.addStandardOredictMetal("Carmot");
        OreDictManager.addStandardOredictMetal("Celenegil");
        OreDictManager.addStandardOredictMetal("Ceruclase");
        OreDictManager.addStandardOredictMetal("DamascusSteel");
        OreDictManager.addStandardOredictMetal("DeepIron");
        OreDictManager.addStandardOredictMetal("Desichalkos");
        OreDictManager.addStandardOredictMetal("Electrum");
        OreDictManager.addStandardOredictMetal("Eximite");
        OreDictManager.addStandardOredictMetal("Haderoth");
        OreDictManager.addStandardOredictMetal("Hepatizon");
        OreDictManager.addStandardOredictMetal("Ignatius");
        OreDictManager.addStandardOredictMetal("Infuscolium");
        OreDictManager.addStandardOredictMetal("Inolashite");
        OreDictManager.addStandardOredictMetal("Kalendrite");
        OreDictManager.addStandardOredictMetal("Lemurite");
        OreDictManager.addStandardOredictMetal("Manganese");
        OreDictManager.addStandardOredictMetal("Meutoite");
        OreDictManager.addStandardOredictMetal("Midasium");
        OreDictManager.addStandardOredictMetal("Orichalcum");
        OreDictManager.addStandardOredictMetal("Oureclase");
        OreDictManager.addStandardOredictMetal("Prometheum");
        OreDictManager.addStandardOredictMetal("Quicksilver");
        OreDictManager.addStandardOredictMetal("Rubracium");
        OreDictManager.addStandardOredictMetal("Sanguinite");
        OreDictManager.addStandardOredictMetal("ShadowIron");
        OreDictManager.addStandardOredictMetal("ShadowSteel");
        OreDictManager.addStandardOredictMetal("Tartarite");
        OreDictManager.addStandardOredictMetal("Vulcanite");
        OreDictManager.addStandardOredictMetal("Vyroxeres");
        OreDictManager.addStandardOredictMetal("Zinc");
    }

    private void registerMARecipeSet(MAOre ore, MAOreType type) {
        String oreName = type.orePrefix + ore.name().toLowerCase() + "_ore";
        Item oreItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(MYSTICALAGRICULTURE_MOD_ID, oreName));
        Item dropItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(MYSTICALAGRICULTURE_MOD_ID, ore.itemName));
        if (oreItem != null && dropItem != null) {
            RecipeHandler.addEnrichmentChamberRecipe(new ItemStack(oreItem), new ItemStack(dropItem, type.quantity, ore.itemMeta));
            RecipeHandler.addCombinerRecipe(new ItemStack(dropItem, type.quantity + 2, ore.itemMeta), new ItemStack(type.baseBlock), new ItemStack(oreItem));
        }
    }

    private void registerMysticalAgricultureRecipes() {
        this.registerMARecipeSet(MAOre.INFERIUM, MAOreType.OVERWORLD);
        this.registerMARecipeSet(MAOre.INFERIUM, MAOreType.NETHER);
        this.registerMARecipeSet(MAOre.INFERIUM, MAOreType.END);
        this.registerMARecipeSet(MAOre.PROSPERITY, MAOreType.OVERWORLD);
        this.registerMARecipeSet(MAOre.PROSPERITY, MAOreType.NETHER);
        this.registerMARecipeSet(MAOre.PROSPERITY, MAOreType.END);
    }

    private static enum MAOreType {
        OVERWORLD("", Blocks.field_150347_e, 4),
        NETHER("nether_", Blocks.field_150424_aL, 6),
        END("end_", Blocks.field_150377_bs, 8);

        private final String orePrefix;
        private final Block baseBlock;
        private final int quantity;

        private MAOreType(String prefix, Block base, int quantity) {
            this.orePrefix = prefix;
            this.baseBlock = base;
            this.quantity = quantity;
        }
    }

    private static enum MAOre {
        INFERIUM("crafting", 0),
        PROSPERITY("crafting", 5);

        private final String itemName;
        private final int itemMeta;

        private MAOre(String name, int meta) {
            this.itemName = name;
            this.itemMeta = meta;
        }
    }
}

