/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.tile;

import astavie.thermallogistics.ThermalLogistics;
import astavie.thermallogistics.attachment.ICrafter;
import astavie.thermallogistics.attachment.IRequester;
import astavie.thermallogistics.attachment.IRequesterContainer;
import astavie.thermallogistics.block.BlockTerminal;
import astavie.thermallogistics.process.Process;
import astavie.thermallogistics.process.Request;
import astavie.thermallogistics.tile.InventorySpecial;
import astavie.thermallogistics.util.StackHandler;
import cofh.CoFHCore;
import cofh.core.block.TileNameable;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTileInfo;
import cofh.thermaldynamics.duct.attachments.servo.ServoFluid;
import cofh.thermaldynamics.duct.attachments.servo.ServoItem;
import cofh.thermaldynamics.duct.item.DuctUnitItem;
import cofh.thermaldynamics.duct.item.GridItem;
import cofh.thermaldynamics.duct.tiles.DuctToken;
import cofh.thermaldynamics.duct.tiles.DuctUnit;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.multiblock.Route;
import cofh.thermaldynamics.util.ListWrapper;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Triple;

public abstract class TileTerminal<I>
extends TileNameable
implements ITickable,
IRequesterContainer {
    public final InventorySpecial requester = new InventorySpecial(1, i -> i.func_77973_b() == ThermalLogistics.Items.requester, null);
    public final List<Triple<I, Long, Boolean>> terminal = NonNullList.func_191196_a();
    protected final Requester[] processes = new Requester[6];
    private final Set<Container> registry = new HashSet<Container>();
    public boolean refresh = false;

    public TileTerminal() {
        for (byte i2 = 0; i2 < 6; i2 = (byte)(i2 + 1)) {
            this.processes[i2] = new Requester(this, i2);
        }
    }

    public PacketTileInfo getSyncPacket() {
        this.updateTerminal();
        PacketTileInfo packet = PacketTileInfo.newPacket((TileEntity)this);
        packet.addInt(this.terminal.size());
        for (Triple<I, Long, Boolean> stack : this.terminal) {
            StackHandler.writePacket((PacketBase)packet, stack.getLeft(), this.getItemClass(), true);
            packet.addLong(((Long)stack.getMiddle()).longValue());
            packet.addBool(((Boolean)stack.getRight()).booleanValue());
        }
        this.sync((PacketBase)packet);
        return packet;
    }

    protected abstract void sync(PacketBase var1);

    protected abstract void read(PacketBase var1);

    protected abstract void read(PacketBase var1, byte var2, EntityPlayer var3);

    public void handleTileInfoPacket(PacketBase payload, boolean isServer, EntityPlayer player) {
        if (isServer) {
            byte message = payload.getByte();
            if (message == 0) {
                this.request(payload);
                for (Requester requester : this.processes) {
                    requester.process.offset = this.field_145850_b.func_82737_E() + 1L;
                }
                this.markChunkDirty();
                PacketHandler.sendToAllAround((PacketBase)this.getSyncPacket(), (TileEntity)this);
            } else {
                this.read(payload, message, player);
            }
        } else {
            this.terminal.clear();
            int size = payload.getInt();
            for (int i = 0; i < size; ++i) {
                this.terminal.add(Triple.of(StackHandler.readPacket(payload), (Object)payload.getLong(), (Object)payload.getBool()));
            }
            this.refresh = true;
            this.read(payload);
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            list.func_74742_a((NBTBase)this.processes[i].process.writeNbt());
        }
        nbt.func_74782_a("requester", (NBTBase)this.requester.get().func_77955_b(new NBTTagCompound()));
        nbt.func_74782_a("processes", (NBTBase)list);
        return nbt;
    }

    public abstract String getTileName();

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.requester.set(new ItemStack(nbt.func_74775_l("requester")));
        NBTTagList list = nbt.func_150295_c("processes", 9);
        for (int i = 0; i < list.func_74745_c(); i = (int)((byte)(i + 1))) {
            this.processes[i].process.readNbt((NBTTagList)list.func_179238_g(i));
        }
    }

    public void register(Container container) {
        if (!this.field_145850_b.field_72995_K && !this.func_145837_r()) {
            this.registry.add(container);
            this.setActive(true);
        }
    }

    public void remove(Container container) {
        if (!this.field_145850_b.field_72995_K && !this.func_145837_r()) {
            this.registry.remove(container);
            if (this.registry.isEmpty()) {
                this.setActive(false);
            }
        }
    }

    private void setActive(boolean active) {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if ((Boolean)state.func_177229_b((IProperty)BlockTerminal.ACTIVE) != active) {
            this.field_145850_b.func_180501_a(this.field_174879_c, state.func_177226_a((IProperty)BlockTerminal.ACTIVE, (Comparable)Boolean.valueOf(active)), 2);
        }
    }

    protected Object getMod() {
        return CoFHCore.instance;
    }

    protected String getModVersion() {
        return ThermalLogistics.MOD_VERSION;
    }

    public boolean hasGui() {
        return true;
    }

    public abstract Object getGuiClient(InventoryPlayer var1);

    public abstract Object getGuiServer(InventoryPlayer var1);

    public boolean openGui(EntityPlayer player) {
        if (this.hasGui()) {
            PacketHandler.sendTo((PacketBase)this.getSyncPacket(), (EntityPlayer)player);
            player.openGui(this.getMod(), 0, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        }
        return this.hasGui();
    }

    public void func_73660_a() {
        boolean b = this.requester.get().func_190926_b();
        for (Requester requester : this.processes) {
            if (!b && requester.getDuct() != null) {
                requester.process.tick();
                continue;
            }
            requester.process.requests.clear();
        }
    }

    protected abstract DuctToken<?, ?, ?> getDuctToken();

    protected abstract Process<I> createProcess(Requester<I> var1);

    protected abstract int amountRequired(I var1);

    protected abstract void request(PacketBase var1);

    protected abstract void updateTerminal();

    public abstract Class<I> getItemClass();

    @Override
    public IRequester<?> getRequester(int index) {
        return this.processes[index];
    }

    protected static class Requester<I>
    implements IRequester<I> {
        private final TileTerminal<I> terminal;
        private final byte side;
        protected final Process<I> process;

        private Requester(TileTerminal<I> terminal, byte side) {
            this.terminal = terminal;
            this.side = side;
            this.process = terminal.createProcess(this);
        }

        @Override
        public List<I> getInputFrom(IRequester<I> requester) {
            return this.process.getStacks(requester);
        }

        @Override
        public List<I> getOutputTo(IRequester<I> requester) {
            return Collections.emptyList();
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public int amountRequired(I stack) {
            return this.terminal.amountRequired(stack);
        }

        @Override
        public DuctUnit getDuct() {
            DuctUnit duct;
            TileEntity tile = ((TileTerminal)this.terminal).field_145850_b.func_175625_s(((TileTerminal)this.terminal).field_174879_c.func_177972_a(EnumFacing.func_82600_a((int)this.side)));
            if (tile instanceof TileGrid && (duct = ((TileGrid)tile).getDuct(this.terminal.getDuctToken())) != null && duct.isOutput((int)((byte)(this.side ^ 1)))) {
                return duct;
            }
            return null;
        }

        @Override
        public TileEntity getTile() {
            return this.terminal;
        }

        @Override
        public byte getSide() {
            return (byte)(this.side ^ 1);
        }

        @Override
        public TileEntity getCachedTile() {
            return this.terminal;
        }

        @Override
        public ItemStack getIcon() {
            return new ItemStack(this.terminal.func_145838_q());
        }

        @Override
        public ItemStack getTileIcon() {
            return new ItemStack(this.terminal.func_145838_q());
        }

        @Override
        public void markDirty() {
            this.terminal.markChunkDirty();
        }

        @Override
        public int tickDelay() {
            return ServoItem.tickDelays[this.terminal.requester.get().func_77960_j()];
        }

        @Override
        public void claim(ICrafter<I> crafter, I stack) {
            Iterator iterator = this.process.requests.iterator();
            while (iterator.hasNext()) {
                Request<I> request = iterator.next();
                if (!request.attachment.references(crafter)) continue;
                request.decreaseStack(stack);
                if (request.stacks.isEmpty()) {
                    iterator.remove();
                }
                return;
            }
        }

        @Override
        public int getMaxSend() {
            return ServoItem.maxSize[this.terminal.requester.get().func_77960_j()];
        }

        @Override
        public byte getSpeed() {
            return ServoItem.speedBoost[this.terminal.requester.get().func_77960_j()];
        }

        @Override
        public ListWrapper<Route<DuctUnitItem, GridItem>> getRoutes() {
            ListWrapper routesWithInsertSideList = new ListWrapper();
            DuctUnit duct = this.getDuct();
            if (!(duct instanceof DuctUnitItem) || duct.getGrid() == null) {
                routesWithInsertSideList.setList(new LinkedList(), ListWrapper.SortType.NORMAL);
                return routesWithInsertSideList;
            }
            Stream routesWithDestinations = ServoItem.getRoutesWithDestinations((Collection)((DuctUnitItem)duct).getCache().outputRoutes);
            LinkedList objects = Lists.newLinkedList();
            routesWithDestinations.forEach(objects::add);
            routesWithInsertSideList.setList(objects, ListWrapper.SortType.NORMAL);
            return routesWithInsertSideList;
        }

        @Override
        public boolean hasMultiStack() {
            return ServoItem.multiStack[this.terminal.requester.get().func_77960_j()];
        }

        @Override
        public IItemHandler getCachedInv() {
            return (IItemHandler)this.terminal.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.func_82600_a((int)this.side));
        }

        @Override
        public float getThrottle() {
            return ServoFluid.throttle[this.terminal.requester.get().func_77960_j()];
        }

        @Override
        public int getIndex() {
            return this.side;
        }

        @Override
        public void onFinishCrafting(IRequester<I> requester, I stack) {
        }

        @Override
        public void onFinishCrafting(int index, int recipes) {
        }
    }
}

