/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.process;

import astavie.thermallogistics.attachment.IRequester;
import astavie.thermallogistics.process.Request;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;

public abstract class Process<I> {
    public long offset = 0L;
    public final IRequester<I> requester;
    public final List<Request<I>> requests = NonNullList.func_191196_a();

    public Process(IRequester<I> requester) {
        this.requester = requester;
    }

    public static <I> List<I> getStacks(List<Request<I>> requests, IRequester<I> requester) {
        for (Request<I> request : requests) {
            if (!request.attachment.references(requester)) continue;
            return request.stacks;
        }
        return Collections.emptyList();
    }

    public abstract NBTTagList writeNbt();

    public abstract void readNbt(NBTTagList var1);

    public List<I> getStacks(IRequester<I> requester) {
        return Process.getStacks(this.requests, requester);
    }

    public List<I> getStacks() {
        NonNullList stacks = NonNullList.func_191196_a();
        for (Request<I> request : this.requests) {
            stacks.addAll(request.stacks);
        }
        return stacks;
    }

    public int getCount(I stack) {
        int count = 0;
        for (Request<I> request : this.requests) {
            count += request.getCount(stack);
        }
        return count;
    }

    public abstract void tick();
}

