/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.item;

import astavie.thermallogistics.attachment.RequesterFluid;
import astavie.thermallogistics.attachment.RequesterItem;
import astavie.thermallogistics.item.ItemAttachmentLogistics;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.attachments.servo.ServoBase;
import cofh.thermaldynamics.duct.attachments.servo.ServoFluid;
import cofh.thermaldynamics.duct.attachments.servo.ServoItem;
import cofh.thermaldynamics.duct.tiles.DuctToken;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.item.ItemRetriever;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class ItemRequester
extends ItemAttachmentLogistics {
    public ItemRequester(String name) {
        super(name);
    }

    public Attachment getAttachment(EnumFacing side, ItemStack stack, TileGrid tile) {
        int type = stack.func_77952_i();
        if (tile.getDuct(DuctToken.FLUID) != null) {
            return new RequesterFluid(tile, (byte)(side.ordinal() ^ 1), type);
        }
        if (tile.getDuct(DuctToken.ITEMS) != null) {
            return new RequesterItem(tile, (byte)(side.ordinal() ^ 1), type);
        }
        return null;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        int type = stack.func_77960_j();
        if (!StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.getInfoText((String)"item.logistics.requester.info"));
            if (StringHelper.displayShiftForDetail) {
                tooltip.add(StringHelper.shiftForDetails());
            }
            return;
        }
        if (ServoBase.canAlterRS((int)type)) {
            tooltip.add(StringHelper.localize((String)"info.thermaldynamics.servo.redstoneInt"));
        } else {
            tooltip.add(StringHelper.localize((String)"info.thermaldynamics.servo.redstoneExt"));
        }
        tooltip.add("\u00a7e" + StringHelper.localize((String)"info.cofh.items") + "\u00a7r");
        tooltip.add("  " + StringHelper.localize((String)"info.thermaldynamics.servo.extractRate") + ": " + "\u00a7f" + (ServoItem.tickDelays[type] % 20 == 0 ? Integer.toString(ServoItem.tickDelays[type] / 20) : Float.toString((float)ServoItem.tickDelays[type] / 20.0f)) + "s" + "\u00a7r");
        tooltip.add("  " + StringHelper.localize((String)"info.thermaldynamics.servo.maxStackSize") + ": " + "\u00a7f" + ServoItem.maxSize[type] + "\u00a7r");
        ItemRetriever.addFiltering(tooltip, (int)type, (Duct.Type)Duct.Type.ITEM);
        if (ServoItem.multiStack[type]) {
            tooltip.add("  " + StringHelper.localize((String)"info.thermaldynamics.servo.slotMulti"));
        } else {
            tooltip.add("  " + StringHelper.localize((String)"info.thermaldynamics.servo.slotSingle"));
        }
        if (ServoItem.speedBoost[type] != 1) {
            tooltip.add("  " + StringHelper.localize((String)"info.thermaldynamics.servo.speedBoost") + ": " + "\u00a7f" + ServoItem.speedBoost[type] + "x " + "\u00a7r");
        }
        tooltip.add("\u00a7e" + StringHelper.localize((String)"info.cofh.fluids") + "\u00a7r");
        tooltip.add("  " + StringHelper.localize((String)"info.thermaldynamics.servo.extractRate") + ": " + "\u00a7f" + (int)(ServoFluid.throttle[type] * 100.0f) + "%" + "\u00a7r");
        ItemRetriever.addFiltering(tooltip, (int)type, (Duct.Type)Duct.Type.FLUID);
    }

    public boolean initialize() {
        ItemStack requesterBasic = new ItemStack((Item)this, 1, 0);
        ItemStack requesterHardened = new ItemStack((Item)this, 1, 1);
        ItemStack requesterReinforced = new ItemStack((Item)this, 1, 2);
        ItemStack requesterSignalum = new ItemStack((Item)this, 1, 3);
        ItemStack requesterResonant = new ItemStack((Item)this, 1, 4);
        RecipeHelper.addShapedRecipe((ItemStack)requesterBasic, (Object[])new Object[]{"iCi", "IRI", Character.valueOf('i'), "nuggetIron", Character.valueOf('R'), ItemRetriever.retrieverBasic, Character.valueOf('I'), "ingotIron", Character.valueOf('C'), Items.field_151132_bS});
        RecipeHelper.addShapedRecipe((ItemStack)requesterHardened, (Object[])new Object[]{"iCi", "IRI", Character.valueOf('i'), "nuggetIron", Character.valueOf('R'), ItemRetriever.retrieverHardened, Character.valueOf('I'), "ingotInvar", Character.valueOf('C'), Items.field_151132_bS});
        RecipeHelper.addShapelessRecipe((ItemStack)requesterHardened, (Object[])new Object[]{requesterBasic, "ingotInvar"});
        RecipeHelper.addShapedRecipe((ItemStack)requesterReinforced, (Object[])new Object[]{"iCi", "IRI", Character.valueOf('i'), "nuggetIron", Character.valueOf('R'), ItemRetriever.retrieverReinforced, Character.valueOf('I'), "ingotElectrum", Character.valueOf('C'), Items.field_151132_bS});
        RecipeHelper.addShapelessRecipe((ItemStack)requesterReinforced, (Object[])new Object[]{requesterBasic, "ingotElectrum"});
        RecipeHelper.addShapelessRecipe((ItemStack)requesterReinforced, (Object[])new Object[]{requesterHardened, "ingotElectrum"});
        RecipeHelper.addShapedRecipe((ItemStack)requesterSignalum, (Object[])new Object[]{"iCi", "IRI", Character.valueOf('i'), "nuggetIron", Character.valueOf('R'), ItemRetriever.retrieverSignalum, Character.valueOf('I'), "ingotSignalum", Character.valueOf('C'), Items.field_151132_bS});
        RecipeHelper.addShapelessRecipe((ItemStack)requesterSignalum, (Object[])new Object[]{requesterBasic, "ingotSignalum"});
        RecipeHelper.addShapelessRecipe((ItemStack)requesterSignalum, (Object[])new Object[]{requesterHardened, "ingotSignalum"});
        RecipeHelper.addShapelessRecipe((ItemStack)requesterSignalum, (Object[])new Object[]{requesterReinforced, "ingotSignalum"});
        RecipeHelper.addShapedRecipe((ItemStack)requesterResonant, (Object[])new Object[]{"iCi", "IRI", Character.valueOf('i'), "nuggetIron", Character.valueOf('R'), ItemRetriever.retrieverResonant, Character.valueOf('I'), "ingotEnderium", Character.valueOf('C'), Items.field_151132_bS});
        RecipeHelper.addShapelessRecipe((ItemStack)requesterResonant, (Object[])new Object[]{requesterBasic, "ingotEnderium"});
        RecipeHelper.addShapelessRecipe((ItemStack)requesterResonant, (Object[])new Object[]{requesterHardened, "ingotEnderium"});
        RecipeHelper.addShapelessRecipe((ItemStack)requesterResonant, (Object[])new Object[]{requesterReinforced, "ingotEnderium"});
        RecipeHelper.addShapelessRecipe((ItemStack)requesterResonant, (Object[])new Object[]{requesterSignalum, "ingotEnderium"});
        return true;
    }
}

