/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.item;

import astavie.thermallogistics.attachment.CrafterFluid;
import astavie.thermallogistics.attachment.CrafterItem;
import astavie.thermallogistics.item.ItemAttachmentLogistics;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.attachments.filter.FilterLogic;
import cofh.thermaldynamics.duct.attachments.servo.ServoBase;
import cofh.thermaldynamics.duct.attachments.servo.ServoFluid;
import cofh.thermaldynamics.duct.attachments.servo.ServoItem;
import cofh.thermaldynamics.duct.tiles.DuctToken;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.item.ItemRetriever;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class ItemCrafter
extends ItemAttachmentLogistics {
    public ItemCrafter(String name) {
        super(name);
    }

    private static void addFiltering(List<String> list, int type, Duct.Type duct) {
        StringBuilder b = new StringBuilder();
        b.append(StringHelper.localize((String)"info.thermaldynamics.filter.options")).append(": ").append("\u00a7f");
        boolean flag = false;
        for (int i = 1; i < FilterLogic.flagTypes.length; ++i) {
            if (!FilterLogic.canAlterFlag((Duct.Type)duct, (int)type, (int)i)) continue;
            if (flag) {
                b.append(", ");
            } else {
                flag = true;
            }
            b.append(StringHelper.localize((String)("info.thermaldynamics.filter." + FilterLogic.flagTypes[i])));
        }
        flag = false;
        for (String s : Minecraft.func_71410_x().field_71466_p.func_78271_c(b.toString(), 140)) {
            if (flag) {
                s = "  \u00a7f" + s;
            }
            flag = true;
            list.add("  " + s + "\u00a7r");
        }
    }

    public Attachment getAttachment(EnumFacing side, ItemStack stack, TileGrid tile) {
        int type = stack.func_77952_i();
        if (tile.getDuct(DuctToken.FLUID) != null) {
            return new CrafterFluid(tile, (byte)(side.ordinal() ^ 1), type);
        }
        if (tile.getDuct(DuctToken.ITEMS) != null) {
            return new CrafterItem(tile, (byte)(side.ordinal() ^ 1), type);
        }
        return null;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        int type = stack.func_77960_j();
        if (!StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.getInfoText((String)"item.logistics.crafter.info"));
            if (StringHelper.displayShiftForDetail) {
                tooltip.add(StringHelper.shiftForDetails());
            }
            return;
        }
        if (ServoBase.canAlterRS((int)type)) {
            tooltip.add(StringHelper.localize((String)"info.thermaldynamics.servo.redstoneInt"));
        } else {
            tooltip.add(StringHelper.localize((String)"info.thermaldynamics.servo.redstoneExt"));
        }
        tooltip.add("\u00a7e" + StringHelper.localize((String)"info.cofh.items") + "\u00a7r");
        tooltip.add("  " + StringHelper.localizeFormat((String)"info.logistics.inputs", (Object[])new Object[]{CrafterItem.SIZE[type] * 2}));
        tooltip.add("  " + StringHelper.localizeFormat((String)"info.logistics.outputs", (Object[])new Object[]{CrafterItem.SIZE[type]}));
        tooltip.add("  " + StringHelper.localize((String)"info.thermaldynamics.servo.extractRate") + ": " + "\u00a7f" + (ServoItem.tickDelays[type] % 20 == 0 ? Integer.toString(ServoItem.tickDelays[type] / 20) : Float.toString((float)ServoItem.tickDelays[type] / 20.0f)) + "s" + "\u00a7r");
        tooltip.add("  " + StringHelper.localize((String)"info.thermaldynamics.servo.maxStackSize") + ": " + "\u00a7f" + ServoItem.maxSize[type] + "\u00a7r");
        ItemCrafter.addFiltering(tooltip, type, Duct.Type.ITEM);
        if (ServoItem.multiStack[type]) {
            tooltip.add("  " + StringHelper.localize((String)"info.thermaldynamics.servo.slotMulti"));
        } else {
            tooltip.add("  " + StringHelper.localize((String)"info.thermaldynamics.servo.slotSingle"));
        }
        if (ServoItem.speedBoost[type] != 1) {
            tooltip.add("  " + StringHelper.localize((String)"info.thermaldynamics.servo.speedBoost") + ": " + "\u00a7f" + ServoItem.speedBoost[type] + "x " + "\u00a7r");
        }
        tooltip.add("\u00a7e" + StringHelper.localize((String)"info.cofh.fluids") + "\u00a7r");
        tooltip.add("  " + StringHelper.localizeFormat((String)"info.logistics.inputs", (Object[])new Object[]{CrafterFluid.SIZE[type] * 2}));
        tooltip.add("  " + StringHelper.localizeFormat((String)"info.logistics.outputs", (Object[])new Object[]{CrafterFluid.SIZE[type]}));
        tooltip.add("  " + StringHelper.localize((String)"info.thermaldynamics.servo.extractRate") + ": " + "\u00a7f" + (int)(ServoFluid.throttle[type] * 100.0f) + "%" + "\u00a7r");
        ItemCrafter.addFiltering(tooltip, type, Duct.Type.FLUID);
    }

    public boolean initialize() {
        ItemStack crafterBasic = new ItemStack((Item)this, 1, 0);
        ItemStack crafterHardened = new ItemStack((Item)this, 1, 1);
        ItemStack crafterReinforced = new ItemStack((Item)this, 1, 2);
        ItemStack crafterSignalum = new ItemStack((Item)this, 1, 3);
        ItemStack crafterResonant = new ItemStack((Item)this, 1, 4);
        RecipeHelper.addShapedRecipe((ItemStack)crafterBasic, (Object[])new Object[]{"iCi", "IRI", Character.valueOf('i'), "nuggetIron", Character.valueOf('R'), ItemRetriever.retrieverBasic, Character.valueOf('I'), "ingotIron", Character.valueOf('C'), "workbench"});
        RecipeHelper.addShapedRecipe((ItemStack)crafterHardened, (Object[])new Object[]{"iCi", "IRI", Character.valueOf('i'), "nuggetIron", Character.valueOf('R'), ItemRetriever.retrieverHardened, Character.valueOf('I'), "ingotInvar", Character.valueOf('C'), "workbench"});
        RecipeHelper.addShapelessRecipe((ItemStack)crafterHardened, (Object[])new Object[]{crafterBasic, "ingotInvar"});
        RecipeHelper.addShapedRecipe((ItemStack)crafterReinforced, (Object[])new Object[]{"iCi", "IRI", Character.valueOf('i'), "nuggetIron", Character.valueOf('R'), ItemRetriever.retrieverReinforced, Character.valueOf('I'), "ingotElectrum", Character.valueOf('C'), "workbench"});
        RecipeHelper.addShapelessRecipe((ItemStack)crafterReinforced, (Object[])new Object[]{crafterBasic, "ingotElectrum"});
        RecipeHelper.addShapelessRecipe((ItemStack)crafterReinforced, (Object[])new Object[]{crafterHardened, "ingotElectrum"});
        RecipeHelper.addShapedRecipe((ItemStack)crafterSignalum, (Object[])new Object[]{"iCi", "IRI", Character.valueOf('i'), "nuggetIron", Character.valueOf('R'), ItemRetriever.retrieverSignalum, Character.valueOf('I'), "ingotSignalum", Character.valueOf('C'), "workbench"});
        RecipeHelper.addShapelessRecipe((ItemStack)crafterSignalum, (Object[])new Object[]{crafterBasic, "ingotSignalum"});
        RecipeHelper.addShapelessRecipe((ItemStack)crafterSignalum, (Object[])new Object[]{crafterHardened, "ingotSignalum"});
        RecipeHelper.addShapelessRecipe((ItemStack)crafterSignalum, (Object[])new Object[]{crafterReinforced, "ingotSignalum"});
        RecipeHelper.addShapedRecipe((ItemStack)crafterResonant, (Object[])new Object[]{"iCi", "IRI", Character.valueOf('i'), "nuggetIron", Character.valueOf('R'), ItemRetriever.retrieverResonant, Character.valueOf('I'), "ingotEnderium", Character.valueOf('C'), "workbench"});
        RecipeHelper.addShapelessRecipe((ItemStack)crafterResonant, (Object[])new Object[]{crafterBasic, "ingotEnderium"});
        RecipeHelper.addShapelessRecipe((ItemStack)crafterResonant, (Object[])new Object[]{crafterHardened, "ingotEnderium"});
        RecipeHelper.addShapelessRecipe((ItemStack)crafterResonant, (Object[])new Object[]{crafterReinforced, "ingotEnderium"});
        RecipeHelper.addShapelessRecipe((ItemStack)crafterResonant, (Object[])new Object[]{crafterSignalum, "ingotEnderium"});
        return true;
    }
}

