/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.compat.jei;

import astavie.thermallogistics.attachment.CrafterFluid;
import astavie.thermallogistics.attachment.CrafterItem;
import astavie.thermallogistics.attachment.ICrafter;
import astavie.thermallogistics.client.gui.GuiCrafter;
import astavie.thermallogistics.client.gui.element.ElementSlot;
import astavie.thermallogistics.client.gui.tab.TabFluid;
import astavie.thermallogistics.container.ContainerCrafter;
import astavie.thermallogistics.process.RequestFluid;
import astavie.thermallogistics.process.RequestItem;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTileInfo;
import java.awt.Rectangle;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.gui.IGhostIngredientHandler;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class CrafterHandler
implements IRecipeTransferHandler<ContainerCrafter>,
IAdvancedGuiHandler<GuiCrafter>,
IGhostIngredientHandler<GuiCrafter> {
    @Nonnull
    public Class<ContainerCrafter> getContainerClass() {
        return ContainerCrafter.class;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(@Nonnull ContainerCrafter container, @Nonnull IRecipeLayout recipeLayout, @Nonnull EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
        if (doTransfer) {
            if (container.crafter.getItemClass() == ItemStack.class) {
                this.transferItems(container.crafter, recipeLayout);
            } else if (container.crafter.getItemClass() == FluidStack.class) {
                this.transferFluids(container.crafter, recipeLayout);
            }
        }
        return null;
    }

    private void transferItems(ICrafter<ItemStack> crafter, IRecipeLayout recipeLayout) {
        ItemStack stack;
        int i;
        int index;
        ICrafter.Recipe<ItemStack> recipe = null;
        for (index = 0; index < crafter.getRecipes().size(); ++index) {
            recipe = crafter.getRecipes().get(index);
            if (!recipe.inputs.stream().allMatch(ItemStack::func_190926_b) || !recipe.outputs.stream().allMatch(ItemStack::func_190926_b)) continue;
            ++index;
            break;
        }
        --index;
        RequestItem inputs = new RequestItem(null);
        RequestItem outputs = new RequestItem(null);
        Map guiIngredients = recipeLayout.getItemStacks().getGuiIngredients();
        for (Map.Entry entry : guiIngredients.entrySet()) {
            List ingredients = ((IGuiIngredient)entry.getValue()).getAllIngredients();
            if (ingredients.isEmpty()) continue;
            if (((IGuiIngredient)entry.getValue()).isInput()) {
                inputs.addStack((ItemStack)ingredients.get(0));
                continue;
            }
            outputs.addStack((ItemStack)ingredients.get(0));
        }
        PacketTileInfo packet = crafter.getNewPacket((byte)0);
        packet.addByte(4);
        packet.addInt(index);
        for (i = 0; i < recipe.inputs.size(); ++i) {
            stack = i >= inputs.stacks.size() ? ItemStack.field_190927_a : (ItemStack)inputs.stacks.get(i);
            recipe.inputs.set(i, stack);
            packet.addItemStack(stack);
        }
        for (i = 0; i < recipe.outputs.size(); ++i) {
            stack = i >= outputs.stacks.size() ? ItemStack.field_190927_a : (ItemStack)outputs.stacks.get(i);
            recipe.outputs.set(i, stack);
            packet.addItemStack(stack);
        }
        PacketHandler.sendToServer((PacketBase)packet);
    }

    private void transferFluids(ICrafter<FluidStack> crafter, IRecipeLayout recipeLayout) {
        FluidStack stack;
        int i;
        int index;
        ICrafter.Recipe<FluidStack> recipe = null;
        for (index = 0; index < crafter.getRecipes().size(); ++index) {
            recipe = crafter.getRecipes().get(index);
            if (!recipe.inputs.stream().allMatch(Objects::isNull) || !recipe.outputs.stream().allMatch(Objects::isNull)) continue;
            ++index;
            break;
        }
        --index;
        RequestFluid inputs = new RequestFluid(null);
        RequestFluid outputs = new RequestFluid(null);
        Map guiIngredients = recipeLayout.getFluidStacks().getGuiIngredients();
        for (Map.Entry entry : guiIngredients.entrySet()) {
            List ingredients = ((IGuiIngredient)entry.getValue()).getAllIngredients();
            if (ingredients.isEmpty()) continue;
            if (((IGuiIngredient)entry.getValue()).isInput()) {
                inputs.addStack((FluidStack)ingredients.get(0));
                continue;
            }
            outputs.addStack((FluidStack)ingredients.get(0));
        }
        PacketTileInfo packet = crafter.getNewPacket((byte)0);
        packet.addByte(4);
        packet.addInt(index);
        for (i = 0; i < recipe.inputs.size(); ++i) {
            stack = i >= inputs.stacks.size() ? null : (FluidStack)inputs.stacks.get(i);
            recipe.inputs.set(i, stack);
            packet.addFluidStack(stack);
        }
        for (i = 0; i < recipe.outputs.size(); ++i) {
            stack = i >= outputs.stacks.size() ? null : (FluidStack)outputs.stacks.get(i);
            recipe.outputs.set(i, stack);
            packet.addFluidStack(stack);
        }
        PacketHandler.sendToServer((PacketBase)packet);
    }

    @Nonnull
    public <I> List<IGhostIngredientHandler.Target<I>> getTargets(@Nonnull GuiCrafter gui, @Nonnull I ingredient, boolean doStart) {
        LinkedList<IGhostIngredientHandler.Target<I>> list = new LinkedList<IGhostIngredientHandler.Target<I>>();
        if (ingredient instanceof ItemStack && gui.crafter instanceof CrafterItem || ingredient instanceof FluidStack && gui.crafter instanceof CrafterFluid) {
            for (ElementSlot slot : gui.slots) {
                list.add(new ElementSlotTarget(slot));
            }
        }
        if (ingredient instanceof FluidStack && gui.tab != null && gui.tab.isFullyOpened()) {
            list.add(new TabFluidTarget(gui.tab));
        }
        return list;
    }

    public void onComplete() {
    }

    @Nonnull
    public Class<GuiCrafter> getGuiContainerClass() {
        return GuiCrafter.class;
    }

    @Nullable
    public Object getIngredientUnderMouse(GuiCrafter gui, int mouseX, int mouseY) {
        mouseX -= gui.getGuiLeft();
        mouseY -= gui.getGuiTop();
        for (ElementSlot slot : gui.slots) {
            if (!slot.intersectsWith(mouseX, mouseY)) continue;
            return slot.getIngredient();
        }
        if (gui.tab != null && gui.tab.slot.intersectsWith(mouseX - gui.tab.posX(), mouseY - gui.tab.getPosY())) {
            return gui.tab.slot.getIngredient();
        }
        return null;
    }

    private static class ElementSlotTarget<I>
    implements IGhostIngredientHandler.Target<I> {
        private final ElementSlot<I> slot;

        private ElementSlotTarget(ElementSlot<I> slot) {
            this.slot = slot;
        }

        @Nonnull
        public Rectangle getArea() {
            return this.slot.getArea();
        }

        public void accept(@Nonnull I ingredient) {
            this.slot.accept(ingredient);
        }
    }

    private static class TabFluidTarget
    implements IGhostIngredientHandler.Target<FluidStack> {
        private final TabFluid tab;

        private TabFluidTarget(TabFluid tab) {
            this.tab = tab;
        }

        @Nonnull
        public Rectangle getArea() {
            return new Rectangle(this.tab.getContainerScreen().getGuiLeft() + this.tab.posX() + this.tab.slot.getPosX() + 1, this.tab.getContainerScreen().getGuiTop() + this.tab.getPosY() + this.tab.slot.getPosY() + 1, 16, 16);
        }

        public void accept(@Nonnull FluidStack ingredient) {
            this.tab.slot.accept(ingredient);
        }
    }
}

