/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.attachment;

import astavie.thermallogistics.ThermalLogistics;
import astavie.thermallogistics.attachment.ICrafter;
import astavie.thermallogistics.attachment.IRequester;
import astavie.thermallogistics.client.TLTextures;
import astavie.thermallogistics.process.ProcessItem;
import astavie.thermallogistics.process.Request;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermaldynamics.duct.attachments.retriever.RetrieverItem;
import cofh.thermaldynamics.duct.item.DuctUnitItem;
import cofh.thermaldynamics.duct.item.GridItem;
import cofh.thermaldynamics.duct.item.StackMap;
import cofh.thermaldynamics.duct.tiles.DuctUnit;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.multiblock.Route;
import cofh.thermaldynamics.render.RenderDuct;
import cofh.thermaldynamics.util.ListWrapper;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.items.IItemHandler;

public class RequesterItem
extends RetrieverItem
implements IRequester<ItemStack> {
    public static final ResourceLocation ID = new ResourceLocation("thermallogistics", "requester_item");
    private final ProcessItem process = new ProcessItem(this);

    public RequesterItem(TileGrid tile, byte side) {
        super(tile, side);
    }

    public RequesterItem(TileGrid tile, byte side, int type) {
        super(tile, side, type);
        this.filter.handleFlagByte(24);
    }

    public String getInfo() {
        return "tab.thermallogistics.requesterItem";
    }

    public ResourceLocation getId() {
        return ID;
    }

    public ItemStack getPickBlock() {
        return new ItemStack((Item)ThermalLogistics.Items.requester, 1, this.type);
    }

    public String getName() {
        return this.getPickBlock().func_77977_a() + ".name";
    }

    public boolean render(IBlockAccess world, BlockRenderLayer layer, CCRenderState ccRenderState) {
        if (layer != BlockRenderLayer.SOLID) {
            return false;
        }
        Translation trans = Vector3.fromTileCenter((TileEntity)this.baseTile).translation();
        RenderDuct.modelConnection[this.isPowered ? 1 : 2][this.side].render(ccRenderState, new IVertexOperation[]{trans, new IconTransformation(TLTextures.REQUESTER[this.stuffed ? 1 : 0][this.type])});
        return true;
    }

    public void handleItemSending() {
        this.process.tick();
    }

    @Override
    public void claim(ICrafter<ItemStack> crafter, ItemStack stack) {
        Iterator iterator = this.process.requests.iterator();
        while (iterator.hasNext()) {
            Request request = (Request)iterator.next();
            if (!request.attachment.references(crafter)) continue;
            request.decreaseStack(stack);
            if (request.stacks.isEmpty()) {
                iterator.remove();
            }
            return;
        }
    }

    public void onNeighborChange() {
        boolean wasPowered = this.isPowered;
        super.onNeighborChange();
        if (wasPowered && !this.isPowered) {
            this.process.requests.clear();
        }
    }

    public void checkSignal() {
        boolean wasPowered = this.isPowered;
        super.checkSignal();
        if (wasPowered && !this.isPowered) {
            this.process.requests.clear();
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74782_a("process", (NBTBase)this.process.writeNbt());
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.process.readNbt(tag.func_150295_c("process", 10));
    }

    public void writePortableData(EntityPlayer player, NBTTagCompound tag) {
        super.writePortableData(player, tag);
        tag.func_74778_a("DisplayType", new ItemStack((Item)ThermalLogistics.Items.requester).func_77977_a() + ".name");
    }

    @Override
    public List<ItemStack> getInputFrom(IRequester<ItemStack> requester) {
        return this.process.getStacks(requester);
    }

    @Override
    public List<ItemStack> getOutputTo(IRequester<ItemStack> requester) {
        return Collections.emptyList();
    }

    @Override
    public boolean isEnabled() {
        return this.isPowered;
    }

    @Override
    public int amountRequired(ItemStack stack) {
        if (!this.filter.matchesFilter(stack)) {
            return 0;
        }
        int required = this.filter.getMaxStock();
        IItemHandler inv = this.getCachedInv();
        if (inv == null) {
            return 0;
        }
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (!ItemHelper.itemsIdentical((ItemStack)inv.getStackInSlot(i), (ItemStack)stack)) continue;
            required -= inv.getStackInSlot(i).func_190916_E();
        }
        for (ItemStack item : this.process.getStacks()) {
            if (!ItemHelper.itemsIdentical((ItemStack)item, (ItemStack)stack)) continue;
            required -= item.func_190916_E();
        }
        StackMap map = (StackMap)((GridItem)this.itemDuct.getGrid()).travelingItems.get(this.itemDuct.pos().func_177972_a(EnumFacing.func_82600_a((int)this.side)));
        if (map != null) {
            for (ItemStack item : map.getItems()) {
                if (!ItemHelper.itemsIdentical((ItemStack)item, (ItemStack)stack)) continue;
                required -= item.func_190916_E();
            }
        }
        return required < 0 ? 0 : required;
    }

    @Override
    public int getIndex() {
        return 0;
    }

    @Override
    public float getThrottle() {
        return 0.0f;
    }

    @Override
    public DuctUnit getDuct() {
        return this.itemDuct;
    }

    @Override
    public TileEntity getTile() {
        return this.baseTile;
    }

    @Override
    public byte getSide() {
        return this.side;
    }

    @Override
    public ListWrapper<Route<DuctUnitItem, GridItem>> getRoutes() {
        return this.routesWithInsertSideList;
    }

    @Override
    public boolean hasMultiStack() {
        return multiStack[this.type];
    }

    @Override
    public TileEntity getCachedTile() {
        return this.myTile;
    }

    @Override
    public ItemStack getIcon() {
        return this.getPickBlock();
    }

    @Override
    public void onFinishCrafting(IRequester<ItemStack> requester, ItemStack stack) {
    }

    @Override
    public void onFinishCrafting(int index, int recipes) {
    }

    @Override
    public void markDirty() {
        this.baseTile.markChunkDirty();
    }
}

