/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import fi.dy.masa.enderutilities.config.Configs;
import fi.dy.masa.enderutilities.gui.client.GuiMSU;
import fi.dy.masa.enderutilities.inventory.ItemStackHandlerLockable;
import fi.dy.masa.enderutilities.inventory.container.ContainerMSU;
import fi.dy.masa.enderutilities.inventory.wrapper.ItemHandlerWrapperCreative;
import fi.dy.masa.enderutilities.item.part.ItemEnderPart;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilitiesInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;

public class TileEntityMSU
extends TileEntityEnderUtilitiesInventory {
    public static final int GUI_ACTION_TOGGLE_CREATIVE = 1;
    private ItemStackHandlerLockable itemHandlerLockable;
    private int tier;

    public TileEntityMSU() {
        super("msu", true);
        this.initStorage();
    }

    private int getInvSize() {
        return this.tier == 1 ? 9 : 1;
    }

    private void initStorage() {
        this.itemHandlerLockable = new ItemStackHandlerLockable(0, this.getInvSize(), Configs.msuMaxItems, true, "Items", this);
        this.itemHandlerBase = this.itemHandlerLockable;
        this.itemHandlerExternal = new ItemHandlerWrapperCreative(this.itemHandlerLockable, this);
    }

    public ItemStackHandlerLockable getInventoryMSU() {
        return this.itemHandlerLockable;
    }

    public void setStorageTier(int tier) {
        this.tier = MathHelper.func_76125_a((int)tier, (int)0, (int)1);
        this.initStorage();
    }

    public int getStorageTier() {
        return this.tier;
    }

    @Override
    public boolean onRightClickBlock(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && ItemEnderPart.itemMatches(stack, ItemEnderPart.ItemPartType.CREATIVE_STORAGE_KEY)) {
            this.setCreative(!this.isCreative());
            this.func_70296_d();
            this.notifyBlockUpdate(this.func_174877_v());
            this.func_145831_w().func_184133_a(null, this.func_174877_v(), SoundEvents.field_187629_cO, SoundCategory.BLOCKS, 0.7f, 1.0f);
            return true;
        }
        return super.onRightClickBlock(player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public void readFromNBTCustom(NBTTagCompound nbt) {
        this.tier = MathHelper.func_76125_a((int)nbt.func_74771_c("Tier"), (int)0, (int)1);
        this.setCreative(nbt.func_74767_n("Creative"));
        super.readFromNBTCustom(nbt);
    }

    @Override
    protected void readItemsFromNBT(NBTTagCompound nbt) {
        this.initStorage();
        super.readItemsFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74774_a("Tier", (byte)this.tier);
        nbt.func_74757_a("Creative", this.isCreative());
        super.func_189515_b(nbt);
        return nbt;
    }

    @Override
    public NBTTagCompound getUpdatePacketTag(NBTTagCompound nbt) {
        nbt = super.getUpdatePacketTag(nbt);
        nbt.func_74774_a("tier", (byte)this.tier);
        nbt.func_74757_a("cr", this.isCreative());
        return nbt;
    }

    @Override
    public void handleUpdateTag(NBTTagCompound tag) {
        this.tier = tag.func_74771_c("tier");
        this.setCreative(tag.func_74767_n("cr"));
        this.initStorage();
        super.handleUpdateTag(tag);
    }

    @Override
    public void performGuiAction(EntityPlayer player, int action, int element) {
        if (action == 1 && player.field_71075_bZ.field_75098_d) {
            this.setCreative(!this.isCreative());
            this.func_70296_d();
            this.notifyBlockUpdate(this.func_174877_v());
        }
    }

    @Override
    public ContainerMSU getContainer(EntityPlayer player) {
        return new ContainerMSU(player, this);
    }

    @Override
    public Object getGui(EntityPlayer player) {
        return new GuiMSU(this.getContainer(player), this);
    }
}

