/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import com.google.common.base.Predicates;
import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.block.base.BlockEnderUtilities;
import fi.dy.masa.enderutilities.inventory.container.base.ContainerEnderUtilities;
import fi.dy.masa.enderutilities.network.PacketHandler;
import fi.dy.masa.enderutilities.util.BlockUtils;
import fi.dy.masa.enderutilities.util.nbt.OwnerData;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityEnderUtilities
extends TileEntity {
    public static final int DATA_VERSION = 6600;
    protected String tileEntityName;
    protected EnumFacing facing = BlockEnderUtilities.DEFAULT_FACING;
    protected OwnerData ownerData;
    protected IBlockState camoState;
    protected IBlockState camoStateExtended;
    protected NBTTagCompound camoData;

    public TileEntityEnderUtilities(String name) {
        this.tileEntityName = name;
    }

    public String getTEName() {
        return this.tileEntityName;
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing;
        this.func_70296_d();
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            this.notifyBlockUpdate(this.func_174877_v());
        }
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public void func_189668_a(Mirror mirrorIn) {
        this.func_189667_a(mirrorIn.func_185800_a(this.facing));
    }

    public void func_189667_a(Rotation rotationIn) {
        this.setFacing(rotationIn.func_185831_a(this.getFacing()));
    }

    public IBlockState getCamoState() {
        return this.camoState != null ? this.camoState : Blocks.field_150350_a.func_176223_P();
    }

    public IBlockState getCamoExtendedState() {
        return this.camoStateExtended != null ? this.camoStateExtended : this.getCamoState();
    }

    public void setOwner(Entity entity) {
        this.ownerData = entity != null ? new OwnerData(entity) : null;
    }

    public void setIsPublic(boolean isPublic) {
        if (this.ownerData == null) {
            this.ownerData = new OwnerData("", isPublic);
        } else {
            this.ownerData.setIsPublic(isPublic);
        }
    }

    public void setPlacementProperties(World world, BlockPos pos, @Nonnull ItemStack stack, @Nonnull NBTTagCompound tag) {
    }

    public String getOwnerName() {
        return this.ownerData != null ? this.ownerData.getOwnerName() : "";
    }

    @Nullable
    public UUID getOwnerUUID() {
        return this.ownerData != null ? this.ownerData.getOwnerUUID() : null;
    }

    public boolean isPublic() {
        return this.ownerData == null || this.ownerData.getIsPublic();
    }

    public boolean isOwner(EntityPlayer player) {
        return this.ownerData != null && this.ownerData.isOwner((Entity)player);
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.ownerData == null || this.ownerData.canAccess((Entity)player);
    }

    public boolean isMovableBy(EntityPlayer player) {
        return this.isPublic() || this.isOwner(player);
    }

    public boolean onRightClickBlock(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return this.tryApplyCamouflage(player, hand, side, hitX, hitY, hitZ);
    }

    public boolean onInputAction(int keyMask, EntityPlayer player, RayTraceResult trace, World world, BlockPos pos) {
        return false;
    }

    protected boolean tryApplyCamouflage(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.hasCamouflageAbility() && player.func_184614_ca().func_190926_b()) {
            if (player.func_70093_af() && this.camoState != null) {
                this.removeCamouflage();
                return true;
            }
            ItemStack stackOffHand = player.func_184592_cb();
            if (!stackOffHand.func_190926_b() && stackOffHand.func_77973_b() instanceof ItemBlock) {
                return this.applyCamouflage(player, stackOffHand, side, hitX, hitY, hitZ);
            }
        }
        return false;
    }

    private void removeCamouflage() {
        if (!this.func_145831_w().field_72995_K && this.camoState != null) {
            this.camoState = null;
            this.func_145831_w().func_184133_a(null, this.func_174877_v(), SoundEvents.field_187629_cO, SoundCategory.BLOCKS, 1.0f, 1.0f);
            this.notifyBlockUpdate(this.func_174877_v());
            this.func_145831_w().func_180500_c(EnumSkyBlock.BLOCK, this.func_174877_v());
            this.func_70296_d();
        }
    }

    private boolean applyCamouflage(EntityPlayer player, ItemStack stackOffhand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (stackOffhand.func_77973_b() instanceof ItemBlock && ((ItemBlock)stackOffhand.func_77973_b()).func_179223_d() != null) {
            int meta;
            World world = this.func_145831_w();
            BlockPos posSelf = this.func_174877_v();
            Block block = ((ItemBlock)stackOffhand.func_77973_b()).func_179223_d();
            IBlockState state = block.getStateForPlacement(world, posSelf, side, hitX, hitY, hitZ, meta = stackOffhand.func_77973_b().func_77647_b(stackOffhand.func_77960_j()), (EntityLivingBase)player, EnumHand.OFF_HAND);
            if (state != this.camoState) {
                if (!this.func_145831_w().field_72995_K) {
                    this.camoState = state;
                    this.func_145831_w().func_184133_a(null, this.func_174877_v(), SoundEvents.field_187620_cL, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    this.notifyBlockUpdate(this.func_174877_v());
                    this.func_145831_w().func_180500_c(EnumSkyBlock.BLOCK, this.func_174877_v());
                    this.func_70296_d();
                }
                return true;
            }
        }
        return false;
    }

    public void onLeftClickBlock(EntityPlayer player) {
    }

    public void onNeighborBlockChange(World worldIn, BlockPos pos, IBlockState state, Block blockIn) {
    }

    public void onScheduledBlockUpdate(World worldIn, BlockPos pos, IBlockState state, Random rand) {
    }

    public void scheduleBlockUpdate(int delay, boolean force) {
        World world = this.func_145831_w();
        if (world != null && (force || !world.func_184145_b(this.func_174877_v(), this.func_145838_q()))) {
            world.func_175684_a(this.func_174877_v(), this.func_145838_q(), delay);
        }
    }

    protected void notifyBlockUpdate(BlockPos pos) {
        IBlockState state = this.func_145831_w().func_180495_p(pos);
        this.func_145831_w().func_184138_a(pos, state, state, 3);
    }

    public boolean isPowered() {
        return false;
    }

    public void readFromNBTCustom(NBTTagCompound nbt) {
        if (nbt.func_150297_b("Rotation", 1)) {
            this.facing = EnumFacing.func_82600_a((int)nbt.func_74771_c("Rotation"));
        }
        if (nbt.func_150297_b("Camo", 3)) {
            this.camoState = Block.func_176220_d((int)nbt.func_74762_e("Camo"));
        }
        if (nbt.func_150297_b("CamoData", 10)) {
            this.camoData = nbt.func_74775_l("CamoData");
        }
        this.ownerData = OwnerData.getOwnerDataFromNBT(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readFromNBTCustom(nbt);
    }

    protected NBTTagCompound writeToNBTCustom(NBTTagCompound nbt) {
        nbt.func_74778_a("Version", "0.7.12");
        nbt.func_74774_a("Rotation", (byte)this.facing.func_176745_a());
        if (this.camoState != null) {
            nbt.func_74768_a("Camo", Block.func_176210_f((IBlockState)this.camoState));
            if (this.camoData != null) {
                nbt.func_74782_a("CamoData", (NBTBase)this.camoData);
            }
        }
        if (this.ownerData != null) {
            this.ownerData.writeToNBT(nbt);
        }
        return nbt;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        this.writeToNBTCustom(nbt);
        return nbt;
    }

    public NBTTagCompound getUpdatePacketTag(NBTTagCompound nbt) {
        nbt.func_74774_a("r", (byte)(this.facing.func_176745_a() & 7));
        if (this.camoState != null) {
            nbt.func_74768_a("Camo", Block.func_176210_f((IBlockState)this.camoState));
            if (this.camoData != null) {
                nbt.func_74782_a("CD", (NBTBase)this.camoData);
            }
        }
        if (this.ownerData != null) {
            nbt.func_74778_a("o", this.ownerData.getOwnerName());
            nbt.func_74757_a("pu", this.ownerData.getIsPublic());
        }
        return nbt;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("x", this.func_174877_v().func_177958_n());
        nbt.func_74768_a("y", this.func_174877_v().func_177956_o());
        nbt.func_74768_a("z", this.func_174877_v().func_177952_p());
        return this.getUpdatePacketTag(nbt);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        if (this.func_145831_w() != null) {
            return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.getUpdatePacketTag(new NBTTagCompound()));
        }
        return null;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        if (tag.func_74764_b("r")) {
            this.setFacing(EnumFacing.func_82600_a((int)((byte)(tag.func_74771_c("r") & 7))));
        }
        if (tag.func_150297_b("o", 8)) {
            this.ownerData = new OwnerData(tag.func_74779_i("o"), tag.func_74767_n("pu"));
        }
        if (tag.func_150297_b("Camo", 3)) {
            this.camoState = Block.func_176220_d((int)tag.func_74762_e("Camo"));
            World world = this.func_145831_w();
            BlockPos pos = this.func_174877_v();
            IBlockState stateSelf = world.func_180495_p(pos);
            if (this.camoState != null && this.camoState.func_177230_c() != Blocks.field_150350_a) {
                try {
                    BlockUtils.setBlockToAirWithoutSpillingContents(world, pos, 16);
                    if (world.func_180501_a(pos, this.camoState, 16)) {
                        if (tag.func_150297_b("CD", 10)) {
                            this.camoData = tag.func_74775_l("CD");
                            TileEntity te = world.func_175625_s(pos);
                            if (te != null) {
                                te.handleUpdateTag(this.camoData);
                            }
                        }
                        this.camoState = this.camoState.func_185899_b((IBlockAccess)world, pos);
                        this.camoStateExtended = this.camoState.func_177230_c().getExtendedState(this.camoState, (IBlockAccess)world, pos);
                        BlockUtils.setBlockToAirWithoutSpillingContents(world, pos, 16);
                        world.func_180501_a(pos, stateSelf, 16);
                        this.func_145829_t();
                        world.func_175690_a(pos, (TileEntity)this);
                    }
                }
                catch (Exception e) {
                    EnderUtilities.logger.warn("Exception while trying to grab the Extended state for a camo block: {}", (Object)this.camoState, (Object)e);
                }
            }
        } else {
            this.camoState = null;
            this.camoStateExtended = null;
        }
        this.func_145831_w().func_180500_c(EnumSkyBlock.BLOCK, this.func_174877_v());
        this.notifyBlockUpdate(this.func_174877_v());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.handleUpdateTag(packet.func_148857_g());
    }

    public void performGuiAction(EntityPlayer player, int action, int element) {
    }

    protected void sendPacketToWatchers(IMessage message) {
        World world = this.func_145831_w();
        if (world instanceof WorldServer) {
            WorldServer worldServer = (WorldServer)world;
            int chunkX = this.func_174877_v().func_177958_n() >> 4;
            int chunkZ = this.func_174877_v().func_177952_p() >> 4;
            PlayerChunkMap map = worldServer.func_184164_w();
            for (EntityPlayerMP player : worldServer.func_175661_b(EntityPlayerMP.class, Predicates.alwaysTrue())) {
                if (!map.func_72694_a(player, chunkX, chunkZ)) continue;
                PacketHandler.INSTANCE.sendTo(message, player);
            }
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(" + this.func_174877_v() + ")@" + System.identityHashCode((Object)this);
    }

    public boolean hasGui() {
        return true;
    }

    protected boolean hasCamouflageAbility() {
        return false;
    }

    public ContainerEnderUtilities getContainer(EntityPlayer player) {
        return null;
    }

    public Object getGui(EntityPlayer player) {
        return null;
    }
}

