/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.config;

import fi.dy.masa.enderutilities.config.Configs;
import fi.dy.masa.enderutilities.registry.BlackLists;
import fi.dy.masa.enderutilities.util.WorldUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigReader {
    private static final int CURRENT_CONFIG_VERSION = 6600;
    public static final String CATEGORY_BUILDERSWAND = "BuildersWand";
    public static final String CATEGORY_CLIENT = "Client";
    public static final String CATEGORY_GENERIC = "Generic";
    public static final String CATEGORY_LISTS = "Lists";
    private static File configurationFile;
    private static Configuration config;
    private static String currentCategory;
    private static boolean currentRequiresMcRestart;
    private static final Set<String> VALID_CATEGORIES;
    private static final Set<String> VALID_CONFIGS;

    public static void loadConfigsFromFile(File configFile) {
        configurationFile = configFile;
        config = new Configuration(configurationFile, null, true);
        config.load();
        ConfigReader.reLoadAllConfigs(false);
    }

    public static Configuration loadConfigsFromFile() {
        return config;
    }

    public static void reLoadAllConfigs(boolean reloadFromFile) {
        if (reloadFromFile) {
            config.load();
        }
        ConfigReader.loadConfigGeneric(config);
        ConfigReader.loadConfigItemControl(config);
        ConfigReader.loadConfigLists(config);
        ConfigReader.removeInvalidConfigs(config);
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static File getConfigFile() {
        return configurationFile;
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if ("enderutilities".equals(event.getModID())) {
            ConfigReader.reLoadAllConfigs(false);
        }
    }

    private static void loadConfigGeneric(Configuration conf) {
        currentCategory = CATEGORY_GENERIC;
        currentRequiresMcRestart = false;
        Property prop = ConfigReader.getProp("barrelCapacityUpgradeStacksPer", 256);
        prop.setComment("How many stacks of storage each Barrel Capacity Upgrade adds");
        Configs.barrelCapacityUpgradeStacksPer = prop.getInt();
        prop = ConfigReader.getProp("barrelMaxCapacityUpgrades", 64);
        prop.setComment("How many Barrel Capacity Upgrades can be applied to one barrel");
        Configs.barrelMaxCapacityUpgrades = prop.getInt();
        prop = ConfigReader.getProp("barrelRenderFullnessBar", true);
        prop.setComment("Whether or not to render the \"fullness bar\" on Barrels");
        Configs.barrelRenderFullnessBar = prop.getBoolean();
        prop = ConfigReader.getProp("enderBowAllowPlayers", true);
        prop.setComment("Is the Ender Bow allowed to teleport players (directly or in a 'stack' riding something)");
        Configs.enderBowAllowPlayers = prop.getBoolean();
        prop = ConfigReader.getProp("enderBowAllowSelfTP", true);
        prop.setComment("Can the Ender Bow be used in the 'TP Self' mode");
        Configs.enderBowAllowSelfTP = prop.getBoolean();
        prop = ConfigReader.getProp("enderBucketCapacity", 16000);
        prop.setComment("Maximum amount the Ender Bucket can hold, in millibuckets. Default: 16000 mB (= 16 buckets).");
        Configs.enderBucketCapacity = prop.getInt();
        prop = ConfigReader.getProp("enderLassoAllowPlayers", true);
        prop.setComment("Is the Ender Lasso allowed to teleport players (directly or in a 'stack' riding something)");
        Configs.enderLassoAllowPlayers = prop.getBoolean();
        prop = ConfigReader.getProp("fallingBlockDropsAsItemOnPlacementFail", false);
        prop.setComment("If true, then the block will drop as item when failing to place (like vanilla falling blocks).\nIf false, then it will stay in entity form until it's able to place itself.");
        Configs.fallingBlockDropsAsItemOnPlacementFail = prop.getBoolean();
        prop = ConfigReader.getProp("handyBagEnableItemUpdate", false);
        prop.setComment("Master config to enable calling the stored items' update method in the Handy Bag.\nWARNING: Due to how complex the bag's inventory stuff is (due to the bag storing Memory Cards,\nwhich then store the items), using this functionality\nmight cause lots of NBT data changes in the bag and also considerable network bandwidth usage\nwhen updating the bag's NBT to the clients. So USE WITH CAUTION!");
        Configs.handyBagEnableItemUpdate = prop.getBoolean();
        prop = ConfigReader.getProp(currentCategory, "harvestLevelEnderAlloyAdvanced", 3, false);
        prop.setComment("The harvest level of tools made from Advanced Ender Alloy (3 = vanilla diamond tool level).");
        Configs.harvestLevelEnderAlloyAdvanced = prop.getInt();
        prop = ConfigReader.getProp("msuMaxItems", 1000000000);
        prop.setComment("The maximum amount of items (per slot) the MSU and MSB can store. Max is 2147483647");
        Configs.msuMaxItems = prop.getInt();
        prop = ConfigReader.getProp("portalAreaCheckLimit", 10000);
        prop.setComment("How many blocks to check at most when checking that one portal area is valid");
        Configs.portalAreaCheckLimit = prop.getInt();
        prop = ConfigReader.getProp("portalFrameCheckLimit", 2000);
        prop.setComment("How many Portal Frame blocks to check at most");
        Configs.portalFrameCheckLimit = prop.getInt();
        prop = ConfigReader.getProp("portalLoopCheckLimit", 2000);
        prop.setComment("How many blocks to check at most when checking portal enclosing loops");
        Configs.portalLoopCheckLimit = prop.getInt();
        prop = ConfigReader.getProp("portalOnlyAllowsPortalTypeLinkCrystals", false);
        prop.setComment("If true, then the Portal Panel only accepts Portal type Link Crystals.\nThis allows forcing the Portals to be used in pairs (or rather, that there\nmust always also be _some_ Portal in the destination location.)");
        Configs.portalOnlyAllowsPortalTypeLinkCrystals = prop.getBoolean();
        prop = ConfigReader.getProp("replaceEntityItemCollisionBoxHandling", false);
        prop.setComment("If enabled, then a custom event replaces fetching the block collision boxes for\nEntityItems and EntityXPOrbs when they are being pushed out of blocks.\nWithout this, the Cracked Floor are really derpy and shoot the items and XP\neverywhere while they try to fall through the block.\nNOTE: This doesn't currently work in 1.11.2+ due to vanilla/Forge changes");
        Configs.replaceEntityItemCollisionBoxHandling = prop.getBoolean();
        prop = ConfigReader.getProp("useEnderCharge", true);
        prop.setComment("Do items require Ender Charge to operate? (stored in Ender Capacitors)");
        Configs.useEnderCharge = prop.getBoolean();
        currentCategory = CATEGORY_BUILDERSWAND;
        conf.addCustomCategoryComment(currentCategory, "Configs for the Wand of the Lazy Builder");
        prop = ConfigReader.getProp("buildersWandBlocksPerTick", 10);
        prop.setComment("The number of blocks the Lazy Builder's Wand will place each game tick\nin the \"build modes\". Default: 10 (= 200 blocks per second)");
        Configs.buildersWandBlocksPerTick = prop.getInt();
        prop = ConfigReader.getProp("buildersWandEnableCopyMode", true);
        prop.setComment("Enables the Copy mode functionality in survival mode");
        Configs.buildersWandEnableCopyMode = prop.getBoolean();
        prop = ConfigReader.getProp("buildersWandEnableMoveMode", true);
        prop.setComment("Enables the Move mode functionality in survival mode");
        Configs.buildersWandEnableMoveMode = prop.getBoolean();
        prop = ConfigReader.getProp("buildersWandEnablePasteMode", true);
        prop.setComment("Enables the Paste mode functionality in survival mode");
        Configs.buildersWandEnablePasteMode = prop.getBoolean();
        prop = ConfigReader.getProp("buildersWandEnableReplaceMode", true);
        prop.setComment("Enables the Replace mode functionality in survival mode");
        Configs.buildersWandEnableReplaceMode = prop.getBoolean();
        prop = ConfigReader.getProp("buildersWandEnableReplace3DMode", true);
        prop.setComment("Enables the Replace 3D mode functionality in survival mode");
        Configs.buildersWandEnableReplace3DMode = prop.getBoolean();
        prop = ConfigReader.getProp("buildersWandEnableStackMode", true);
        prop.setComment("Enables the \"Stack Area\" mode functionality in survival mode");
        Configs.buildersWandEnableStackMode = prop.getBoolean();
        prop = ConfigReader.getProp("buildersWandGhostBlockAlpha", 0.7);
        prop.setComment("The alpha value to use for the translucent ghost block rendering mode");
        Configs.buildersWandGhostBlockAlpha = (float)MathHelper.func_151237_a((double)prop.getDouble(), (double)0.0, (double)1.0);
        prop = ConfigReader.getProp("buildersWandMaxBlockHardness", 60.0);
        prop.setComment("The maximum block hardness of the blocks the wand can break/move in survival mode");
        Configs.buildersWandMaxBlockHardness = (float)prop.getDouble();
        prop = ConfigReader.getProp("buildersWandReplaceBlocksPerTick", 2);
        prop.setComment("The number of blocks to replace per game tick in the Replace mode, default: 2 (= 40 blocks per second)");
        Configs.buildersWandReplaceBlocksPerTick = prop.getInt();
        prop = ConfigReader.getProp("buildersWandUseTranslucentGhostBlocks", true);
        prop.setComment("Use translucent ghost block rendering instead of opaque");
        Configs.buildersWandUseTranslucentGhostBlocks = prop.getBoolean();
        currentCategory = CATEGORY_CLIENT;
        conf.addCustomCategoryComment(currentCategory, "Client side configs");
        prop = ConfigReader.getProp("announceLocationBindingInChat", false);
        prop.setComment("Prints a chat message when items are bound to a new location");
        Configs.announceLocationBindingInChat = prop.getBoolean();
        prop = ConfigReader.getProp("buildersWandAndRulerRenderForOtherPlayers", true);
        prop.setComment("Render the Ruler and Builder's Wand areas/selections also for the items held by other players");
        Configs.buildersWandRenderForOtherPlayers = prop.getBoolean();
        prop = ConfigReader.getProp("handyBagOpenRequiresSneak", false);
        prop.setComment("Reverse the sneak behaviour on opening the Handy Bag instead of the regular inventory");
        Configs.handyBagOpenRequiresSneak = prop.getBoolean();
        prop = ConfigReader.getProp("useToolParticles", true);
        prop.setComment("Does the block drops teleporting by Ender tools cause particle effects");
        Configs.useToolParticles = prop.getBoolean();
        prop = ConfigReader.getProp("useToolSounds", true);
        prop.setComment("Does the block drops teleporting by Ender tools play the sound effect");
        Configs.useToolSounds = prop.getBoolean();
        prop = ConfigReader.getProp("Version", "configFileVersion", 6600, true);
        prop.setComment("Internal config file version tracking. DO NOT CHANGE!!");
        prop.setValue(6600);
    }

    private static void loadConfigItemControl(Configuration conf) {
        currentCategory = "DisableBlocks";
        currentRequiresMcRestart = true;
        conf.addCustomCategoryComment(currentCategory, "Completely disable blocks (don't register them to the game.)\nNote that machines are grouped together and identified by the meta value. You can't disable just a specific meta value.");
        Configs.disableBlockASU = ConfigReader.getProp("disableBlockAdjustableStorageUnit", false).getBoolean();
        Configs.disableBlockBarrel = ConfigReader.getProp("disableBlockBarrel", false).getBoolean();
        Configs.disableBlockDrawbridge = ConfigReader.getProp("disableBlockDrawbridge", false).getBoolean();
        Configs.disableBlockEnderElevator = ConfigReader.getProp("disableBlockEnderElevator", false).getBoolean();
        Configs.disableBlockFloor = ConfigReader.getProp("disableBlockFloor", false).getBoolean();
        Configs.disableBlockInserter = ConfigReader.getProp("disableBlockInserter", false).getBoolean();
        Configs.disableBlockMolecularExciter = ConfigReader.getProp("disableBlockMolecularExciter", false).getBoolean();
        Configs.disableBlockPhasing = ConfigReader.getProp("disableBlockPhasing", false).getBoolean();
        Configs.disableBlockPortal = ConfigReader.getProp("disableBlockPortal", false).getBoolean();
        Configs.disableBlockPortalFrame = ConfigReader.getProp("disableBlockPortalFrame", false).getBoolean();
        Configs.disableBlockPortalPanel = ConfigReader.getProp("disableBlockPortalPanel", false).getBoolean();
        Configs.disableBlockSoundBlock = ConfigReader.getProp("disableBlockSoundBlock", false).getBoolean();
        Property prop = ConfigReader.getProp("disableBlockEnergyBridge", false);
        prop.setComment("Meta values: 0 = Energy Bridge Resonator; 1 = Energy Bridge Receiver; 2 = Energy Bridge Transmitter");
        Configs.disableBlockEnergyBridge = prop.getBoolean();
        prop = ConfigReader.getProp("disableBlockMachine_0", false);
        prop.setComment("Info: Machine_0 meta values: 0 = Ender Furnace");
        Configs.disableBlockMachine_0 = prop.getBoolean();
        prop = ConfigReader.getProp("disableBlockMachine_1", false);
        prop.setComment("Info: Machine_1 meta values: 0 = Ender Infuser; 1 = Tool Workstation, 2 = Creation Station");
        Configs.disableBlockMachine_1 = prop.getBoolean();
        prop = ConfigReader.getProp("disableBlockStorage_0", false);
        prop.setComment("Meta values: 0..2 = Memory Chests, 3..6 = Handy Chests, 7 = Junk Storage Unit");
        Configs.disableBlockStorage_0 = prop.getBoolean();
        prop = ConfigReader.getProp("disableBlockMassiveStorageUnit", false);
        prop.setComment("Meta values: 0 = Massive Storage Unit, 1 = Massive Storage Bundle");
        Configs.disableBlockMSU = prop.getBoolean();
        currentCategory = "DisableItems";
        conf.addCustomCategoryComment(currentCategory, "Completely disable items (don't register them to the game.)\nNote that some items are grouped together using the damage value (and/or NBT data) to identify them.\nYou can't disable a specific damage value only (so that existing items would vanish).");
        Configs.disableItemCraftingPart = ConfigReader.getProp("disableItemCraftingPart", false).getBoolean();
        Configs.disableItemEnderCapacitor = ConfigReader.getProp("disableItemEnderCapacitor", false).getBoolean();
        Configs.disableItemLinkCrystal = ConfigReader.getProp("disableItemLinkCrystal", false).getBoolean();
        Configs.disableItemBuildersWand = ConfigReader.getProp("disableItemBuildersWand", false).getBoolean();
        Configs.disableItemEnderArrow = ConfigReader.getProp("disableItemEnderArrow", false).getBoolean();
        Configs.disableItemEnderBag = ConfigReader.getProp("disableItemEnderBag", false).getBoolean();
        Configs.disableItemEnderBow = ConfigReader.getProp("disableItemEnderBow", false).getBoolean();
        Configs.disableItemEnderBucket = ConfigReader.getProp("disableItemEnderBucket", false).getBoolean();
        Configs.disableItemEnderLasso = ConfigReader.getProp("disableItemEnderLasso", false).getBoolean();
        Configs.disableItemEnderPearl = ConfigReader.getProp("disableItemEnderPearl", false).getBoolean();
        Configs.disableItemEnderPorter = ConfigReader.getProp("disableItemEnderPorter", false).getBoolean();
        Configs.disableItemEnderSword = ConfigReader.getProp("disableItemEnderSword", false).getBoolean();
        Configs.disableItemEnderTools = ConfigReader.getProp("disableItemEnderTools", false).getBoolean();
        Configs.disableItemHandyBag = ConfigReader.getProp("disableItemHandyBag", false).getBoolean();
        Configs.disableItemIceMelter = ConfigReader.getProp("disableItemIceMelter", false).getBoolean();
        Configs.disableItemInventorySwapper = ConfigReader.getProp("disableItemInventorySwapper", false).getBoolean();
        Configs.disableItemLivingManipulator = ConfigReader.getProp("disableItemLivingManipulator", false).getBoolean();
        Configs.disableItemMobHarness = ConfigReader.getProp("disableItemMobHarness", false).getBoolean();
        Configs.disableItemNullifier = ConfigReader.getProp("disableItemNullifier", false).getBoolean();
        Configs.disableItemPetContract = ConfigReader.getProp("disableItemPetContract", false).getBoolean();
        Configs.disableItemPickupManager = ConfigReader.getProp("disableItemPickupManager", false).getBoolean();
        Configs.disableItemQuickStacker = ConfigReader.getProp("disableItemQuickStacker", false).getBoolean();
        Configs.disableItemPortalScaler = ConfigReader.getProp("disableItemPortalScaler", false).getBoolean();
        Configs.disableItemRuler = ConfigReader.getProp("disableItemRuler", false).getBoolean();
        Configs.disableItemSyringe = ConfigReader.getProp("disableItemSyringe", false).getBoolean();
        Configs.disableItemVoidPickaxe = ConfigReader.getProp("disableItemVoidPickaxe", false).getBoolean();
        currentCategory = "DisableRecipes";
        conf.addCustomCategoryComment(currentCategory, "Disable item recipes");
        Configs.disableRecipeEnderElevator = ConfigReader.getProp("disableRecipeEnderElevator", false).getBoolean();
    }

    private static void loadConfigLists(Configuration conf) {
        currentRequiresMcRestart = false;
        currentCategory = CATEGORY_LISTS;
        Property prop = ConfigReader.getProp("energyBridgeBedrockWhitelist", new String[]{"minecraft:bedrock"});
        prop.setComment("A list of blockstates that are valid for the Energy Bridge's Bedrock requirement.\nUse a blockstate string, for example: 'minecraft:gold_block' or 'minecraft:stone[variant=andesite]'.\nA block name without properties will match all states, for example: 'minecraft:stone'\nwould match smooth stone and all the granite/andesite/diorite variants that are in the same block.");
        Configs.energyBridgeBedrockWhitelist = prop.getStringList();
        prop = ConfigReader.getProp("endDimensions", new String[0]);
        prop.setComment("A list of dimension IDs that should be considered End dimensions, although they may otherwise not seem like it.\nThis is mainly used for the Energy Bridges, to allow the Transmitters to work in custom End dimensions.");
        Configs.endDimensions = prop.getStringList();
        prop = ConfigReader.getProp("enderBagListType", "whitelist");
        prop.setComment("Target control list type used for Ender Bag. Allowed values: blacklist, whitelist.");
        Configs.enderBagListTypeIsWhitelist = prop.getString().equalsIgnoreCase("whitelist");
        prop = ConfigReader.getProp("enderBagBlackList", new String[0]);
        prop.setComment("Block types the Ender Bag is NOT allowed to (= doesn't properly) work with.");
        Configs.enderBagBlacklist = prop.getStringList();
        prop = ConfigReader.getProp("enderBagWhiteList", new String[]{"minecraft:chest", "minecraft:dispenser", "minecraft:dropper", "minecraft:ender_chest", "minecraft:furnace", "minecraft:hopper", "minecraft:trapped_chest"});
        prop.setComment("Block types the Ender Bag is allowed to (= should properly) work with. **NOTE** Only some vanilla blocks work properly atm!!");
        Configs.enderBagWhitelist = prop.getStringList();
        prop = ConfigReader.getProp("livingMatterManipulatorListType", "blacklist");
        prop.setComment("The list type used for the Living Matter Manipulator. Allowed values: blacklist, whitelist.");
        Configs.lmmListIsWhitelist = prop.getString().equalsIgnoreCase("whitelist");
        prop = ConfigReader.getProp("livingMatterManipulatorBlackList", new String[]{"minecraft:ender_dragon", "minecraft:wither"});
        prop.setComment("List of entity names the LMM is not allowed to store, if 'livingMatterManipulatorListType' is 'blacklist'.");
        Configs.lmmBlacklist = prop.getStringList();
        prop = ConfigReader.getProp("livingMatterManipulatorWhiteList", new String[0]);
        prop.setComment("List of entity names the LMM is only allowed to store, if 'livingMatterManipulatorListType' is 'whitelist'.");
        Configs.lmmWhitelist = prop.getStringList();
        prop = ConfigReader.getProp("teleportBlackList", new String[]{"minecraft:ender_dragon", "minecraft:ender_crystal", "minecraft:wither"});
        prop.setComment("Entities that are not allowed to be teleported using any methods");
        Configs.teleportBlacklist = prop.getStringList();
        BlackLists.registerEnergyBridgeBedrockWhitelist(Configs.energyBridgeBedrockWhitelist);
        BlackLists.registerEnderBagLists(Configs.enderBagBlacklist, Configs.enderBagWhitelist);
        BlackLists.registerTeleportBlacklist(Configs.teleportBlacklist);
        WorldUtils.setCustomEndDimensions(Configs.endDimensions);
    }

    private static Property getProp(String key, boolean defaultValue) {
        return ConfigReader.getProp(currentCategory, key, defaultValue, currentRequiresMcRestart);
    }

    private static Property getProp(String category, String key, boolean defaultValue, boolean requiresMcRestart) {
        VALID_CATEGORIES.add(category);
        Property prop = config.get(category, key, defaultValue).setRequiresMcRestart(requiresMcRestart);
        VALID_CONFIGS.add(category + "_" + key);
        return prop;
    }

    private static Property getProp(String key, int defaultValue) {
        return ConfigReader.getProp(currentCategory, key, defaultValue, currentRequiresMcRestart);
    }

    private static Property getProp(String category, String key, int defaultValue, boolean requiresMcRestart) {
        VALID_CATEGORIES.add(category);
        Property prop = config.get(category, key, defaultValue).setRequiresMcRestart(requiresMcRestart);
        VALID_CONFIGS.add(category + "_" + key);
        return prop;
    }

    private static Property getProp(String key, double defaultValue) {
        return ConfigReader.getProp(currentCategory, key, defaultValue, currentRequiresMcRestart);
    }

    private static Property getProp(String category, String key, double defaultValue, boolean requiresMcRestart) {
        VALID_CATEGORIES.add(category);
        Property prop = config.get(category, key, defaultValue).setRequiresMcRestart(requiresMcRestart);
        VALID_CONFIGS.add(category + "_" + key);
        return prop;
    }

    private static Property getProp(String key, String defaultValue) {
        return ConfigReader.getProp(currentCategory, key, defaultValue, currentRequiresMcRestart);
    }

    private static Property getProp(String category, String key, String defaultValue, boolean requiresMcRestart) {
        VALID_CATEGORIES.add(category);
        Property prop = config.get(category, key, defaultValue).setRequiresMcRestart(requiresMcRestart);
        VALID_CONFIGS.add(category + "_" + key);
        return prop;
    }

    private static Property getProp(String key, String[] defaultValue) {
        return ConfigReader.getProp(currentCategory, key, defaultValue, currentRequiresMcRestart);
    }

    private static Property getProp(String category, String key, String[] defaultValue, boolean requiresMcRestart) {
        VALID_CATEGORIES.add(category);
        Property prop = config.get(category, key, defaultValue).setRequiresMcRestart(requiresMcRestart);
        VALID_CONFIGS.add(category + "_" + key);
        return prop;
    }

    private static void removeInvalidConfigs(Configuration conf) {
        ArrayList<String> categoriesToRemove = new ArrayList<String>();
        for (String category : conf.getCategoryNames()) {
            if (!VALID_CATEGORIES.contains(category)) {
                categoriesToRemove.add(category);
                continue;
            }
            ConfigCategory cat = conf.getCategory(category);
            ArrayList<String> propsToRemove = new ArrayList<String>();
            for (String key : cat.keySet()) {
                if (VALID_CONFIGS.contains(category + "_" + key)) continue;
                propsToRemove.add(key);
            }
            for (String key : propsToRemove) {
                cat.remove((Object)key);
            }
        }
        for (String category : categoriesToRemove) {
            conf.removeCategory(conf.getCategory(category));
        }
    }

    static {
        VALID_CATEGORIES = new HashSet<String>();
        VALID_CONFIGS = new HashSet<String>();
    }
}

