/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.client.renderer.model.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.block.BlockInserter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public class BakedModelInserter
implements IBakedModel {
    private static final String TEX_NORMAL_IN = "enderutilities:blocks/inserter_normal_in";
    private static final String TEX_NORMAL_OUT = "enderutilities:blocks/inserter_normal_out";
    private static final String TEX_NORMAL_SIDE = "enderutilities:blocks/inserter_normal_side";
    private static final String TEX_NORMAL_SIDE_OUT_INVALID = "enderutilities:blocks/inserter_normal_side_out_invalid";
    private static final String TEX_NORMAL_SIDE_OUT_VALID = "enderutilities:blocks/inserter_normal_side_out_valid";
    private static final String TEX_FILTERED_IN = "enderutilities:blocks/inserter_filtered_in";
    private static final String TEX_FILTERED_OUT = "enderutilities:blocks/inserter_filtered_out";
    private static final String TEX_FILTERED_SIDE = "enderutilities:blocks/inserter_filtered_side";
    private static final String TEX_FILTERED_SIDE_OUT_VALID = "enderutilities:blocks/inserter_filtered_side_out_valid";
    private static final String TEX_FILTERED_SIDE_OUT_INVALID = "enderutilities:blocks/inserter_filtered_side_out_invalid";
    private static final Map<IBlockState, ImmutableMap<Optional<EnumFacing>, ImmutableList<BakedQuad>>> QUAD_CACHE = new HashMap<IBlockState, ImmutableMap<Optional<EnumFacing>, ImmutableList<BakedQuad>>>();
    private final IModel baseModel;
    private final IModel sideModelValid;
    private final IModel sideModelInvalid;
    private final VertexFormat format;
    private final IBakedModel bakedBaseModel;
    private final Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter;
    private final TextureAtlasSprite particle;

    private BakedModelInserter(ModelInserter inserterModel, IModel baseModel, IModel sideModel, IModelState modelState, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap<String, String> textures = inserterModel.getTextureMapping();
        this.baseModel = baseModel.retexture(textures);
        this.sideModelValid = sideModel.retexture(ImmutableMap.of((Object)"side", (Object)textures.get((Object)"side_valid")));
        this.sideModelInvalid = sideModel.retexture(ImmutableMap.of((Object)"side", (Object)textures.get((Object)"side_invalid")));
        this.format = format;
        this.bakedTextureGetter = bakedTextureGetter;
        this.bakedBaseModel = this.baseModel.bake(modelState, format, bakedTextureGetter);
        this.particle = bakedTextureGetter.apply(new ResourceLocation((String)textures.get((Object)"particle")));
    }

    public boolean func_177555_b() {
        return this.bakedBaseModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.bakedBaseModel.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.bakedBaseModel.func_188618_c();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.bakedBaseModel.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return this.bakedBaseModel.func_188617_f();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.particle;
    }

    public synchronized List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (state == null) {
            return this.bakedBaseModel.func_188616_a(state, side, rand);
        }
        ImmutableMap<Optional<EnumFacing>, ImmutableList<BakedQuad>> quads = QUAD_CACHE.get(state);
        if (quads == null) {
            TRSRTransformation modelState = TRSRTransformation.from((EnumFacing)((EnumFacing)state.func_177229_b((IProperty)BlockInserter.FACING)));
            IBakedModel bakedBaseModel = this.baseModel.bake((IModelState)modelState, this.format, this.bakedTextureGetter);
            quads = this.bakeFullModel(bakedBaseModel, state, side);
            QUAD_CACHE.put(state, quads);
            return (List)quads.get(Optional.ofNullable(side));
        }
        return (List)QUAD_CACHE.get(state).get(Optional.ofNullable(side));
    }

    private ImmutableMap<Optional<EnumFacing>, ImmutableList<BakedQuad>> bakeFullModel(IBakedModel baseModel, IBlockState state, @Nullable EnumFacing side) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        List<IBakedModel> sideModels = this.getSideModels(state);
        for (EnumFacing face : EnumFacing.values()) {
            ImmutableList.Builder quads = ImmutableList.builder();
            quads.addAll((Iterable)baseModel.func_188616_a(state, face, 0L));
            for (IBakedModel bakedPart : sideModels) {
                quads.addAll((Iterable)bakedPart.func_188616_a(state, face, 0L));
            }
            builder.put(Optional.of(face), (Object)quads.build());
        }
        ImmutableList.Builder quads = ImmutableList.builder();
        quads.addAll((Iterable)baseModel.func_188616_a(state, null, 0L));
        for (IBakedModel bakedPart : sideModels) {
            quads.addAll((Iterable)bakedPart.func_188616_a(state, null, 0L));
        }
        builder.put(Optional.empty(), (Object)quads.build());
        return builder.build();
    }

    private List<IBakedModel> getSideModels(IBlockState state) {
        ArrayList<IBakedModel> models = new ArrayList<IBakedModel>();
        for (EnumFacing side : EnumFacing.values()) {
            BlockInserter.Connection conn = (BlockInserter.Connection)((Object)state.func_177229_b((IProperty)BlockInserter.CONNECTIONS.get(side.func_176745_a())));
            if (conn == BlockInserter.Connection.VALID) {
                models.add(this.sideModelValid.bake((IModelState)TRSRTransformation.from((EnumFacing)side), this.format, this.bakedTextureGetter));
                continue;
            }
            if (conn != BlockInserter.Connection.INVALID) continue;
            models.add(this.sideModelInvalid.bake((IModelState)TRSRTransformation.from((EnumFacing)side), this.format, this.bakedTextureGetter));
        }
        return models;
    }

    public static class StateMapper
    extends StateMapperBase {
        private static final ModelResourceLocation LOCATION_NORMAL = new ModelResourceLocation("enderutilities:inserter", "type=normal");
        private static final ModelResourceLocation LOCATION_FILTERED = new ModelResourceLocation("enderutilities:inserter", "type=filtered");

        protected ModelResourceLocation func_178132_a(IBlockState state) {
            return state.func_177229_b(BlockInserter.TYPE) == BlockInserter.InserterType.FILTERED ? LOCATION_FILTERED : LOCATION_NORMAL;
        }
    }

    public static class ModelLoaderInserter
    implements ICustomModelLoader {
        private static final ResourceLocation FAKE_LOCATION_NORMAL = new ResourceLocation("enderutilities", "models/block/custom/inserter_normal");
        private static final ResourceLocation FAKE_LOCATION_FILTERED = new ResourceLocation("enderutilities", "models/block/custom/inserter_filtered");

        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.equals((Object)FAKE_LOCATION_NORMAL) || modelLocation.equals((Object)FAKE_LOCATION_FILTERED);
        }

        public IModel loadModel(ResourceLocation modelLocation) throws Exception {
            if (modelLocation.equals((Object)FAKE_LOCATION_FILTERED)) {
                return new ModelInserterFiltered();
            }
            return new ModelInserterNormal();
        }

        public void func_110549_a(IResourceManager resourceManager) {
            QUAD_CACHE.clear();
        }
    }

    private static class ModelInserterFiltered
    extends ModelInserter {
        private ModelInserterFiltered() {
            this.textures.put("particle", BakedModelInserter.TEX_FILTERED_IN);
            this.textures.put("base_in", BakedModelInserter.TEX_FILTERED_IN);
            this.textures.put("base_out", BakedModelInserter.TEX_FILTERED_OUT);
            this.textures.put("base_side", BakedModelInserter.TEX_FILTERED_SIDE);
            this.textures.put("side_valid", BakedModelInserter.TEX_FILTERED_SIDE_OUT_VALID);
            this.textures.put("side_invalid", BakedModelInserter.TEX_FILTERED_SIDE_OUT_INVALID);
        }
    }

    private static class ModelInserterNormal
    extends ModelInserter {
        private ModelInserterNormal() {
            this.textures.put("particle", BakedModelInserter.TEX_NORMAL_IN);
            this.textures.put("base_in", BakedModelInserter.TEX_NORMAL_IN);
            this.textures.put("base_out", BakedModelInserter.TEX_NORMAL_OUT);
            this.textures.put("base_side", BakedModelInserter.TEX_NORMAL_SIDE);
            this.textures.put("side_valid", BakedModelInserter.TEX_NORMAL_SIDE_OUT_VALID);
            this.textures.put("side_invalid", BakedModelInserter.TEX_NORMAL_SIDE_OUT_INVALID);
        }
    }

    private static abstract class ModelInserter
    implements IModel {
        private static final ResourceLocation BASE_MODEL = new ResourceLocation("enderutilities", "block/inserter_base");
        private static final ResourceLocation SIDE_MODEL = new ResourceLocation("enderutilities", "block/inserter_side");
        protected final Map<String, String> textures = new HashMap<String, String>();

        private ModelInserter() {
        }

        public IModelState getDefaultState() {
            return ModelRotation.X0_Y0;
        }

        public Collection<ResourceLocation> getDependencies() {
            return Lists.newArrayList((Object[])new ResourceLocation[]{BASE_MODEL, SIDE_MODEL});
        }

        public Collection<ResourceLocation> getTextures() {
            ArrayList textures = Lists.newArrayList();
            for (String name : this.getTextureMapping().values()) {
                textures.add(new ResourceLocation(name));
            }
            return textures;
        }

        public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            IModel baseModel = null;
            IModel sideModel = null;
            try {
                baseModel = ModelLoaderRegistry.getModel((ResourceLocation)BASE_MODEL);
                sideModel = ModelLoaderRegistry.getModel((ResourceLocation)SIDE_MODEL);
            }
            catch (Exception e) {
                EnderUtilities.logger.warn("Failed to load a model for the Inserter!");
            }
            return new BakedModelInserter(this, baseModel, sideModel, state, format, bakedTextureGetter);
        }

        public ImmutableMap<String, String> getTextureMapping() {
            return ImmutableMap.copyOf(this.textures);
        }
    }
}

