/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.block;

import fi.dy.masa.enderutilities.block.base.BlockEnderUtilities;
import fi.dy.masa.enderutilities.block.base.BlockEnderUtilitiesInventory;
import fi.dy.masa.enderutilities.item.block.ItemBlockStorage;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilities;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilitiesInventory;
import fi.dy.masa.enderutilities.tileentity.TileEntityHandyChest;
import fi.dy.masa.enderutilities.tileentity.TileEntityJSU;
import fi.dy.masa.enderutilities.tileentity.TileEntityMemoryChest;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.TileUtils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockStorage
extends BlockEnderUtilitiesInventory {
    protected static final AxisAlignedBB SINGLE_CHEST_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375);
    public static final PropertyEnum<EnumStorageType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumStorageType.class);

    public BlockStorage(String name, float hardness, float resistance, int harvestLevel, Material material) {
        super(name, hardness, resistance, harvestLevel, material);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a(TYPE, (Comparable)((Object)EnumStorageType.MEMORY_CHEST_0)).func_177226_a((IProperty)FACING_H, (Comparable)BlockEnderUtilities.DEFAULT_FACING));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, FACING_H});
    }

    @Override
    public ItemBlock createItemBlock() {
        return new ItemBlockStorage(this);
    }

    @Override
    protected String[] generateUnlocalizedNames() {
        return new String[]{"memory_chest_0", "memory_chest_1", "memory_chest_2", "handy_chest_0", "handy_chest_1", "handy_chest_2", "handy_chest_3", "jsu"};
    }

    @Override
    protected String[] generateTooltipNames() {
        return new String[]{"memory_chest", "memory_chest", "memory_chest", "handy_chest", "handy_chest", "handy_chest", "handy_chest", "jsu"};
    }

    @Override
    protected TileEntityEnderUtilities createTileEntityInstance(World worldIn, IBlockState state) {
        switch ((EnumStorageType)((Object)state.func_177229_b(TYPE))) {
            case MEMORY_CHEST_0: 
            case MEMORY_CHEST_1: 
            case MEMORY_CHEST_2: {
                TileEntityMemoryChest temc = new TileEntityMemoryChest();
                temc.setStorageTier(((EnumStorageType)((Object)state.func_177229_b(TYPE))).getTier());
                return temc;
            }
            case HANDY_CHEST_0: 
            case HANDY_CHEST_1: 
            case HANDY_CHEST_2: 
            case HANDY_CHEST_3: {
                TileEntityHandyChest tehc = new TileEntityHandyChest();
                tehc.setStorageTier(worldIn, ((EnumStorageType)((Object)state.func_177229_b(TYPE))).getTier());
                return tehc;
            }
            case JSU: {
                return new TileEntityJSU();
            }
        }
        return new TileEntityMemoryChest();
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d) {
            switch ((EnumStorageType)((Object)state.func_177229_b(TYPE))) {
                case MEMORY_CHEST_0: 
                case MEMORY_CHEST_1: 
                case MEMORY_CHEST_2: {
                    TileEntityMemoryChest te = BlockStorage.getTileEntitySafely((IBlockAccess)world, pos, TileEntityMemoryChest.class);
                    if (te == null || te.isUseableByPlayer(player)) break;
                    TextComponentTranslation msg = new TextComponentTranslation("enderutilities.chat.message.private.owned.by", new Object[]{te.getOwnerName()});
                    player.func_146105_b((ITextComponent)msg, true);
                    return false;
                }
            }
        }
        return super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (((EnumStorageType)((Object)state.func_177229_b(TYPE))).retainsContents()) {
            world.func_175666_e(pos, (Block)this);
            world.func_175713_t(pos);
        } else {
            super.func_180663_b(world, pos, state);
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest && ((EnumStorageType)((Object)state.func_177229_b(TYPE))).retainsContents()) {
            this.func_176208_a(world, pos, state, player);
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175698_g(pos);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (((EnumStorageType)((Object)state.func_177229_b(TYPE))).retainsContents()) {
            drops.add((Object)this.getDroppedItemWithNBT(world, pos, state, false));
        } else {
            super.getDrops(drops, world, pos, state, fortune);
        }
    }

    protected ItemStack getDroppedItemWithNBT(IBlockAccess worldIn, BlockPos pos, IBlockState state, boolean addNBTLore) {
        Random rand = worldIn instanceof World ? ((World)worldIn).field_73012_v : RANDOM;
        ItemStack stack = new ItemStack(this.func_180660_a(state, rand, 0), 1, ((EnumStorageType)((Object)state.func_177229_b(TYPE))).getMeta());
        TileEntityEnderUtilitiesInventory te = BlockStorage.getTileEntitySafely(worldIn, pos, TileEntityEnderUtilitiesInventory.class);
        if (te != null && InventoryUtils.getFirstNonEmptySlot(te.getBaseItemHandler()) != -1) {
            return TileUtils.storeTileEntityInStackWithCachedInventory(stack, te, addNBTLore, 9);
        }
        return stack;
    }

    @Deprecated
    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        switch ((EnumStorageType)((Object)state.func_177229_b(TYPE))) {
            case HANDY_CHEST_0: 
            case HANDY_CHEST_1: 
            case HANDY_CHEST_2: 
            case HANDY_CHEST_3: {
                TileEntityHandyChest tehc = BlockStorage.getTileEntitySafely((IBlockAccess)world, pos, TileEntityHandyChest.class);
                if (tehc == null || tehc.getLockMask() == 0) break;
                return -1.0f;
            }
            case MEMORY_CHEST_0: 
            case MEMORY_CHEST_1: 
            case MEMORY_CHEST_2: {
                TileEntityMemoryChest temc = BlockStorage.getTileEntitySafely((IBlockAccess)world, pos, TileEntityMemoryChest.class);
                if (temc == null || temc.isPublic()) break;
                return -1.0f;
            }
        }
        return super.func_176195_g(state, world, pos);
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return ((EnumStorageType)((Object)state.func_177229_b(TYPE))).isFullCube();
    }

    public boolean func_149686_d(IBlockState state) {
        return ((EnumStorageType)((Object)state.func_177229_b(TYPE))).isFullCube();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (state.func_177229_b(TYPE) == EnumStorageType.JSU) {
            return field_185505_j;
        }
        return SINGLE_CHEST_AABB;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumStorageType.fromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumStorageType)((Object)state.func_177229_b(TYPE))).getMeta();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < EnumStorageType.values().length; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, EnumStorageType.values()[i].getMeta()));
        }
    }

    public static enum EnumStorageType implements IStringSerializable
    {
        MEMORY_CHEST_0(0, 0, "memory_chest"),
        MEMORY_CHEST_1(1, 1, "memory_chest"),
        MEMORY_CHEST_2(2, 2, "memory_chest"),
        HANDY_CHEST_0(3, 0, "handy_chest"),
        HANDY_CHEST_1(4, 1, "handy_chest"),
        HANDY_CHEST_2(5, 2, "handy_chest"),
        HANDY_CHEST_3(6, 3, "handy_chest"),
        JSU(7, -1, "jsu", true, true);

        private final int tier;
        private final String nameBase;
        private final int meta;
        private final boolean isFullCube;
        private final boolean retainsContents;

        private EnumStorageType(int meta, int tier, String nameBase) {
            this(meta, tier, nameBase, false, false);
        }

        private EnumStorageType(int meta, int tier, String nameBase, boolean fullCube, boolean retainsContents) {
            this.meta = meta;
            this.tier = tier;
            this.nameBase = nameBase;
            this.isFullCube = fullCube;
            this.retainsContents = retainsContents;
        }

        public String toString() {
            if (this.tier < 0) {
                return this.nameBase;
            }
            return this.nameBase + "_" + this.tier;
        }

        public String func_176610_l() {
            return this.toString();
        }

        public int getTier() {
            return this.tier;
        }

        public int getMeta() {
            return this.meta;
        }

        public boolean isFullCube() {
            return this.isFullCube;
        }

        public boolean retainsContents() {
            return this.retainsContents;
        }

        public static EnumStorageType fromMeta(int meta) {
            return EnumStorageType.values()[meta % EnumStorageType.values().length];
        }
    }
}

