/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.common.client;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.mantle.client.gui.GuiElement;
import slimeknights.mantle.client.gui.GuiMultiModule;
import slimeknights.mantle.common.IInventoryGui;
import slimeknights.mantle.inventory.ContainerMultiModule;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.Icons;
import slimeknights.tconstruct.tools.common.block.ITinkerStationBlock;
import slimeknights.tconstruct.tools.common.client.module.GuiTinkerTabs;
import slimeknights.tconstruct.tools.common.inventory.ContainerTinkerStation;
import slimeknights.tconstruct.tools.common.network.TinkerStationTabPacket;

@SideOnly(value=Side.CLIENT)
public class GuiTinkerStation
extends GuiMultiModule {
    public static final ResourceLocation BLANK_BACK = Util.getResource("textures/gui/blank.png");
    protected final ContainerMultiModule<?> container;
    protected GuiTinkerTabs tinkerTabs;
    private final World world;

    public GuiTinkerStation(World world, BlockPos pos, ContainerTinkerStation<?> container) {
        super(container);
        this.world = world;
        this.container = container;
        this.tinkerTabs = new GuiTinkerTabs(this, (Container)container);
        this.addModule(this.tinkerTabs);
        if (container.hasCraftingStation) {
            for (Pair<BlockPos, IBlockState> pair : container.tinkerStationBlocks) {
                IBlockState state = (IBlockState)pair.getRight();
                BlockPos blockPos = (BlockPos)pair.getLeft();
                ItemStack stack = (ItemStack)state.func_177230_c().getDrops((IBlockAccess)world, blockPos, state, 0).get(0);
                this.tinkerTabs.addTab(stack, blockPos);
            }
        }
        for (int i = 0; i < this.tinkerTabs.tabData.size(); ++i) {
            if (!this.tinkerTabs.tabData.get(i).equals((Object)pos)) continue;
            this.tinkerTabs.tabs.selected = i;
        }
    }

    protected void drawIcon(Slot slot, GuiElement element) {
        this.field_146297_k.func_110434_K().func_110577_a(Icons.ICON);
        element.draw(slot.field_75223_e + this.cornerX - 1, slot.field_75221_f + this.cornerY - 1);
    }

    protected void drawIconEmpty(Slot slot, GuiElement element) {
        if (slot.func_75216_d()) {
            return;
        }
        this.drawIcon(slot, element);
    }

    public void onTabSelection(int selection) {
        if (selection < 0 || selection > this.tinkerTabs.tabData.size()) {
            return;
        }
        BlockPos pos = this.tinkerTabs.tabData.get(selection);
        IBlockState state = this.world.func_180495_p(pos);
        if (state.func_177230_c() instanceof ITinkerStationBlock) {
            TileEntity te = this.world.func_175625_s(pos);
            if (te instanceof IInventoryGui) {
                TinkerNetwork.sendToServer((AbstractPacket)new TinkerStationTabPacket(pos));
            }
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        }
    }

    public void error(String message) {
    }

    public void warning(String message) {
    }

    public void updateDisplay() {
    }
}

