/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.cyclops.cyclopscore.inventory.IndexedSlotlessItemHandlerWrapper;
import org.cyclops.cyclopscore.inventory.LargeInventory;

public class IndexedInventory
extends LargeInventory
implements IndexedSlotlessItemHandlerWrapper.IInventoryIndexReference {
    private final Map<Item, Int2ObjectMap<ItemStack>> index = Maps.newIdentityHashMap();
    private int firstEmptySlot = 0;
    private int lastEmptySlot;
    private int firstNonEmptySlot;
    private int lastNonEmptySlot;

    public IndexedInventory() {
        this(0, "", 0);
    }

    public IndexedInventory(int size, String name, int stackLimit) {
        super(size, name, stackLimit);
        this.lastEmptySlot = size - 1;
        this.firstNonEmptySlot = -1;
        this.lastNonEmptySlot = -1;
    }

    protected void createIndex() {
        this.index.clear();
        this.firstEmptySlot = -1;
        this.lastEmptySlot = -1;
        this.firstNonEmptySlot = -1;
        this.lastNonEmptySlot = -1;
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemStack = this.func_70301_a(i);
            if (!itemStack.func_190926_b()) {
                Int2ObjectOpenHashMap stacks = this.index.get(itemStack.func_77973_b());
                if (stacks == null) {
                    stacks = new Int2ObjectOpenHashMap();
                    this.index.put(itemStack.func_77973_b(), (Int2ObjectMap<ItemStack>)stacks);
                }
                stacks.put(i, (Object)itemStack);
                if (this.firstNonEmptySlot < 0) {
                    this.firstNonEmptySlot = i;
                }
                this.lastNonEmptySlot = i;
                continue;
            }
            if (this.firstEmptySlot < 0) {
                this.firstEmptySlot = i;
            }
            this.lastEmptySlot = i;
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data, String tag) {
        super.readFromNBT(data, tag);
        this.createIndex();
    }

    @Override
    public void func_70299_a(int slotId, ItemStack itemStack) {
        int i;
        Int2ObjectMap<ItemStack> stacks;
        ItemStack oldStack = this.func_70301_a(slotId);
        if (!oldStack.func_190926_b()) {
            stacks = this.index.get(oldStack.func_77973_b());
            if (stacks != null) {
                stacks.remove(slotId);
            }
            if (stacks.isEmpty()) {
                this.index.remove(oldStack.func_77973_b());
            }
        }
        if (!itemStack.func_190926_b()) {
            stacks = this.index.get(itemStack.func_77973_b());
            if (stacks == null) {
                stacks = new Int2ObjectOpenHashMap();
                this.index.put(itemStack.func_77973_b(), stacks);
            }
            stacks.put(slotId, (Object)itemStack);
        }
        super.func_70299_a(slotId, itemStack);
        if (slotId == this.firstEmptySlot && oldStack.func_190926_b() && !itemStack.func_190926_b()) {
            int oldFirstEmptySlot = this.firstEmptySlot;
            this.firstEmptySlot = -1;
            for (i = Math.max(0, oldFirstEmptySlot); i < this.func_70302_i_(); ++i) {
                if (!this.func_70301_a(i).func_190926_b()) continue;
                this.firstEmptySlot = i;
                break;
            }
        }
        if (slotId == this.lastEmptySlot && oldStack.func_190926_b() && !itemStack.func_190926_b()) {
            int oldLastEmptySlot = this.lastEmptySlot;
            this.lastEmptySlot = -1;
            for (i = oldLastEmptySlot; i >= 0; --i) {
                if (!this.func_70301_a(i).func_190926_b()) continue;
                this.lastEmptySlot = i;
                break;
            }
        }
        if (slotId == this.firstNonEmptySlot && !oldStack.func_190926_b() && itemStack.func_190926_b()) {
            int oldFirstNonEmptySlot = this.firstNonEmptySlot;
            this.firstNonEmptySlot = -1;
            for (i = Math.max(0, oldFirstNonEmptySlot); i < this.func_70302_i_(); ++i) {
                if (this.func_70301_a(i).func_190926_b()) continue;
                this.firstNonEmptySlot = i;
                break;
            }
        }
        if (slotId == this.lastNonEmptySlot && !oldStack.func_190926_b() && itemStack.func_190926_b()) {
            int oldLastNonEmptySlot = this.lastNonEmptySlot;
            this.lastNonEmptySlot = -1;
            for (i = oldLastNonEmptySlot; i >= 0; --i) {
                if (this.func_70301_a(i).func_190926_b()) continue;
                this.lastNonEmptySlot = i;
                break;
            }
        }
        if ((slotId < this.firstEmptySlot || this.firstEmptySlot < 0) && itemStack.func_190926_b()) {
            this.firstEmptySlot = slotId;
        }
        if (slotId > this.lastEmptySlot && itemStack.func_190926_b()) {
            this.lastEmptySlot = slotId;
        }
        if (!(slotId >= this.firstNonEmptySlot && this.firstNonEmptySlot >= 0 || itemStack.func_190926_b())) {
            this.firstNonEmptySlot = slotId;
        }
        if (slotId > this.lastNonEmptySlot && !itemStack.func_190926_b()) {
            this.lastNonEmptySlot = slotId;
        }
        if (this.firstEmptySlot == this.firstNonEmptySlot) {
            throw new IllegalStateException(String.format("Indexed inventory at inconsistent with first empty %s and first non-empty %s.", this.firstEmptySlot, this.firstNonEmptySlot));
        }
        if (this.lastEmptySlot == this.lastNonEmptySlot) {
            throw new IllegalStateException(String.format("Indexed inventory at inconsistent with last empty %s and last non-empty %s.", this.lastEmptySlot, this.lastNonEmptySlot));
        }
    }

    @Override
    public void func_174888_l() {
        super.func_174888_l();
        this.index.clear();
    }

    @Override
    public Map<Item, Int2ObjectMap<ItemStack>> getIndex() {
        return this.index;
    }

    @Override
    public int getFirstEmptySlot() {
        return this.firstEmptySlot;
    }

    @Override
    public int getLastEmptySlot() {
        return this.lastEmptySlot;
    }

    @Override
    public int getFirstNonEmptySlot() {
        return this.firstNonEmptySlot;
    }

    @Override
    public int getLastNonEmptySlot() {
        return this.lastNonEmptySlot;
    }
}

