/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.inventory.PlayerExtendedInventoryIterator;

public final class ItemStackHelpers {
    private static final Random RANDOM = new Random();

    public static NBTTagCompound getSafeTagCompound(ItemStack itemStack) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        return itemStack.func_77978_p();
    }

    public static void spawnItemStack(World world, BlockPos pos, ItemStack itemStack) {
        ItemStackHelpers.spawnItemStack(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), itemStack);
    }

    public static void spawnItemStack(World world, double x, double y, double z, ItemStack itemStack) {
        float offsetX = RANDOM.nextFloat() * 0.8f + 0.1f;
        float offsetY = RANDOM.nextFloat() * 0.8f + 0.1f;
        float offsetZ = RANDOM.nextFloat() * 0.8f + 0.1f;
        while (itemStack.func_190916_E() > 0) {
            int i = RANDOM.nextInt(21) + 10;
            if (i > itemStack.func_190916_E()) {
                i = itemStack.func_190916_E();
            }
            ItemStack dropStack = itemStack.func_77946_l();
            itemStack.func_190918_g(i);
            dropStack.func_190920_e(i);
            EntityItem entityitem = new EntityItem(world, x + (double)offsetX, y + (double)offsetY, z + (double)offsetZ, dropStack);
            float motion = 0.05f;
            entityitem.field_70159_w = RANDOM.nextGaussian() * (double)motion;
            entityitem.field_70181_x = RANDOM.nextGaussian() * (double)motion + 0.2;
            entityitem.field_70179_y = RANDOM.nextGaussian() * (double)motion;
            world.func_72838_d((Entity)entityitem);
        }
    }

    public static void spawnItemStackToPlayer(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        if (!world.field_72995_K) {
            float f = 0.5f;
            double xo = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double yo = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double zo = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + xo, (double)pos.func_177956_o() + yo, (double)pos.func_177952_p() + zo, stack);
            double d0 = 8.0;
            double d1 = (player.field_70165_t - entityitem.field_70165_t) / d0;
            double d2 = (player.field_70163_u + (double)player.func_70047_e() - entityitem.field_70163_u) / d0;
            double d3 = (player.field_70161_v - entityitem.field_70161_v) / d0;
            entityitem.field_70159_w += d1;
            entityitem.field_70181_x += d2;
            entityitem.field_70179_y += d3;
            entityitem.func_174868_q();
            world.func_72838_d((Entity)entityitem);
        }
    }

    public static boolean hasPlayerItem(EntityPlayer player, Item item) {
        PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator(player);
        while (it.hasNext()) {
            ItemStack itemStack = it.next();
            if (itemStack == null || itemStack.func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    public static List<ItemStack> getVariants(ItemStack itemStack) {
        NonNullList output = NonNullList.func_191196_a();
        if (itemStack.func_77952_i() == Short.MAX_VALUE) {
            itemStack.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, output);
        } else {
            output.add((Object)itemStack);
        }
        return output;
    }

    public static ItemStack parseItemStack(String itemStackString) {
        String[] split = itemStackString.split(":");
        String itemName = split[0] + ":" + split[1];
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(itemName));
        if (item == null) {
            throw new IllegalArgumentException("Invalid ItemStack item: " + itemName);
        }
        int amount = 1;
        int meta = 0;
        if (split.length > 2) {
            try {
                amount = Integer.parseInt(split[2]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid ItemStack amount: " + split[2]);
            }
            if (split.length > 3) {
                try {
                    meta = Integer.parseInt(split[3]);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid ItemStack meta: " + split[3]);
                }
            }
        }
        return new ItemStack(item, amount, meta);
    }

    @Deprecated
    public static boolean areItemStacksIdentical(ItemStack a, ItemStack b) {
        return ItemStack.func_77989_b((ItemStack)a, (ItemStack)b);
    }

    public static int getItemStackHashCode(ItemStack stack) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a.hashCode();
        }
        int result = 1;
        result = 37 * result + stack.func_190916_E();
        result = 37 * result + stack.func_77973_b().hashCode();
        result = 37 * result + stack.func_77952_i();
        NBTTagCompound tagCompound = stack.func_77978_p();
        result = 37 * result + (tagCompound != null ? tagCompound.hashCode() : 0);
        return result;
    }

    public static boolean isValidCreativeTab(Item item, @Nullable CreativeTabs creativeTab) {
        for (CreativeTabs itemTab : item.getCreativeTabs()) {
            if (itemTab != creativeTab) continue;
            return true;
        }
        return creativeTab == null || creativeTab == CreativeTabs.field_78027_g;
    }

    public static NonNullList<ItemStack> getSubItems(ItemStack itemStack) {
        NonNullList subItems = NonNullList.func_191196_a();
        itemStack.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, subItems);
        return subItems;
    }

    public static NonNullList<ItemStack> getSubItemsIfWildcardMeta(ItemStack itemStack) {
        if (itemStack.func_77960_j() == Short.MAX_VALUE) {
            NonNullList subItems = NonNullList.func_191196_a();
            itemStack.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, subItems);
            return subItems;
        }
        return NonNullList.func_191197_a((int)1, (Object)itemStack);
    }
}

