/*
 * Decompiled with CFR 0.152.
 */
package scavenge.world.blockEffects;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.FloatElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.JsonUtil;

public class PropPlaySound
extends BaseResourceProperty
implements IResourceEffect {
    SoundEvent event;
    SoundCategory cat;
    float volume;
    float pitch;

    public PropPlaySound(JsonObject obj) {
        super(obj, "play_sound");
        this.event = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(obj.get("name").getAsString()));
        this.cat = SoundCategory.func_187950_a((String)JsonUtil.getOrDefault(obj, "category", "master"));
        this.volume = JsonUtil.getOrDefault(obj, "volume", 1.0f);
        this.pitch = JsonUtil.getOrDefault(obj, "pitch", 1.0f);
        this.setJEIInfo("Plays a sound");
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        world.func_184133_a(null, pos, this.event, this.cat, this.volume, this.pitch);
        return false;
    }

    public static class PlaySoundFactory
    extends BaseResourceFactory {
        public PlaySoundFactory() {
            super("play_sound", IResourceFactory.PropertyType.Effect);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropPlaySound(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("name", "minecraft:block.glass.break");
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.setDescription("Allows to play a sound at the Blocks position");
            map.addElement(new TextElement("name", "").setDescription("The Sound ID that should be played"));
            map.addElement(new TextElement("category", "master", "Which sound category the sound should play under"));
            map.addElement(new FloatElement("volume", 1.0f, "how loud the sound should play"));
            map.addElement(new FloatElement("pitch", 1.0f, "how high the pitch of the sound should be"));
            return map;
        }
    }
}

