/*
 * Decompiled with CFR 0.152.
 */
package scavenge.world.blockEffects;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.ArrayElement;
import scavenge.api.autodoc.DoubleElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.BlockEntry;
import scavenge.api.utils.JsonUtil;

public class PropModifyBlockAround
extends BaseResourceProperty
implements IResourceEffect {
    BlockEntry result;
    Set<EnumFacing> sides = EnumSet.noneOf(EnumFacing.class);
    double chance;

    public PropModifyBlockAround(JsonObject obj) {
        super(obj, "modify_required");
        this.chance = JsonUtil.getOrDefault(obj, "chance", 100.0);
        if (obj.has("name")) {
            this.result = JsonUtil.createBlockWithMeta(obj);
            if (this.result == null) {
                throw new RuntimeException("Block [" + obj + "] causes a null Block this is not allowed");
            }
        } else {
            this.result = new BlockEntry(Blocks.field_150350_a, 0);
        }
        JsonUtil.convertToPrimitive(obj.get("sides"), new Consumer<JsonPrimitive>(){

            @Override
            public void accept(JsonPrimitive t) {
                EnumFacing side = EnumFacing.func_176739_a((String)t.getAsString());
                if (side == null) {
                    throw new RuntimeException("Side [" + t + " is a null thats not allowed");
                }
                PropModifyBlockAround.this.sides.add(side);
            }
        });
        this.setJEIInfo("[" + this.chance + "] that these sides " + this.sides + " get Converted to " + this.result.getName());
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        if (this.chance >= world.field_73012_v.nextDouble() * 100.0) {
            boolean did = false;
            for (EnumFacing facing : this.sides) {
                if (!world.func_175656_a(pos.func_177972_a(facing), this.result.getBlockState())) continue;
                did = true;
            }
            return did;
        }
        return false;
    }

    public static class ModifyBlockAroundFactory
    extends BaseResourceFactory {
        public ModifyBlockAroundFactory() {
            super("modify_required", IResourceFactory.PropertyType.Effect);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropModifyBlockAround(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            JsonArray array = new JsonArray();
            obj.add("sides", (JsonElement)array);
            array.add((JsonElement)new JsonPrimitive("north"));
            array.add((JsonElement)new JsonPrimitive("south"));
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.setDescription("Allows to replace the blocks of the connection sides");
            map.addElement(new DoubleElement("chance", 100.0, "How likely it is that the Replacments happens"));
            map.addElement(new TextElement("name", "minecraft:air", "Which block it should turn into"));
            map.addElement(new IntElement("meta", 0, "The metadata the block should turn into"));
            map.addElement(new ArrayElement("sides", new TextElement("", "")).setDescription("The Sides that should be modified"));
            return map;
        }
    }
}

