/*
 * Decompiled with CFR 0.152.
 */
package scavenge.world.blockEffects;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.ScavengeAPI;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.JsonUtil;

public class PropMakeUnbreakable
extends BaseResourceProperty
implements IResourceEffect {
    boolean unbreakable;

    public PropMakeUnbreakable(JsonObject obj) {
        super(obj, "mark_unbreakable");
        this.setJEIInfo("Makes the Block Unbreakable");
        this.unbreakable = JsonUtil.getOrDefault(obj, "set", true);
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        if (this.unbreakable) {
            ScavengeAPI.INSTANCE.getWorldRegistry().getStorageForWorld(world).markBlockAsUnbreakable(resourceID, pos);
        } else {
            ScavengeAPI.INSTANCE.getWorldRegistry().getStorageForWorld(world).removeBlockUnbreaking(resourceID, pos);
        }
        return true;
    }

    public static class MarkUnbreakableFactory
    extends BaseResourceFactory {
        public MarkUnbreakableFactory() {
            super("mark_unbreakable", IResourceFactory.PropertyType.Effect);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropMakeUnbreakable(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.setDescription("Makes the Block Unbreakable");
            map.addElement(new BooleanElement("set", true, "Decides if the Block should be made unbreakable or remove the Unbreakable modifier"));
            return map;
        }
    }
}

