/*
 * Decompiled with CFR 0.152.
 */
package scavenge.world.blockConditions;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.ChoiceElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.math.IMathOperation;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.JsonUtil;
import scavenge.core.math.operation.InRangeOperation;
import scavenge.core.math.operation.NotInRangeOperation;

public class PropYLevel
extends BaseResourceProperty
implements IResourceCondition {
    IMathOperation operation;

    public PropYLevel(JsonObject obj) {
        super(obj, "require_Height");
        this.addSelfIncompat();
        if (obj.has("operations")) {
            this.operation = JsonUtil.getMathOperation("operations", obj);
            this.setJEIInfo(obj.get("jeiDesc").getAsString());
        } else {
            int min = JsonUtil.getOrDefault(obj, "minValue", 0);
            int max = JsonUtil.getOrDefault(obj, "maxValue", 255);
            if (JsonUtil.getOrDefault(obj, "inside", true)) {
                this.operation = new InRangeOperation(min, max);
                this.setJEIInfo("Block has to be between Y Level " + min + " - " + max);
            } else {
                this.operation = new NotInRangeOperation(min, max);
                this.setJEIInfo("Block has to be outside Y Level " + min + " - " + max);
            }
        }
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        return this.operation.matches(pos.func_177956_o());
    }

    public static class YLevelFactory
    extends BaseResourceFactory {
        public YLevelFactory() {
            super("require_Height", IResourceFactory.PropertyType.Condition);
            this.setCompatState(CompatState.INCOMPATIBLE);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropYLevel(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.setDescription("Allows to control if the Block should be inside or outside of the spawn Range");
            ChoiceElement choice = new ChoiceElement("", 2);
            choice.addElement(0, new BooleanElement("inside", true, "If the Block Needs to be inside of the Y Levels"));
            choice.addElement(0, new IntElement("minValue", 0, "The Lowest Level the Block should be at"));
            choice.addElement(0, new IntElement("maxValue", 255, "The Heighest Level the Block should be at"));
            this.addDefaultOperationText(choice, 1);
            map.addElement(choice);
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("inside", Boolean.valueOf(false));
            obj.addProperty("minValue", (Number)100);
            obj.addProperty("maxValue", (Number)128);
        }
    }
}

