/*
 * Decompiled with CFR 0.152.
 */
package scavenge.world.blockConditions;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.ChoiceElement;
import scavenge.api.autodoc.LongElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.math.IMathOperation;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.JsonUtil;
import scavenge.core.math.operation.InRangeOperation;
import scavenge.core.math.operation.NotInRangeOperation;

public class PropWorldExistence
extends BaseResourceProperty
implements IResourceCondition {
    IMathOperation operation;

    public PropWorldExistence(JsonObject obj) {
        super(obj, "require_worldExistence");
        if (obj.has("operation")) {
            this.operation = JsonUtil.getMathOperation("operations", obj);
            this.setJEIInfo(JsonUtil.getOrDefault(obj, "jeiDesc", ""));
        } else {
            int min = obj.get("minValue").getAsInt();
            int max = obj.get("maxValue").getAsInt();
            if (JsonUtil.getOrDefault(obj, "InRange", true)) {
                this.operation = new InRangeOperation(min, max);
                this.setJEIInfo("Time has to be between " + min + " and " + max);
            } else {
                this.operation = new NotInRangeOperation(min, max);
                this.setJEIInfo("Time has to be outside " + min + " and " + max);
            }
        }
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        return this.operation.matches(world.func_82737_E());
    }

    public static class WorldExistenceFactory
    extends BaseResourceFactory {
        public WorldExistenceFactory() {
            super("require_worldExistence", IResourceFactory.PropertyType.Condition);
            this.setCompatState(CompatState.PARTCOMPATIBLE);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropWorldExistence(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement el = super.getDocumentation();
            ChoiceElement choice = new ChoiceElement("", 2);
            choice.addElement(0, new LongElement("minValue", 0L).setDescription("Minimum Time that should be checkt for"));
            choice.addElement(0, new LongElement("maxValue", 0L).setDescription("Maximum Time that should be checkt for"));
            choice.addElement(0, new BooleanElement("inRange", true, "If the Check range should be inclusive or exclusive"));
            this.addDefaultOperationText(choice, 1);
            el.addElement(choice);
            el.setDescription("Allows to check how long the world already Existed");
            return el;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("inRange", Boolean.valueOf(true));
            obj.addProperty("minValue", (Number)0);
            obj.addProperty("maxValue", (Number)48000);
        }
    }
}

