/*
 * Decompiled with CFR 0.152.
 */
package scavenge.world.blockConditions;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.ChoiceElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.math.IMathOperation;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.JsonUtil;
import scavenge.api.utils.MathUtils;
import scavenge.core.math.operation.BiggerOperation;
import scavenge.core.math.operation.SmallerOperation;

public class PropDistanceToPosition
extends BaseResourceProperty
implements IResourceCondition {
    BlockPos position;
    IMathOperation operation;

    public PropDistanceToPosition(JsonObject obj) {
        super(obj, "require_distance");
        this.position = JsonUtil.createPosition(obj);
        if (obj.has("operations")) {
            this.operation = JsonUtil.getMathOperation("operations", obj);
            this.setJEIInfo(JsonUtil.getOrDefault(obj, "jeiDesc", ""));
        } else {
            int value = JsonUtil.getOrDefault(obj, "value", 0);
            if (JsonUtil.getOrDefault(obj, "bigger", true)) {
                this.operation = new BiggerOperation(value);
                this.setJEIInfo("Block has to be further away then " + value + " Blocks from [X=" + this.position.func_177958_n() + ", Z=" + this.position.func_177952_p() + "]");
            } else {
                this.operation = new SmallerOperation(value);
                this.setJEIInfo("Block has to be " + value + " Blocks in range from [X=" + this.position.func_177958_n() + ", Z=" + this.position.func_177952_p() + "]");
            }
        }
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        return this.operation.matches(MathUtils.getXZDistance(pos, this.position));
    }

    public static class DistanceToPositionFactory
    extends BaseResourceFactory {
        public DistanceToPositionFactory() {
            super("require_distance", IResourceFactory.PropertyType.Condition);
            this.setCompatState(CompatState.PARTCOMPATIBLE);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropDistanceToPosition(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("x", (Number)255);
            obj.addProperty("y", (Number)10);
            obj.addProperty("z", (Number)255);
            obj.addProperty("bigger", Boolean.valueOf(true));
            obj.addProperty("value", (Number)15);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.setDescription("Allows to check how far from a distance Customized Position X&Z only");
            map.addElement(new IntElement("x", 0, "The XPosition that should be checkt for"));
            map.addElement(new IntElement("y", 0, "The YPosition that should be checkt for"));
            map.addElement(new IntElement("z", 0, "The ZPosition that should be checkt for"));
            ChoiceElement choice = new ChoiceElement("", 2);
            choice.addElement(0, new BooleanElement("bigger", true, ""));
            choice.addElement(0, new IntElement("value", 0, "How big/small the distance to the Position should be"));
            this.addDefaultOperationText(choice, 1);
            map.addElement(choice);
            return map;
        }
    }
}

