/*
 * Decompiled with CFR 0.152.
 */
package scavenge.world.blockConditions;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.OptionalArrayElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.JsonUtil;

public class PropBiome
extends BaseResourceProperty
implements IResourceCondition {
    Set<Integer> ids = new HashSet<Integer>();
    boolean inverted;

    public PropBiome(JsonObject obj) {
        super(obj, "require_Biome");
        this.addSelfIncompat();
        JsonUtil.convertToPrimitive(obj.get("biomes"), new Consumer<JsonPrimitive>(){

            @Override
            public void accept(JsonPrimitive t) {
                PropBiome.this.ids.add(Biome.func_185362_a((Biome)((Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(t.getAsString())))));
            }
        });
        this.inverted = JsonUtil.getOrDefault(obj, "inverted", false);
    }

    @Override
    public boolean canCombine(IResourceProperty property) {
        return !(property instanceof PropBiome);
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        if (this.inverted) {
            return !this.ids.contains(Biome.func_185362_a((Biome)world.func_180494_b(pos)));
        }
        return this.ids.contains(Biome.func_185362_a((Biome)world.func_180494_b(pos)));
    }

    public static class RequireBiomeFactory
    extends BaseResourceFactory {
        public RequireBiomeFactory() {
            super("require_Biome", IResourceFactory.PropertyType.Condition);
            this.setCompatState(CompatState.INCOMPATIBLE);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropBiome(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.addElement(new OptionalArrayElement("biomes", new TextElement("", ""), new MapElement("")).setDescription("The Biome(s) that should be compared with"));
            map.addElement(new BooleanElement("inverted", false, "Decides if the List is a white or blacklist"));
            map.setDescription("Allows to check for biomes to white or blacklist");
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            JsonArray array = new JsonArray();
            obj.add("biomes", (JsonElement)array);
            array.add((JsonElement)new JsonPrimitive("minecraft:desert"));
            array.add((JsonElement)new JsonPrimitive("minecraft:ocean"));
            obj.addProperty("inverted", Boolean.valueOf(false));
        }
    }
}

