/*
 * Decompiled with CFR 0.152.
 */
package scavenge.utils.blockConditions;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;

public class PropIfElseCondition
extends BaseResourceProperty
implements IResourceCondition {
    IResourceCondition check;
    IResourceCondition trueValue;
    IResourceCondition falseValue;

    public PropIfElseCondition(JsonObject obj) {
        super(obj, "if_else_condition");
        this.check = this.createCondition(obj.getAsJsonObject("check"));
        this.trueValue = this.createCondition(obj.getAsJsonObject("trueValue"));
        this.falseValue = this.createCondition(obj.getAsJsonObject("falseValue"));
    }

    @Override
    public void addJEIData(IResourceProperty.IJEIBlockHandler collector) {
        collector.addExtraLayer("If Else Condition");
        collector.addInfo("If Condition is true:");
        this.check.addJEIData(collector);
        collector.addInfo("");
        collector.addInfo("Then this condition is checkt for:");
        this.trueValue.addJEIData(collector);
        collector.addInfo("");
        collector.addInfo("Else this Condition is checkt for:");
        this.falseValue.addJEIData(collector);
        collector.finishLayer();
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        if (this.check.canInteract(state, world, pos, player, leftClick, side, resourceID, client)) {
            return this.trueValue.canInteract(state, world, pos, player, leftClick, side, resourceID, client);
        }
        return this.falseValue.canInteract(state, world, pos, player, leftClick, side, resourceID, client);
    }

    public static class IfElseConditionFactory
    extends BaseResourceFactory {
        public IfElseConditionFactory() {
            super("if_else_condition", IResourceFactory.PropertyType.Condition);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropIfElseCondition(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            JsonObject data = new JsonObject();
            data.addProperty("type", "condtionID");
            obj.add("check", (JsonElement)data);
            obj.add("trueValue", (JsonElement)data);
            obj.add("falseValue", (JsonElement)data);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.addElement(new MapElement("check").setDescription("The Object for the Decider Condition"));
            map.addElement(new MapElement("trueValue").setDescription("The Object for Condition if the Decider is true"));
            map.addElement(new MapElement("falseValue").setDescription("The Object for Condition if the Decider is false"));
            map.setDescription("Allows to do make a condition that decides which condition is being used");
            return map;
        }
    }
}

