/*
 * Decompiled with CFR 0.152.
 */
package scavenge.tileentity.blockEffects;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import scavenge.api.autodoc.ArrayElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.JsonUtil;
import scavenge.api.utils.LootUtil;

public class PropAddTileItems
extends BaseResourceProperty
implements IResourceEffect {
    Map<Integer, ItemStack> slots = new LinkedHashMap<Integer, ItemStack>();
    EnumFacing side;

    public PropAddTileItems(JsonObject obj) {
        super(obj, "add_tile_items");
        this.side = EnumFacing.func_176739_a((String)JsonUtil.getOrDefault(obj, "side", null));
        JsonUtil.convertToObject(obj.get("items"), new Consumer<JsonObject>(){

            @Override
            public void accept(JsonObject t) {
                ItemStack stack = JsonUtil.createStackWithNBT(t);
                if (stack == null) {
                    throw new RuntimeException("Stack from Object [" + t + "] is null that is not allowed");
                }
                for (Integer slot : JsonUtil.convertToInts(t.get("slots"))) {
                    PropAddTileItems.this.slots.put(slot, stack);
                }
            }
        });
    }

    @Override
    public void addJEIData(IResourceProperty.IJEIBlockHandler collector) {
        collector.addExtraLayer("Adds Items into TileEntity Inventory");
        for (Map.Entry<Integer, ItemStack> entry : this.slots.entrySet()) {
            collector.addInfo(LootUtil.getStackSize(entry.getValue()) + "x " + entry.getValue().func_82833_r() + " into Slot " + entry.getKey());
        }
        collector.finishLayer();
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null || !tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            return false;
        }
        IItemHandler handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
        for (Map.Entry<Integer, ItemStack> entry : this.slots.entrySet()) {
            handler.insertItem(entry.getKey().intValue(), entry.getValue().func_77946_l(), false);
        }
        return true;
    }

    public static class AddTileItemsFactory
    extends BaseResourceFactory {
        public AddTileItemsFactory() {
            super("add_tile_items", IResourceFactory.PropertyType.Effect);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropAddTileItems(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            JsonArray slots = new JsonArray();
            slots.add((JsonElement)new JsonPrimitive((Number)0));
            slots.add((JsonElement)new JsonPrimitive((Number)5));
            slots.add((JsonElement)new JsonPrimitive((Number)2));
            slots.add((JsonElement)new JsonPrimitive((Number)6));
            slots.add((JsonElement)new JsonPrimitive((Number)1));
            JsonObject object = new JsonObject();
            object.add("slots", (JsonElement)slots);
            object.addProperty("name", "minecraft:stick");
            object.addProperty("amount", (Number)32);
            JsonArray array = new JsonArray();
            array.add((JsonElement)object);
            obj.add("items", (JsonElement)array);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement base = new MapElement("");
            base.addElement(new TextElement("name", "").setDescription("The ItemRegistryName of the Item that should be inserted"));
            base.addElement(new IntElement("meta", 0, "The Metadata of the Item that should be inserted"));
            base.addElement(new IntElement("amount", 1, "The Amount of the Item that should be inserted"));
            base.addElement(new TextElement("nbt", "").setDescription("The NBTData the Item should have. Optional"));
            base.addElement(new ArrayElement("slots", new IntElement("", 0)).setDescription("The Slots the Item should be in"));
            MapElement map = super.getDocumentation();
            map.addElement(new TextElement("side", "Null", "Which side the items should be added from"));
            map.addElement(new ArrayElement("items", map).addElement(base).setDescription("The Items that should be inserted"));
            map.setDescription("Allows to add Items into slots of a TileInventory");
            return map;
        }
    }
}

