/*
 * Decompiled with CFR 0.152.
 */
package scavenge.tileentity.blockEffects;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.JsonUtil;

public class PropAddTileFluid
extends BaseResourceProperty
implements IResourceEffect {
    FluidStack fluid;

    public PropAddTileFluid(JsonObject obj) {
        super(obj, "tile_add_fluid");
        this.fluid = JsonUtil.createFluidStack(obj);
        if (this.fluid == null) {
            throw new RuntimeException("Object [" + obj + "] is causing a Null Fluid thats not allowed");
        }
        this.setJEIInfo("Consumes from TileEntity " + this.fluid.amount + "");
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null || !tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            return false;
        }
        IFluidHandler handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
        return handler.fill(this.fluid.copy(), true) >= this.fluid.amount;
    }

    public static class AddTileFluidFactory
    extends BaseResourceFactory {
        public AddTileFluidFactory() {
            super("tile_add_fluid", IResourceFactory.PropertyType.Effect);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropAddTileFluid(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("name", "minecraft:water");
            obj.addProperty("amount", (Number)1000);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.setDescription("Allows to Fill Fluid to the TileEntity");
            map.addElement(new TextElement("name", "").setDescription("The Fluid Registry name of the Fluid that should be added"));
            map.addElement(new IntElement("amount", 1000, "How much the liquid should be added"));
            return map;
        }
    }
}

