/*
 * Decompiled with CFR 0.152.
 */
package scavenge.score.blockConditions;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.ChoiceElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.math.IMathOperation;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.JsonUtil;
import scavenge.core.math.operation.BiggerOperation;
import scavenge.core.math.operation.SmallerOperation;

public class PropHasScore
extends BaseResourceProperty
implements IResourceCondition {
    String id;
    IMathOperation operation;

    public PropHasScore(JsonObject obj) {
        super(obj, "has_score");
        this.id = obj.get("name").getAsString();
        if (obj.has("operations")) {
            this.operation = JsonUtil.getMathOperation("operations", obj);
            this.setJEIInfo(JsonUtil.getOrDefault(obj, "jeiDesc", ""));
        } else {
            int value = JsonUtil.getOrDefault(obj, "amount", 0);
            if (JsonUtil.getOrDefault(obj, "bigger", true)) {
                this.operation = new BiggerOperation(value);
                this.setJEIInfo("Player has to have " + value + " Points for [" + this.id + "] Score");
            } else {
                this.operation = new SmallerOperation(value);
                this.setJEIInfo("Player has to be bewlo " + value + " Points for [" + this.id + "] Score");
            }
        }
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        return this.operation.matches(this.getScore(world, player, this.id).func_96652_c());
    }

    public Score getScore(World world, EntityPlayer player, String id) {
        Scoreboard board = world.func_96441_U();
        return board.func_96529_a(player.func_70005_c_(), board.func_96518_b(id));
    }

    public static class HasScoreFactory
    extends BaseResourceFactory {
        public HasScoreFactory() {
            super("has_score", IResourceFactory.PropertyType.Condition);
            this.setCompatState(CompatState.PARTCOMPATIBLE);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropHasScore(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("name", "exampleScore");
            obj.addProperty("bigger", Boolean.valueOf(true));
            obj.addProperty("value", (Number)100);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.addElement(new TextElement("name", "").setDescription("The Score ID that should be compared with"));
            ChoiceElement choice = new ChoiceElement("", 2);
            choice.addElement(0, new BooleanElement("bigger", true, "If the Score should be bigger or smaller then the requested value"));
            choice.addElement(0, new IntElement("value", 0, "how big or small the score should be"));
            this.addDefaultOperationText(choice, 1);
            map.addElement(choice);
            map.setDescription("Allows to check the if the player has a certain score");
            return map;
        }
    }
}

