/*
 * Decompiled with CFR 0.152.
 */
package scavenge.player.blockMixed;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.IntCounter;
import scavenge.api.utils.JsonUtil;
import scavenge.api.world.IDelivered;

public class PropClicksPerTick
extends BaseResourceProperty
implements IResourceCondition,
IResourceEffect {
    int limit;
    long time;
    int adding;
    String id;

    public PropClicksPerTick(JsonObject obj) {
        super(obj, "clicks_per_time");
        this.limit = JsonUtil.getOrDefault(obj, "tabs", 1);
        this.time = JsonUtil.getOrDefault(obj, "time", 1);
        this.adding = JsonUtil.getOrDefault(obj, "amount", 1);
        if (this.adding == 0) {
            this.adding = 1;
        }
        this.id = JsonUtil.getOrDefault(obj, "trackerID", null);
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        String realID = this.id == null ? resourceID : this.id;
        long maxTime = this.getLastTime(world, realID) + this.time;
        if (maxTime > world.func_82737_E()) {
            int count = this.getCounter(world, realID).get().getCurrentValue();
            return count + this.adding <= this.limit;
        }
        this.setLastTime(world, realID, world.func_82737_E());
        IDelivered<IntCounter> counter = this.getCounter(world, realID);
        counter.get().setValue(0);
        counter.onChanged();
        return true;
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        IDelivered<IntCounter> counter = this.getCounter(world, this.id == null ? resourceID : this.id);
        counter.get().change(this.adding, 0, this.limit);
        counter.onChanged();
        return false;
    }

    public IDelivered<IntCounter> getCounter(World world, String id) {
        return this.getHandler(world).getCounter(id);
    }

    public long getLastTime(World world, String id) {
        return this.getHandler(world).getCustomData(id).get().func_74763_f("time");
    }

    public void setLastTime(World world, String id, long value) {
        IDelivered<NBTTagCompound> nbt = this.getHandler(world).getCustomData(id);
        nbt.get().func_74772_a("time", value);
        nbt.onChanged();
    }

    public static class ClicksPerTickFactory
    extends BaseResourceFactory {
        public ClicksPerTickFactory() {
            super("clicks_per_time", IResourceFactory.PropertyType.ConditionEffect);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropClicksPerTick(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("tabs", (Number)100);
            obj.addProperty("time", (Number)20);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.setDescription("Allows to check how often a Block was clickt per a certain amount of time");
            map.addElement(new IntElement("tabs", 1, "How many Clicks per tick should be allowed"));
            map.addElement(new IntElement("time", 1, "How many game ticks between the Click Limit should be"));
            map.addElement(new IntElement("amount", 1, "How many Clicks should be 1 click worth"));
            map.addElement(new TextElement("trackerID", "ResourceID", "Which id the click per time should have"));
            return map;
        }
    }
}

