/*
 * Decompiled with CFR 0.152.
 */
package scavenge.player.blockEffects;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import scavenge.api.ScavengeAPI;
import scavenge.api.autodoc.ArrayElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.CommandWrapper;
import scavenge.api.utils.JsonUtil;

public class PropUseCommand
extends BaseResourceProperty
implements IResourceEffect {
    String command;

    public PropUseCommand(JsonObject obj) {
        super(obj, "use_command");
        final StringBuilder builder = new StringBuilder();
        builder.append("/" + obj.get("name").getAsString());
        JsonUtil.convertToPrimitive(obj.get("arguments"), new Consumer<JsonPrimitive>(){

            @Override
            public void accept(JsonPrimitive t) {
                builder.append(" ");
                String text = t.getAsString();
                if (text.startsWith("nbt:")) {
                    NBTTagCompound nbt = ScavengeAPI.INSTANCE.getCompound(text.substring(text.indexOf(":") + 1));
                    if (nbt == null) {
                        throw new RuntimeException("NBT for the id [" + text + "] is null that is not allowed");
                    }
                    builder.append(nbt.toString());
                } else {
                    builder.append(text);
                }
            }
        });
        this.command = builder.toString();
        this.setJEIInfo("Activates a Command");
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        server.func_71187_D().func_71556_a((ICommandSender)new CommandWrapper(player, pos), this.command);
        return true;
    }

    public static class UseCommandFactory
    extends BaseResourceFactory {
        public UseCommandFactory() {
            super("use_command", IResourceFactory.PropertyType.Effect);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropUseCommand(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("name", "time");
            JsonArray array = new JsonArray();
            obj.add("arguments", (JsonElement)array);
            array.add((JsonElement)new JsonPrimitive("set"));
            array.add((JsonElement)new JsonPrimitive("day"));
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.addElement(new TextElement("name", "").setDescription("The Command name that should be executed"));
            map.addElement(new ArrayElement("arguments", new TextElement("", "")).setDescription("The Arguments for the command if a argument starts with 'nbt:' then it will access the NBTFiles to load NBTData"));
            map.setDescription("Allows to send a command at the Blocks position as admin");
            return map;
        }
    }
}

