/*
 * Decompiled with CFR 0.152.
 */
package scavenge.player.blockEffects;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.JsonUtil;

public class PropSetAirLevel
extends BaseResourceProperty
implements IResourceEffect {
    int level;

    public PropSetAirLevel(JsonObject obj) {
        super(obj, "set_air_level");
        this.level = JsonUtil.getOrDefault(obj, "amount", 300);
        this.setJEIInfo("Sets the Players air to [" + this.level + "]");
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        player.func_70050_g(this.level);
        return false;
    }

    public static class SetAirLevelFactory
    extends BaseResourceFactory {
        public SetAirLevelFactory() {
            super("set_air_level", IResourceFactory.PropertyType.Effect);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropSetAirLevel(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("amount", (Number)200);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.setDescription("Allows to set the Players Air Level [between -10 and 300]");
            map.addElement(new IntElement("amount", 300, "The Air Value that should be set"));
            return map;
        }
    }
}

