/*
 * Decompiled with CFR 0.152.
 */
package scavenge.player.blockEffects;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.DoubleElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.EffectContainer;
import scavenge.api.block.IResourceEffect;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.JsonUtil;
import scavenge.api.utils.LootUtil;

public class PropDamageItem
extends BaseResourceProperty
implements IResourceEffect {
    int amount;
    double chance;
    boolean offHand;

    public PropDamageItem(JsonObject obj) {
        super(obj, "damage_item");
        this.addIncompat("consume_item");
        this.amount = obj.get("amount").getAsInt();
        this.chance = JsonUtil.getOrDefault(obj, "chance", 100.0);
        this.offHand = JsonUtil.getOrDefault(obj, "offHand", false);
        this.setJEIInfo("Applies " + this.amount + " Damage to the " + (this.offHand ? "Off" : "Main") + " held item with a [" + this.chance + "%] chance");
    }

    @Override
    public boolean applyEffects(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean left, EnumFacing side, String resourceID, EffectContainer container) {
        ItemStack stack = player.func_184586_b(this.offHand ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND);
        if (LootUtil.isStackEmpty(stack)) {
            return false;
        }
        if (this.chance >= world.field_73012_v.nextDouble() * 100.0) {
            stack.func_77972_a(this.amount, (EntityLivingBase)player);
            return true;
        }
        return false;
    }

    public static class DamageItemFactory
    extends BaseResourceFactory {
        public DamageItemFactory() {
            super("damage_item", IResourceFactory.PropertyType.Effect);
            this.addIncompat("consume_item", CompatState.INCOMPATIBLE);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropDamageItem(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("amount", (Number)1);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.setDescription("Allows to damage the held item");
            map.addElement(new IntElement("amount", 0).setDescription("How much damage should be applied"));
            map.addElement(new DoubleElement("chance", 100.0, "How likely it is that the damage gets applied"));
            map.addElement(new BooleanElement("offHand", false, "If the Item should be damaged from the Main or OffHand"));
            return map;
        }
    }
}

