/*
 * Decompiled with CFR 0.152.
 */
package scavenge.player.blockEffects;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.OptionalArrayElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.JsonUtil;
import scavenge.api.utils.StackObject;

public class PropConsumeRandomItem
extends BaseResourceProperty
implements IResourceCondition {
    List<StackWeight> list = new ArrayList<StackWeight>();
    int totalWeight = 0;

    public PropConsumeRandomItem(JsonObject obj) {
        super(obj, "consume_random_item");
        JsonUtil.convertToObject(obj.get("items"), new Consumer<JsonObject>(){

            @Override
            public void accept(JsonObject t) {
                StackObject obj = JsonUtil.createStackObject(t);
                if (obj == null) {
                    throw new RuntimeException("Object [" + t + "] Caused a Null Object.");
                }
                int weight = t.get("weight").getAsInt();
                PropConsumeRandomItem.this.list.add(new StackWeight(weight, obj));
                PropConsumeRandomItem.this.totalWeight += weight;
            }
        });
        this.setJEIInfo("Consumes a Random Item from your Inventory");
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        return ((StackWeight)WeightedRandom.func_76273_a((Random)world.field_73012_v, this.list, (int)this.totalWeight)).consumeFromPlayer(player.field_71071_by);
    }

    public static class ConsumeRandomItemFactory
    extends BaseResourceFactory {
        public ConsumeRandomItemFactory() {
            super("consume_random_item", IResourceFactory.PropertyType.Effect);
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropConsumeRandomItem(obj);
        }

        @Override
        public void addExample(JsonObject obj) {
            JsonObject item = new JsonObject();
            item.addProperty("name", "minecraft:stick");
            item.addProperty("amount", (Number)32);
            item.addProperty("weight", (Number)125);
            JsonArray array = new JsonArray();
            array.add((JsonElement)item);
            obj.add("items", (JsonElement)array);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement item = new MapElement("");
            item.addElement(new TextElement("name", "").setDescription("The Item that should be consumed"));
            item.addElement(new IntElement("meta", Short.MAX_VALUE, "The Metadata of the item that should be consumed 32767 = any meta"));
            item.addElement(new IntElement("amount", 1, "How many items should be consumed"));
            item.addElement(new TextElement("nbt", "null", "The NBTData the item should have that should be consumed"));
            item.addElement(new IntElement("weight", 0).setDescription("The Weight how likely it is that this item should be consumed"));
            MapElement map = super.getDocumentation();
            map.addElement(new OptionalArrayElement("items", item));
            map.setDescription("Allows to consume 1 random item out of the Players inventory");
            return map;
        }
    }

    public static class StackWeight
    extends WeightedRandom.Item {
        StackObject obj;

        public StackWeight(int itemWeightIn, StackObject obj) {
            super(itemWeightIn);
            this.obj = obj;
        }

        public boolean consumeFromPlayer(InventoryPlayer player) {
            return player.func_174925_a(this.obj.getItem(), this.obj.getMeta() == Short.MAX_VALUE ? -1 : this.obj.getMeta(), this.obj.getStackize(), this.obj.getNbt()) > 0;
        }
    }
}

