/*
 * Decompiled with CFR 0.152.
 */
package scavenge.player.blockConditions;

import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BooleanElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.utils.CompatState;
import scavenge.api.utils.JsonUtil;
import scavenge.api.utils.LootUtil;

public class PropRequireEmptyHand
extends BaseResourceProperty
implements IResourceCondition {
    boolean required;
    boolean offHand;

    public PropRequireEmptyHand(JsonObject obj) {
        super(obj, "require_empty_hand");
        this.addIncompats("require_item", "require_item_list", "require_tool");
        this.required = JsonUtil.getOrDefault(obj, "required", true);
        this.offHand = JsonUtil.getOrDefault(obj, "offHand", false);
        this.setJEIInfo(this.required ? "Player requires the " + (this.offHand ? "Off" : "Main") + " hand to be Empty" : "Player requires any Item in the main Hand");
    }

    @Override
    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        return LootUtil.isStackEmpty(player.func_184586_b(this.offHand ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND)) == this.required;
    }

    public static class RequireEmptyHandFactory
    extends BaseResourceFactory {
        public RequireEmptyHandFactory() {
            super("require_empty_hand", IResourceFactory.PropertyType.Condition);
            this.setCompatState(CompatState.PARTCOMPATIBLE);
            this.addIncompats(CompatState.INCOMPATIBLE, "require_item", "require_item_list", "require_tool");
        }

        @Override
        public IResourceProperty createObject(JsonObject obj) {
            return new PropRequireEmptyHand(obj);
        }

        @Override
        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.addElement(new BooleanElement("required", true, "If the players hand should be empty or any item"));
            map.addElement(new BooleanElement("offHand", false, "If the Offhand or MainHand Should be empty or not"));
            map.setDescription("Allows to Check if the players hand is empty or not");
            return map;
        }

        @Override
        public void addExample(JsonObject obj) {
            obj.addProperty("required", Boolean.valueOf(true));
        }
    }
}

